/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.apex.importer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.dbtools.raptor.apex.importer.ApexImportArb;
import oracle.dbtools.raptor.apex.importer.ApexImporter;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OraclePreparedStatement;

public class ApexImportFinalPanel
extends DefaultTraversablePanel {
    private static final Logger LOGGER = Logger.getLogger(ApexImporter.class.getName());
    private Context _ctx;
    private DBObject _dbo;
    private TraversableContext _dataCtx;
    private String _filename;
    private GridBagConstraints _gbc;
    private File _fileTo;
    private Connection _fromConn;
    private Connection _toConn;
    private boolean _finished = false;
    private ScriptRunner _sr;

    public ApexImportFinalPanel() {
        this.setLayout(new GridBagLayout());
        this.setDefaultTitle(ApexImportArb.getString(3));
    }

    public void addPair(String string, Object object) {
        ++this._gbc.gridy;
        this.add(new JLabel(string), this._gbc);
        ++this._gbc.gridx;
        if (object instanceof String) {
            this.add(new JLabel(object.toString()), this._gbc);
        } else {
            this.add((Component)object, this._gbc);
        }
        this._gbc.gridwidth = 1;
        this._gbc.gridx = 0;
    }

    public void onEntry(TraversableContext traversableContext) {
        this._finished = false;
        this._gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(2, 1, 2, 0), 0, 0);
        this._ctx = (Context)traversableContext.get("CONTEXT");
        this._dbo = (DBObject)this._ctx.getProperty("DB_OBJECT");
        this._dataCtx = traversableContext;
        this._filename = (String)traversableContext.get("FILENAME");
        this._fromConn = this._dbo.getConnection();
        if (traversableContext.get("connection") == null) {
            this._toConn = this._fromConn;
        } else {
            try {
                this._toConn = Connections.getInstance().getConnection((String)traversableContext.get("connection"));
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
            }
        }
        this.removeAll();
        this.init();
    }

    public void init() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("p_alias", (String)this._dataCtx.get("p_alias"));
        hashMap.put("p_build_status", (String)this._dataCtx.get("p_build_status"));
        hashMap.put("p_id", (String)this._dataCtx.get("p_id"));
        hashMap.put("p_name", (String)this._dataCtx.get("p_name"));
        hashMap.put("offset", this._dataCtx.get("offset").toString());
        hashMap.put("sgid", (String)this._dataCtx.get("sgid"));
        String string = null;
        try {
            string = this._toConn.getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        hashMap.put("p_owner", string);
        File file = null;
        try {
            file = new File(this._filename);
            this._fileTo = File.createTempFile("apex", ".sql");
        }
        catch (IOException iOException) {
            ExceptionHandler.handleException((Exception)iOException);
        }
        ApexImporter.processFile(file, this._fileTo, hashMap);
        if (this._dataCtx.get("connection") != null) {
            String string2 = ApexImportArb.getString(35);
            Connections.getInstance();
            this.addPair(string2, Connections.getConnectionName((String)this._dataCtx.get("connection")));
        }
        this.addPair(ApexImportArb.getString(7), string);
        if (this._dataCtx.get("connection") != null) {
            this.addPair(ApexImportArb.getString(30), (String)this._dataCtx.get("workspace_name"));
        }
        this.addPair(ApexImportArb.getString(11), (String)this._dataCtx.get("p_id"));
        this.addPair(ApexImportArb.getString(17), (String)this._dataCtx.get("p_name"));
        this.addPair(ApexImportArb.getString(18), (String)this._dataCtx.get("p_alias"));
        this.addPair(ApexImportArb.getString(8), (String)this._dataCtx.get("p_build_status"));
        this.addPair(ApexImportArb.getString(25), this._fileTo.getAbsolutePath());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (!this._finished && traversableContext.getDirection() == 1) {
            this.runFileInDialog(traversableContext, this._fileTo, this._toConn, ApexImportArb.getString(37), ApexImportArb.getString(36));
            throw new TraversalException(null);
        }
    }

    public void runFileInDialog(TraversableContext traversableContext, File file, Connection connection, String string, String string2) {
        final File file2 = file;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        final String string3 = string2;
        final String string4 = string;
        final TraversableContext traversableContext2 = traversableContext;
        final DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Installing", null, 500, null, (Component)basicEditorPane);
        basicEditorPane.setText("");
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;

            public void cancel() {
                ApexImportFinalPanel.this._sr.interrupt();
                this._isCanceled = true;
            }

            public Object doWork() {
                boolean bl;
                String string;
                Object var1_1 = null;
                String string2 = "@" + file2.getAbsolutePath();
                ApexImportFinalPanel.this.run(basicEditorPane, string2, connection2, delayedProgressRunnable);
                if (!ApexImportFinalPanel.this._sr.getScriptRunnerContext().getExited() && traversableContext2.get("SCRIPT.RUN").equals(ApexImportArb.getString(41))) {
                    StringBuilder stringBuilder = new StringBuilder();
                    try {
                        string = (OraclePreparedStatement)connection2.prepareStatement("select sql_script from APEX_APPLICATION_SUPP_OBJ_SCR where application_id = :APPLICATION_ID and nvl(script_type,'Install') = 'Install' order by EXECUTION_SEQUENCE");
                        string.setStringAtName("APPLICATION_ID", (String)traversableContext2.get("p_id"));
                        ResultSet resultSet = string.executeQuery();
                        while (resultSet.next()) {
                            stringBuilder.append(resultSet.getString(1));
                            stringBuilder.append("\n");
                        }
                    }
                    catch (SQLException sQLException) {
                        ExceptionHandler.handleException((Exception)sQLException);
                    }
                    delayedProgressRunnable.getProgressPanel().setMessage(ApexImportArb.getString(47));
                    ApexImportFinalPanel.this.run(basicEditorPane, stringBuilder.toString(), connection2, delayedProgressRunnable);
                    try {
                        connection2.commit();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                int n = ApexImportFinalPanel.this._sr.getScriptRunnerContext().getSqlError();
                string = (String)ApexImportFinalPanel.this._sr.getScriptRunnerContext().getProperty("sqldev.last.err.name");
                boolean bl2 = bl = ApexImportFinalPanel.this._sr.getScriptRunnerContext().getProperty("sqldev.error") == null ? false : (Boolean)ApexImportFinalPanel.this._sr.getScriptRunnerContext().getProperty("sqldev.error");
                if (n != 0 || string != null || ApexImportFinalPanel.this._sr.getScriptRunnerContext().getExited() || bl) {
                    ScriptUtils.showError(basicEditorPane);
                } else if (string4 != null && string3 != null) {
                    ApexImportFinalPanel.this._finished = true;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            WizardDialog wizardDialog = (WizardDialog)traversableContext2.get("WIZ");
                            if (wizardDialog != null) {
                                wizardDialog.setVisible(false);
                                wizardDialog.dispose();
                            }
                        }
                    });
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string3, (String)string4, null);
                }
                return var1_1;
            }

            public void finish(Object object) {
                file2.deleteOnExit();
                if (this._isCanceled) {
                    try {
                        connection2.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe("Could not rollback");
                    }
                }
            }

            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                delayedProgressRunnable.setRunnable(iDelayedProgressRunnable);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    private void run(BasicEditorPane basicEditorPane, String string, Connection connection, DelayedProgressRunnable delayedProgressRunnable) {
        this._sr = new ScriptRunner(string, connection);
        basicEditorPane.setEditable(true);
        this._sr.setScriptRunnerContext(new ScriptRunnerContext());
        this._sr.getScriptRunnerContext().setSubstitutionChar('^');
        this._sr.getScriptRunnerContext().setSubstitutionOn(false);
        this._sr.getScriptRunnerContext().setScanOn(false);
        PipedInputStream pipedInputStream = new PipedInputStream();
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
        }
        catch (IOException iOException) {
            LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
        }
        this._sr.setOut(bufferedOutputStream);
        this._sr.start();
        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
        outputRedirector.setName("Script output reader");
        outputRedirector.setProgressPanel(delayedProgressRunnable.getProgressPanel());
        outputRedirector.start();
        basicEditorPane.setEditable(false);
        while (this._sr.isAlive()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

