/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.ExportFileChooser;
import oracle.dbtools.raptor.config.StartupFileChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.GlobalSettings;

public class DatabaseInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox m_chkDateTime = new JCheckBox();
    private JCheckBox m_chkGlogin = new JCheckBox();
    private ExportFileChooser m_exportDir = new ExportFileChooser();
    private StartupFileChooser m_startupFileChooser = new StartupFileChooser();

    public DatabaseInfo() {
        this.setHelpID("f1_cdbdprefdatabaseconnections_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.removeAll();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.m_chkGlogin.setSelected(dBConfig.getBoolean("GLOGIN"));
        this.m_startupFileChooser.setEnabled(this.m_chkGlogin.isSelected());
        GlobalSettings globalSettings = GlobalSettings.createGlobalSettings((PropertyStorage)traversableContext.getPropertyStorage());
        this.m_chkDateTime.setSelected(globalSettings.isValidateDateTime());
        this.m_exportDir.onEntry(traversableContext);
        this.m_startupFileChooser.onEntry(traversableContext);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("GLOGIN", this.m_chkGlogin.isSelected());
        GlobalSettings globalSettings = GlobalSettings.createGlobalSettings((PropertyStorage)traversableContext.getPropertyStorage());
        boolean bl = this.m_chkDateTime.isSelected();
        globalSettings.setValidateDateTime(bl);
        this.m_exportDir.onExit(traversableContext);
        this.m_startupFileChooser.onExit(traversableContext);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_chkDateTime, (String)ConnectionArb.getString(90));
        ResourceUtils.resButton((AbstractButton)this.m_chkGlogin, (String)ConnectionArb.getString(108));
        this.add(this.m_chkDateTime, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_exportDir), new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.m_chkGlogin, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_startupFileChooser), new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_chkGlogin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    DatabaseInfo.this.m_startupFileChooser.setPathField(DatabaseInfo.this.m_startupFileChooser.getStartFile("").toString());
                } else {
                    DatabaseInfo.this.m_startupFileChooser.setPathField("");
                }
                DatabaseInfo.this.m_startupFileChooser.enable(jCheckBox.isSelected());
            }
        });
    }
}

