/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;

public final class ExportFileChooser
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblSqlPlusPath = new JLabel();
    private JTextField tfSqlPlusPath = new FileField();
    private JButton btnBrowse = new JButton();
    private GridBagLayout layMain = new GridBagLayout();

    public ExportFileChooser() {
        try {
            this.jbInit();
            this.setHelpID("f1_defaultsqlplusdir_html");
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.tfSqlPlusPath.setText(dBConfig.getString("EXPORTDIR"));
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("EXPORTDIR", this.tfSqlPlusPath.getText());
    }

    public JTextField getPathField() {
        return this.tfSqlPlusPath;
    }

    private void jbInit() throws Exception {
        String string = PreferencesArb.getString(71);
        ResourceUtils.resLabel((JLabel)this.lblSqlPlusPath, (Component)this.tfSqlPlusPath, (String)string);
        string = PreferencesArb.getString(7);
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)string);
        this.btnBrowse.setMnemonic('w');
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExportFileChooser.this.btnBrowse_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.layMain);
        this.add(this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.tfSqlPlusPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.lblSqlPlusPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void btnBrowse_actionPerformed(ActionEvent actionEvent) {
        File file;
        File file2 = DBConfig.getInstance().getString("DEFAULTPATH") == null ? new File(Ide.getTrueUserHomeDirectory()) : new File(DBConfig.getInstance().getString("DEFAULTPATH"));
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Select Directory");
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.tfSqlPlusPath.setText(file.toString());
        }
    }
}

