/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.text.OraTerritory;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.dialogs.MessageDialog;

public class NLSInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JComboBox lang = new JComboBox();
    private static String[] _lang;
    private JComboBox terr = new JComboBox();
    private static String[] _terr;
    private JComboBox sort = new JComboBox();
    private static String[] _sort;
    private JComboBox nlsComp = new JComboBox();
    private static String[] _nlsComp;
    private JComboBox dateLang = new JComboBox();
    private static String[] _dateLang;
    private JTextField dateFormat = new JTextField();
    private JTextField TsFormat = new JTextField();
    private JTextField TsTzFormat = new JTextField();
    private JTextField decSep = new JTextField();
    private JTextField grpSep = new JTextField();
    private JTextField currency = new JTextField();
    private JComboBox isoCur = new JComboBox();
    private static String[] _isoCur;
    private JComboBox len = new JComboBox();
    private static String[] _len;
    private TraversableContext m_ctx;
    private boolean dateFormatOK = true;
    private boolean timestampOK = true;
    private boolean timestampTZOK = true;

    public NLSInfo() {
        this.setHelpID("f1_dbprefnlsinfo_html");
        _lang = OraLocaleInfo.getAvailableLanguages();
        _terr = OraLocaleInfo.getAvailableTerritories();
        String[] stringArray = OraLocaleInfo.getAvailableLinguisticSorts();
        _sort = new String[stringArray.length + 2];
        NLSInfo._sort[0] = "BINARY";
        NLSInfo._sort[1] = "BINARY_CI";
        System.arraycopy(stringArray, 0, _sort, 2, stringArray.length);
        _nlsComp = new String[]{"BINARY", "ANSI", "LINGUISTIC"};
        _dateLang = OraLocaleInfo.getAvailableLanguages();
        _isoCur = OraLocaleInfo.getAvailableTerritories();
        _len = new String[]{"BYTE", "CHAR"};
        this.init();
    }

    private boolean validMask(String string) {
        try {
            OraSimpleDateFormat oraSimpleDateFormat = new OraSimpleDateFormat(string, OraLocaleInfo.getDefault());
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.lang.setModel(new DefaultComboBoxModel<String>(_lang));
        this.lang.setSelectedItem(dBConfig.getString("NLS_LANG"));
        this.terr.setModel(new DefaultComboBoxModel<String>(_terr));
        this.terr.setSelectedItem(dBConfig.getString("NLS_TERR"));
        this.sort.setModel(new DefaultComboBoxModel<String>(_sort));
        this.sort.setSelectedItem(dBConfig.getString("NLS_SORT"));
        this.nlsComp.setModel(new DefaultComboBoxModel<String>(_nlsComp));
        this.nlsComp.setSelectedItem(dBConfig.getString("NLS_COMP"));
        this.dateLang.setModel(new DefaultComboBoxModel<String>(_dateLang));
        this.dateLang.setSelectedItem(dBConfig.getString("NLS_DATE_LANG"));
        this.dateFormat.setText(dBConfig.getString("NLS_DATE_FORM"));
        this.TsFormat.setText(dBConfig.getString("NLS_TS_FORM"));
        this.TsTzFormat.setText(dBConfig.getString("NLS_TS_TZ_FORM"));
        this.decSep.setText(dBConfig.getString("NLS_DEC_SEP"));
        this.grpSep.setText(dBConfig.getString("NLS_GRP_SEP"));
        this.currency.setText(dBConfig.getString("NLS_CURR"));
        this.isoCur.setModel(new DefaultComboBoxModel<String>(_isoCur));
        this.isoCur.setSelectedItem(dBConfig.getString("NLS_ISO_CURR"));
        this.len.setModel(new DefaultComboBoxModel<String>(_len));
        this.len.setSelectedItem(dBConfig.getString("NLS_LENGTH"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("NLS_LANG", (String)this.lang.getSelectedItem());
        dBConfig.putString("NLS_TERR", (String)this.terr.getSelectedItem());
        dBConfig.putString("NLS_SORT", (String)this.sort.getSelectedItem());
        dBConfig.putString("NLS_COMP", (String)this.nlsComp.getSelectedItem());
        dBConfig.putString("NLS_DATE_LANG", (String)this.dateLang.getSelectedItem());
        dBConfig.putString("NLS_DATE_FORM", this.dateFormat.getText());
        dBConfig.putString("NLS_TS_FORM", this.TsFormat.getText());
        dBConfig.putString("NLS_TS_TZ_FORM", this.TsTzFormat.getText());
        dBConfig.putString("NLS_DEC_SEP", this.decSep.getText());
        dBConfig.putString("NLS_GRP_SEP", this.grpSep.getText());
        dBConfig.putString("NLS_CURR", this.currency.getText());
        dBConfig.putString("NLS_ISO_CURR", (String)this.isoCur.getSelectedItem());
        dBConfig.putString("NLS_LENGTH", (String)this.len.getSelectedItem());
        this.checkFormatMasks();
    }

    private void checkFormatMasks() {
        if (!(this.dateFormatOK && this.timestampOK && this.timestampTZOK)) {
            String string = "";
            int n = 0;
            if (!this.dateFormatOK) {
                string = string + "Date Format";
                ++n;
            }
            if (!this.timestampOK) {
                if (n > 0) {
                    string = string + ",";
                }
                string = string + "Timestamp Format";
            }
            if (!this.timestampTZOK) {
                if (n > 0) {
                    string = string + ",";
                }
                string = string + "Timestamp TZ Format";
            }
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)(string + " is not valid"), (String)"Format Warning", (String)"help");
        }
    }

    public void init() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("Language");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(10, 30, 0, 10);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add(jLabel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        this.add(this.lang, gridBagConstraints2);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Territory");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.gridy = 5;
        gridBagConstraints3.gridx = 0;
        this.add(jLabel2, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 5;
        gridBagConstraints4.gridx = 1;
        this.add(this.terr, gridBagConstraints4);
        JButton jButton = new JButton("Default Values");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 0;
        gridBagConstraints5.anchor = 10;
        gridBagConstraints5.gridy = 5;
        gridBagConstraints5.gridx = 2;
        this.add(jButton, gridBagConstraints5);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OraLocaleInfo oraLocaleInfo = OraLocaleInfo.getInstance((String)NLSInfo.this.lang.getSelectedItem().toString(), (String)NLSInfo.this.terr.getSelectedItem().toString());
                OraTerritory oraTerritory = OraTerritory.getInstance((String)NLSInfo.this.lang.getSelectedItem().toString(), (String)NLSInfo.this.terr.getSelectedItem().toString());
                if (oraLocaleInfo.getLinguisticSort().indexOf("BINARY") > -1) {
                    NLSInfo.this.sort.setSelectedItem("BINARY");
                } else {
                    NLSInfo.this.sort.setSelectedItem(oraLocaleInfo.getLinguisticSort());
                }
                NLSInfo.this.nlsComp.setSelectedItem("BINARY");
                NLSInfo.this.dateLang.setSelectedItem(NLSInfo.this.lang.getSelectedItem());
                NLSInfo.this.dateFormat.setText(oraTerritory.getOracleDateFormatString());
                NLSInfo.this.TsFormat.setText(oraTerritory.getNLSTimestampFormatString());
                NLSInfo.this.TsTzFormat.setText(oraTerritory.getNLSTimestampAndTimezoneFormatString());
                NLSInfo.this.decSep.setText(oraTerritory.getDecimalCharacter());
                NLSInfo.this.grpSep.setText(oraTerritory.getGroupSeparator());
                NLSInfo.this.currency.setText(oraTerritory.getLocalCurrencySymbol());
                NLSInfo.this.isoCur.setSelectedItem(NLSInfo.this.terr.getSelectedItem().toString());
                NLSInfo.this.len.setSelectedItem("BYTE");
            }
        });
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Sort");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints6.anchor = 13;
        gridBagConstraints6.gridy = 10;
        gridBagConstraints6.gridx = 0;
        this.add(jLabel3, gridBagConstraints6);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.gridy = 10;
        gridBagConstraints7.gridx = 1;
        this.add(this.sort, gridBagConstraints7);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Comp");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints8.anchor = 13;
        gridBagConstraints8.gridy = 12;
        gridBagConstraints8.gridx = 0;
        this.add(jLabel4, gridBagConstraints8);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 2;
        gridBagConstraints9.anchor = 17;
        gridBagConstraints9.gridy = 12;
        gridBagConstraints9.gridx = 1;
        this.add(this.nlsComp, gridBagConstraints9);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Date Language");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints10.anchor = 13;
        gridBagConstraints10.gridy = 15;
        gridBagConstraints10.gridx = 0;
        this.add(jLabel5, gridBagConstraints10);
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 2;
        gridBagConstraints11.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints11.anchor = 17;
        gridBagConstraints11.gridy = 15;
        gridBagConstraints11.gridx = 1;
        this.add(this.dateLang, gridBagConstraints11);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Date Format");
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints12.anchor = 13;
        gridBagConstraints12.gridy = 20;
        gridBagConstraints12.gridx = 0;
        this.add(jLabel6, gridBagConstraints12);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.anchor = 17;
        gridBagConstraints13.gridy = 20;
        gridBagConstraints13.gridx = 1;
        this.dateFormat.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                NLSInfo.this.dateFormatOK = NLSInfo.this.validMask(string);
                NLSInfo.this.checkFormatMasks();
            }
        });
        this.add(this.dateFormat, gridBagConstraints13);
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Timestamp Format");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints14.anchor = 13;
        gridBagConstraints14.gridy = 25;
        gridBagConstraints14.gridx = 0;
        this.add(jLabel7, gridBagConstraints14);
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.anchor = 17;
        gridBagConstraints15.gridy = 25;
        gridBagConstraints15.gridx = 1;
        this.TsFormat.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                NLSInfo.this.timestampOK = NLSInfo.this.validMask(string);
                NLSInfo.this.checkFormatMasks();
            }
        });
        this.add(this.TsFormat, gridBagConstraints15);
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Timestamp TZ Format");
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints16.anchor = 13;
        gridBagConstraints16.gridy = 30;
        gridBagConstraints16.gridx = 0;
        this.add(jLabel8, gridBagConstraints16);
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.fill = 2;
        gridBagConstraints17.anchor = 17;
        gridBagConstraints17.gridy = 30;
        gridBagConstraints17.gridx = 1;
        this.TsTzFormat.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                NLSInfo.this.timestampTZOK = NLSInfo.this.validMask(string);
                NLSInfo.this.checkFormatMasks();
            }
        });
        this.add(this.TsTzFormat, gridBagConstraints17);
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Decimal Separator");
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints18.anchor = 13;
        gridBagConstraints18.gridy = 35;
        gridBagConstraints18.gridx = 0;
        this.add(jLabel9, gridBagConstraints18);
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints19.fill = 2;
        gridBagConstraints19.anchor = 17;
        gridBagConstraints19.gridy = 35;
        gridBagConstraints19.gridx = 1;
        this.add(this.decSep, gridBagConstraints19);
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Group Separator");
        GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
        gridBagConstraints20.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints20.anchor = 13;
        gridBagConstraints20.gridy = 40;
        gridBagConstraints20.gridx = 0;
        this.add(jLabel10, gridBagConstraints20);
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.fill = 2;
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.gridy = 40;
        gridBagConstraints21.gridx = 1;
        this.add(this.grpSep, gridBagConstraints21);
        JLabel jLabel11 = new JLabel();
        jLabel11.setText("Currency");
        GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
        gridBagConstraints22.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints22.anchor = 13;
        gridBagConstraints22.gridy = 45;
        gridBagConstraints22.gridx = 0;
        this.add(jLabel11, gridBagConstraints22);
        GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
        gridBagConstraints23.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints23.fill = 2;
        gridBagConstraints23.anchor = 17;
        gridBagConstraints23.gridy = 45;
        gridBagConstraints23.gridx = 1;
        this.add(this.currency, gridBagConstraints23);
        JLabel jLabel12 = new JLabel();
        jLabel12.setText("ISO Currency");
        GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
        gridBagConstraints24.insets = new Insets(0, 0, 0, 10);
        gridBagConstraints24.anchor = 13;
        gridBagConstraints24.gridy = 50;
        gridBagConstraints24.gridx = 0;
        this.add(jLabel12, gridBagConstraints24);
        GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
        gridBagConstraints25.fill = 2;
        gridBagConstraints25.anchor = 17;
        gridBagConstraints25.gridy = 50;
        gridBagConstraints25.gridx = 1;
        this.add(this.isoCur, gridBagConstraints25);
        JLabel jLabel13 = new JLabel();
        jLabel13.setText("Length");
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints26.anchor = 13;
        gridBagConstraints26.gridy = 55;
        gridBagConstraints26.gridx = 0;
        this.add(jLabel13, gridBagConstraints26);
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints27.fill = 2;
        gridBagConstraints27.anchor = 17;
        gridBagConstraints27.gridy = 55;
        gridBagConstraints27.gridx = 1;
        this.add(this.len, gridBagConstraints27);
        JLabel jLabel14 = new JLabel();
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.weighty = 1.0;
        gridBagConstraints28.weightx = 1.0;
        gridBagConstraints28.gridwidth = 2;
        gridBagConstraints28.gridy = 100;
        gridBagConstraints28.gridx = 0;
        this.add(jLabel14, gridBagConstraints28);
        JLabel jLabel15 = new JLabel();
        GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
        gridBagConstraints29.weightx = 1.0;
        gridBagConstraints29.weighty = 1.0;
        gridBagConstraints29.gridheight = 7;
        gridBagConstraints29.gridy = 100;
        gridBagConstraints29.gridx = 2;
        this.add(jLabel15, gridBagConstraints29);
    }
}

