/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.DataEditorOptionPanel;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class ObjectViewerInfo
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox autoPin = new JCheckBox();
    private JCheckBox ddlSegment = new JCheckBox();
    private JCheckBox ddlTerm = new JCheckBox();
    private JCheckBox ddlPretty = new JCheckBox();
    private JCheckBox ddlByte = new JCheckBox();
    private JCheckBox ddlForce = new JCheckBox();
    private JCheckBox ddlAlter = new JCheckBox();
    private JCheckBox ddlSchema = new JCheckBox();
    private DataEditorOptionPanel dataEditorOptionPanel = new DataEditorOptionPanel();

    public ObjectViewerInfo() {
        this.setHelpID("f1_objectviewerinfo_html");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.autoPin.setSelected(dBConfig.getBoolean("AUTOPIN"));
        this.ddlSegment.setSelected(dBConfig.getBoolean("DDL_SEGMENTS"));
        this.ddlTerm.setSelected(dBConfig.getBoolean("DDL_TERMINATOR"));
        this.ddlPretty.setSelected(dBConfig.getBoolean("DDL_PRETTY"));
        this.ddlByte.setSelected(dBConfig.getBoolean("DDL_BYTE"));
        this.ddlForce.setSelected(dBConfig.getBoolean("DDL_FORCE"));
        this.ddlAlter.setSelected(dBConfig.getBoolean("DDL_ALTER"));
        this.ddlSchema.setSelected(dBConfig.getBoolean("DDL_SCHEMA"));
        this.dataEditorOptionPanel.setFromPreferences(dBConfig);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putBoolean("AUTOPIN", this.autoPin.isSelected());
        dBConfig.putBoolean("DDL_SEGMENTS", this.ddlSegment.isSelected());
        dBConfig.putBoolean("DDL_TERMINATOR", this.ddlTerm.isSelected());
        dBConfig.putBoolean("DDL_PRETTY", this.ddlPretty.isSelected());
        dBConfig.putBoolean("DDL_BYTE", this.ddlByte.isSelected());
        dBConfig.putBoolean("DDL_FORCE", this.ddlForce.isSelected());
        dBConfig.putBoolean("DDL_ALTER", this.ddlAlter.isSelected());
        dBConfig.putBoolean("DDL_SCHEMA", this.ddlSchema.isSelected());
        this.dataEditorOptionPanel.savePreferences(dBConfig);
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.autoPin, (String)PreferencesArb.getString(37));
        ResourceUtils.resButton((AbstractButton)this.ddlSegment, (String)PreferencesArb.getString(39));
        ResourceUtils.resButton((AbstractButton)this.ddlTerm, (String)PreferencesArb.getString(40));
        ResourceUtils.resButton((AbstractButton)this.ddlPretty, (String)PreferencesArb.getString(41));
        ResourceUtils.resButton((AbstractButton)this.ddlByte, (String)PreferencesArb.getString(42));
        ResourceUtils.resButton((AbstractButton)this.ddlForce, (String)PreferencesArb.getString(43));
        ResourceUtils.resButton((AbstractButton)this.ddlAlter, (String)PreferencesArb.getString(44));
        ResourceUtils.resButton((AbstractButton)this.ddlSchema, (String)PreferencesArb.getString(45));
        this.add(this.autoPin, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(PreferencesArb.getString(38)), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        this.add(this.ddlSegment, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlTerm, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlPretty, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlByte, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlForce, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlAlter, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.ddlSchema, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.dataEditorOptionPanel, new GridBagConstraints(0, 9, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
    }
}

