/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.config.PreferencesArb;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;

public final class StartupFileChooser
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private JLabel lblSqlPlusPath = new JLabel();
    private JTextField tfSqlPlusPath = new FileField();
    private JButton btnBrowse = new JButton();
    private GridBagLayout layMain = new GridBagLayout();

    public StartupFileChooser() {
        try {
            this.jbInit();
            this.setHelpID("f1_startupfilechooser_html");
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        this.tfSqlPlusPath.setText(dBConfig.getString(""));
    }

    public void onExit(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance(traversableContext);
        dBConfig.putString("", this.tfSqlPlusPath.getText());
    }

    public JTextField getPathField() {
        return this.tfSqlPlusPath;
    }

    public void setPathField(String string) {
        this.tfSqlPlusPath.setText(string);
    }

    private void jbInit() throws Exception {
        String string = ConnectionArb.getString(109);
        ResourceUtils.resLabel((JLabel)this.lblSqlPlusPath, (Component)this.tfSqlPlusPath, (String)string);
        string = PreferencesArb.getString(7);
        ResourceUtils.resButton((AbstractButton)this.btnBrowse, (String)string);
        this.btnBrowse.setMnemonic('w');
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StartupFileChooser.this.btnBrowse_actionPerformed(actionEvent);
            }
        });
        this.setLayout(this.layMain);
        this.add(this.btnBrowse, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add(this.tfSqlPlusPath, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.lblSqlPlusPath, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void btnBrowse_actionPerformed(ActionEvent actionEvent) {
        File file;
        String string = this.tfSqlPlusPath.getText();
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(this.getStartFile(string));
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle(ConnectionArb.getString(110));
        int n = jFileChooser.showOpenDialog((Component)((Object)this));
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.tfSqlPlusPath.setText(file.toString());
        }
    }

    public File getStartFile(String string) {
        File file = null;
        if (string == null || string.equals("")) {
            File file2;
            String string2 = DBConfig.getInstance().getString("DEFAULTPATH");
            if (string2 != null && (file2 = new File(string2 + File.separator + "login.sql")).exists()) {
                file = file2;
            }
            if (file == null && System.getenv().get("SQLPATH") != null) {
                String[] stringArray;
                file2 = null;
                boolean bl = true;
                String string3 = System.getenv().get("SQLPATH");
                for (String string4 : stringArray = string3.split(File.pathSeparator)) {
                    if (bl || !file2.exists()) {
                        file2 = new File(string4 + File.separator + "login.sql");
                    }
                    bl = false;
                }
                if (file2.exists()) {
                    file = file2;
                }
            }
            if (file == null) {
                file = new File(Ide.getTrueUserHomeDirectory() + File.separator + "login.sql");
            }
        } else {
            file = new File(string);
        }
        return file;
    }

    public void enable(boolean bl) {
        this.tfSqlPlusPath.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }
}

