/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.raptor.connections.C;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.connections.T;
import oracle.dbtools.raptor.navigator.xml.ConnectionType;
import oracle.dbtools.raptor.navigator.xml.ConnectionTypeDetails;
import oracle.dbtools.raptor.navigator.xml.NavigatorHook;
import oracle.javatools.util.PlatformUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionTypeRegistry {
    private static List<T> _panels = new ArrayList<T>();
    private static boolean s_inited;
    private static final String access = "ACCESS";

    public static synchronized void registerConnectionType(String string, Class<? extends IConnectionPanel> clazz, ConnectionTypeDetails connectionTypeDetails) {
        _panels.add(new T(string, clazz, connectionTypeDetails));
    }

    public static synchronized IConnectionPanel getPanelFor(String string) throws InstantiationException, IllegalAccessException {
        ConnectionTypeRegistry.init();
        for (T t : _panels) {
            if (!t.getName().equals(string)) continue;
            return t.getPanel().newInstance();
        }
        return null;
    }

    public static ArrayList<String> getTabNames() {
        ConnectionTypeRegistry.init();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (T t : _panels) {
            arrayList.add(t.getName());
        }
        return arrayList;
    }

    private static void init() {
        boolean bl = true;
        if (!s_inited) {
            Iterator<ConnectionType> iterator = NavigatorHook.getConnectionTypes();
            while (iterator.hasNext()) {
                ConnectionType connectionType = iterator.next();
                ConnectionTypeDetails connectionTypeDetails = connectionType.getImpl();
                String string = connectionTypeDetails.getConnectionPanelLabel();
                String string2 = connectionTypeDetails.getType();
                if (string == null) continue;
                String string3 = connectionTypeDetails.getConnectionPanel();
                boolean bl2 = bl = PlatformUtils.isWindows() || !string2.equals(access);
                if (string3 == null || !bl) continue;
                try {
                    Class<?> clazz = Class.forName(string3);
                    ConnectionTypeRegistry.registerConnectionType(string, clazz, connectionTypeDetails);
                }
                catch (Exception exception) {}
            }
            s_inited = true;
        }
        Collections.sort(_panels, new C());
    }
}

