/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.connections;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLTextField;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.migration.CMConnectionsReader;

public class ImportExportPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
DocumentListener,
FocusListener {
    private static final long serialVersionUID = 0L;
    private static final String BROWSE_ACTION = "BROWSE";
    private static final String FIELD_ACTION = "FIELD";
    public boolean oldCM = false;
    public static final WildcardURLFilter PROPS_FILTER = new WildcardURLFilter(ConnectionArb.getString(15), URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString(16));
    public static final WildcardURLFilter XML_FILTER = new WildcardURLFilter(ConnectionArb.getString(13), URLFileSystem.isLocalFileSystemCaseSensitive(), ConnectionArb.getString(14));
    private String mode = "IMPORT";
    private GridBagLayout layout = new GridBagLayout();
    private JLabel fileLabel = new JLabel();
    private URLTextField fileField = new URLTextField();
    private JButton browseButton = new JButton();
    private JLabel instructionLabel = new JLabel();
    private JScrollPane scrConns = new JScrollPane();
    private JList connectionList = new JList();
    private MultiLineLabel hintLabel = new MultiLineLabel();
    private JLabel lblMsg = new JLabel();
    private JEWTDialog m_dlg;
    private URL _url;

    public ImportExportPanel() {
        try {
            this.jbInit();
            this.postInit();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public Component getDefaultFocus() {
        return this.fileField;
    }

    public URL getSelectedURL() {
        URL uRL = this.fileField.getURL();
        if (!URLFileSystem.isDirectoryPath((URL)uRL) && URLFileSystem.getSuffix((URL)uRL) == "") {
            URL uRL2 = URLFileSystem.getParent((URL)uRL);
            String string = URLFileSystem.getFileName((URL)uRL);
            uRL = URLFactory.newURL((URL)uRL2, (String)(string + ".xml"));
        }
        return uRL;
    }

    public Object[] getSelectedValues() {
        Object[] objectArray = this.connectionList.getSelectedValues();
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = Connections.getConnectionName((String)objectArray[i]);
        }
        return objectArray2;
    }

    void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.fileLabel, (Component)this.fileField, (String)ConnectionArb.getString(3));
        this.fileField.getDocument().addDocumentListener(this);
        this.fileField.setActionCommand(FIELD_ACTION);
        this.fileField.setDirectoryOnly(false);
        this.fileField.setColumns(32);
        ResourceUtils.resButton((AbstractButton)this.browseButton, (String)ConnectionArb.getString(4));
        this.browseButton.setActionCommand(BROWSE_ACTION);
        this.lblMsg.setForeground(Color.blue);
        this.connectionList.addListSelectionListener(this);
        this.connectionList.setCellRenderer(new ConnectionListRenderer());
        ResourceUtils.resLabel((JLabel)this.instructionLabel, (Component)this.connectionList, (String)ConnectionArb.getString(9));
        this.setLayout(this.layout);
        this.add((Component)this.hintLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.fileLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.fileField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.browseButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.instructionLabel, new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this.scrConns, new GridBagConstraints(0, 3, 3, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblMsg, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.scrConns.getViewport().add((Component)this.connectionList, null);
    }

    private void postInit() {
        this.browseButton.addActionListener(this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 300);
    }

    public void setMode(String string) {
        this.mode = string;
        String string2 = null;
        this.hintLabel.setTextWrapper(WordWrapper.getTextWrapper());
        this.hintLabel.setPreferredAspectRatio(0.0f);
        if (this.mode.equals("EXPORT")) {
            this.hintLabel.setText(ConnectionArb.getString(6));
            this.populateList();
            string2 = "f1_idedexportcxn_html";
            this.fileField.removeActionListener((ActionListener)this);
            this.fileField.removeFocusListener((FocusListener)this);
        } else {
            this.hintLabel.setText(ConnectionArb.getString(5));
            string2 = "f1_idedimportcxn_html";
            this.fileField.addActionListener((ActionListener)this);
            this.fileField.addFocusListener((FocusListener)this);
        }
        HelpSystem.getHelpSystem().registerTopic((JComponent)this, string2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (BROWSE_ACTION.equals(string)) {
            this.handleBrowse();
        } else if (FIELD_ACTION.equals(string)) {
            this.handleFile();
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateOK();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateOK();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateOK();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.handleFile();
    }

    public void addNotify() {
        super.addNotify();
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JEWTDialog)) continue;
            this.m_dlg = (JEWTDialog)container;
            break;
        }
        this.updateOK();
    }

    protected void handleBrowse() {
        String string;
        URL uRL = this.fileField.getURL();
        if (uRL != null) {
            uRL = URLFileSystem.getParent((URL)uRL);
        } else {
            string = Ide.getUserSettingsDirectory();
            uRL = URLFactory.newDirURL((String)string);
        }
        string = DialogUtil.newURLChooser((URL)uRL);
        string.clearChooseableURLFilters();
        string.setURLFilter((URLFilter)XML_FILTER);
        string.setShowJarsAsDirs(false);
        boolean bl = false;
        if (this.mode.equals("IMPORT")) {
            string.addChooseableURLFilter((URLFilter)PROPS_FILTER);
            String string2 = ConnectionArb.getString(8);
            bl = string.showOpenDialog((Component)this, string2) == 0;
        } else if (this.mode.equals("EXPORT")) {
            String string3 = ConnectionArb.getString(7);
            bl = string.showSaveDialog((Component)this, string3) == 0;
        } else {
            throw new IllegalArgumentException("should never happen");
        }
        if (!bl) {
            return;
        }
        URL uRL2 = string.getSelectedURL();
        if (uRL2 != null && !URLFileSystem.isDirectoryPath((URL)uRL2)) {
            String string4 = URLFileSystem.getSuffix((URL)uRL2);
            if (!ModelUtil.hasLength((String)string4)) {
                URL uRL3 = URLFileSystem.getParent((URL)uRL2);
                String string5 = URLFileSystem.getFileName((URL)uRL2);
                uRL2 = URLFactory.newURL((URL)uRL3, (String)(string5 + ".xml"));
            }
            this.fileField.setURL(uRL2);
            this.handleFile();
        }
    }

    protected void handleFile() {
        this.lblMsg.setText("");
        final URL uRL = this.fileField.getURL();
        if (ModelUtil.areDifferent((Object)uRL, (Object)this._url)) {
            this._url = uRL;
            if (this.mode.equals("IMPORT")) {
                WaitCursor waitCursor = null;
                JEWTDialog jEWTDialog = this.m_dlg;
                if (jEWTDialog != null) {
                    waitCursor = new WaitCursor((Component)jEWTDialog);
                    waitCursor.show();
                }
                final WaitCursor waitCursor2 = waitCursor;
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        String[] stringArray;
                        block7: {
                            stringArray = new String[]{};
                            if (URLFileSystem.exists((URL)uRL) && URLFileSystem.isRegularFile((URL)uRL)) {
                                try {
                                    DatabaseConnections databaseConnections = DatabaseConnections.getPrivateInstance((URL)uRL);
                                    File file = new File(uRL.getFile());
                                    ArrayList<String> arrayList = new ArrayList<String>();
                                    Collection collection = databaseConnections.listConnections();
                                    if (collection.size() == 0) {
                                        CMConnectionsReader cMConnectionsReader = new CMConnectionsReader(uRL.getFile(), true);
                                        if (cMConnectionsReader.read().size() > 0) {
                                            ImportExportPanel.this.oldCM = true;
                                            List list = cMConnectionsReader.read();
                                            for (Properties properties : list) {
                                                arrayList.add(properties.getProperty("ConnectionName"));
                                            }
                                        }
                                        stringArray = arrayList.toArray(new String[arrayList.size()]);
                                    } else {
                                        stringArray = databaseConnections.listConnections().toArray(new String[databaseConnections.listConnections().size()]);
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (!(throwable instanceof ThreadDeath)) break block7;
                                    throw (ThreadDeath)throwable;
                                }
                            }
                        }
                        return stringArray;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void finished() {
                        try {
                            Object object = this.get();
                            if (object instanceof String[]) {
                                String[] stringArray = (String[])object;
                                if (stringArray.length == 0) {
                                    String string = MessageFormat.format(ConnectionArb.getString(10), ImportExportPanel.this.fileField.getText());
                                    MessageDialog.error((Component)ImportExportPanel.this.fileField, (Object)string, (String)"Error", null);
                                    ImportExportPanel.this.lblMsg.setText(string);
                                    ImportExportPanel.this.populateList(stringArray);
                                    return;
                                }
                                ImportExportPanel.this.populateList(stringArray);
                            }
                        }
                        finally {
                            if (waitCursor2 != null) {
                                waitCursor2.hide();
                                waitCursor2.dispose();
                            }
                        }
                    }
                };
                swingWorker.start();
            } else {
                this.updateOK();
            }
        }
    }

    protected void populateList() {
        try {
            this.populateList(ImportExportPanel.getConnectionNames());
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
        }
    }

    protected void populateList(String[] stringArray) {
        Arrays.sort(stringArray);
        int n = stringArray.length;
        this.connectionList.setListData(stringArray);
        if (n > 0) {
            this.connectionList.setSelectionInterval(0, n - 1);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateOK();
    }

    private void updateOK() {
        boolean bl;
        boolean bl2 = bl = this.connectionList.getSelectedIndex() != -1;
        if (bl && "EXPORT".equals(this.mode)) {
            boolean bl3 = bl = this.fileField.getURL() != null;
        }
        if (this.m_dlg != null) {
            this.m_dlg.setOKButtonEnabled(bl);
        }
    }

    private static String[] getConnectionNames() throws IOException {
        return Connections.getInstance().getConnNames();
    }

    private class ConnectionListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;

        private ConnectionListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = Connections.getConnectionName((String)object);
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }
    }
}

