/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Container;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import javax.accessibility.AccessibleContext;
import javax.swing.JComboBox;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.DBConnectionNameCellRenderer;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.util.ModelUtil;

public class DBConnectionComboBox {
    private JComboBox _dbConns;
    private Connections _conns;
    private SortedComboBoxModel _model;

    public DBConnectionComboBox() {
        this.init();
    }

    public DBConnectionComboBox(Container container) {
        this.init();
        this.add(container);
    }

    public void init() {
        this._conns = Connections.getInstance();
        this._model = new SortedComboBoxModel();
        this._model.setComparator(new Comparator(){

            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(object, object2);
            }
        });
        this._dbConns = new JComboBox(this._model);
        this._dbConns.setRenderer(new DBConnectionNameCellRenderer());
        this._conns.addConnectionListener(new ConnListener());
        String string = null;
        if (EditorManager.getEditorManager().getCurrentEditor() instanceof IDBEditor) {
            try {
                Editor editor = EditorManager.getEditorManager().getCurrentEditor();
                if (editor != null && editor instanceof IDBEditor && ((IDBEditor)editor).getDatabase() != null) {
                    string = Connections.getInstance().getConnectionName(((IDBEditor)editor).getDatabase());
                }
            }
            catch (Exception exception) {
                string = null;
            }
            if (string != null) {
                this.setCurrentConnection(string);
            }
        }
        this.populate();
    }

    public void addActionListener(ActionListener actionListener) {
        this._dbConns.addActionListener(actionListener);
    }

    public void setCurrentConnection(String string) {
        if (string != null) {
            this._model.setSelectedItem((Object)string);
        } else {
            this._dbConns.setSelectedIndex(-1);
        }
        if (string != null && Connections.isUnsharedWorksheetConnection(string)) {
            this._dbConns.setEnabled(false);
        } else {
            this._dbConns.setEnabled(true);
        }
    }

    public JComboBox getJComboBox() {
        return this._dbConns;
    }

    public void add(Container container) {
        container.add(this._dbConns);
    }

    public AccessibleContext getAccessibleContext() {
        return this._dbConns.getAccessibleContext();
    }

    public Connection getCurrentConnection() {
        Connection connection = null;
        try {
            String string = this.getCurrentConnectionName();
            if (string != null) {
                connection = this._conns.getConnection(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return connection;
    }

    public Database getCurrentDatabase() throws DBException {
        Database database = null;
        String string = this.getCurrentConnectionName();
        if (string != null) {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            database = this._conns.getDatabase(string);
            ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        }
        return database;
    }

    public String getCurrentConnectionName() {
        String string = null;
        try {
            string = this._dbConns.getItemCount() > 0 && this._dbConns.getSelectedItem() != null ? (String)this._dbConns.getSelectedItem() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void resize() {
        this._dbConns.setSize(this._dbConns.getPreferredSize());
        this._dbConns.setMaximumSize(this._dbConns.getPreferredSize());
    }

    private void populate() {
        Object var2_1 = null;
        String[] stringArray = this._conns.getConnNames();
        Arrays.sort(stringArray, Collator.getInstance());
        for (int i = 0; var2_1 == null && i < stringArray.length; ++i) {
            this.addConnection(stringArray[i]);
        }
    }

    public Connection getConnection(String string) throws DBException {
        ConnectionSelectorUI.SELECTOR_ACTIVE = true;
        Connection connection = this._conns.getConnection(string);
        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
        return connection;
    }

    public String[] getConnNames() {
        return this._conns.getConnNames();
    }

    public void addConnection(String string) {
        if (Connections.isUnsharedWorksheetConnection(string)) {
            return;
        }
        String string2 = this.getCurrentConnectionName();
        boolean bl = false;
        for (int i = 0; i < this._dbConns.getItemCount(); ++i) {
            if (!this._dbConns.getItemAt(i).equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            if (this._dbConns.getItemCount() == 0) {
                this._dbConns.insertItemAt(string, 0);
            } else {
                this._dbConns.addItem(string);
            }
            this.resize();
        }
        if (string2 == null) {
            this._model.setSelectedItem((Object)"");
        }
    }

    public void makeNewConnection() {
        String string = null;
        string = ConnectionSelectorUI.getConnection(ConnectionArb.getString(32), ConnectionArb.getString(31), string, true);
        this.setCurrentConnection(string);
    }

    public void removeConnection(String string) {
        this._model.removeElement((Object)string);
        this.resize();
    }

    private class ConnListener
    implements ConnectionListener {
        private String _lastName;

        private ConnListener() {
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
        }

        public void connectionModified(ConnectionEvent connectionEvent) {
            String string;
            String string2 = connectionEvent.getOldName();
            if (ModelUtil.areDifferent((Object)string2, (Object)(string = connectionEvent.getConnectionName()))) {
                this.processConnectionRename(string2, string);
            }
        }

        public void connectionOpened(ConnectionEvent connectionEvent) {
        }

        public void connectionRenamed(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getOldName();
            String string2 = connectionEvent.getConnectionName();
            this.processConnectionRename(string, string2);
        }

        private void processConnectionRename(String string, String string2) {
            String string3 = DBConnectionComboBox.this.getCurrentConnectionName();
            DBConnectionComboBox.this.removeConnection(string);
            DBConnectionComboBox.this.addConnection(string2);
            if (ModelUtil.areEqual((Object)string, (Object)string3)) {
                DBConnectionComboBox.this.setCurrentConnection(string2);
            }
        }

        public void connectionAdded(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DBConnectionComboBox.this.addConnection(string);
        }

        public void connectionRemoved(ConnectionEvent connectionEvent) {
            String string = connectionEvent.getConnectionName();
            DBConnectionComboBox.this.removeConnection(string);
        }
    }
}

