/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.editor.EditorManager;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ora.OracleDatabase;

public class DBObjectSelector
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DBConnectionComboBox _dbComboBox;
    private JMutableTreeNode _myObjects;
    private JMutableTreeNode _otherUsers;
    private OracleDatabase _db;
    private CustomJTree _tree;
    private DefaultTreeModel _model;
    private DefaultMutableTreeNode _root;
    private JScrollPane _sp;

    public DBObjectSelector() {
        this.setLayout(new SpringLayout());
        String string = null;
        if (EditorManager.getEditorManager().getCurrentEditor() instanceof IDBEditor) {
            string = Connections.getInstance().getConnectionName(((IDBEditor)EditorManager.getEditorManager().getCurrentEditor()).getDatabase());
        }
        this.add(new JLabel(Translate.translate((String)"Connection:")));
        this._dbComboBox = new DBConnectionComboBox();
        this.add(this._dbComboBox.getJComboBox());
        this.add(new JLabel(Translate.translate((String)"Objects:")));
        this._sp = new JScrollPane();
        this._sp.setMinimumSize(new Dimension(200, 200));
        this.add(this._sp);
        this._dbComboBox.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    try {
                        DBObjectSelector.this._db = (OracleDatabase)DBObjectSelector.this._dbComboBox.getCurrentDatabase();
                        DBObjectSelector.this.initTree();
                    }
                    catch (DBException dBException) {
                        DBException dBException2 = dBException.getCause() instanceof Exception ? (Exception)dBException.getCause() : dBException;
                        ExceptionHandler.handleException((Exception)((Object)dBException2));
                    }
                }
            }
        });
        if (string != null) {
            this._dbComboBox.setCurrentConnection(string);
        } else {
            this._dbComboBox.getJComboBox().setSelectedIndex(-1);
        }
        SpringUtilities.makeCompactGrid(this, 4, 1, 0, 0, 0, 2);
    }

    public CustomJTree getTree() {
        return this._tree;
    }

    public OracleDatabase getDatabase() {
        return this._db;
    }

    private void initTree() {
        if (this._root == null) {
            this._root = this.createCheck("All", "SCHEMA_EXPORT", false, false);
        } else {
            this._root.removeAllChildren();
        }
        this._myObjects = this.createCheck("All My Objects", "MY", false, false);
        this._myObjects.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
        this._otherUsers = this.createCheck("Other Users", "OTHERS", false, false);
        this._root.add((MutableTreeNode)this._myObjects);
        this._root.add((MutableTreeNode)this._otherUsers);
        this._otherUsers.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
        this._model = new DefaultTreeModel(this._root);
        this._tree = new CustomJTree((TreeModel)this._model);
        this._tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                try {
                    DBObjectSelector.this.populateChildren((JMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent(), treeExpansionEvent.getSource());
                    ((JMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).sortChildren();
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
        this._sp.setViewportView((Component)this._tree);
    }

    private JMutableTreeNode createCheck(String string, String string2, boolean bl, boolean bl2) {
        JTreeCellData jTreeCellData = new JTreeCellData(string);
        jTreeCellData.setCheckBoxEnabled(bl);
        jTreeCellData.setTextEnabled(true);
        jTreeCellData.setHasCheckBox(bl);
        jTreeCellData.setUserObject((Object)string2);
        jTreeCellData.setCheckBoxState(bl2);
        return new JMutableTreeNode(jTreeCellData);
    }

    private JMutableTreeNode createCheck(String string, String string2, boolean bl) {
        return this.createCheck(string, string2, true, bl);
    }

    private void addTypes(JMutableTreeNode jMutableTreeNode) {
        JMutableTreeNode jMutableTreeNode2 = null;
        if (this._db != null) {
            for (String string : this._db.listObjectTypes()) {
                if (string.equals("RECYCLEBIN") || string.equals("DIRECTORY")) continue;
                jMutableTreeNode2 = this.createCheck(string, "OBJECT_TYPE", false);
                jMutableTreeNode2.add((MutableTreeNode)new JMutableTreeNode("Loading...."));
                ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode2, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
            }
        }
    }

    public Schema getSchema(JMutableTreeNode jMutableTreeNode) throws DBException {
        Schema schema = null;
        for (TreeNode treeNode : jMutableTreeNode.getPath()) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)treeNode;
            if (((JTreeCellData)jMutableTreeNode2.getUserObject()).getUserObject() == null) continue;
            String string = (String)((JTreeCellData)jMutableTreeNode2.getUserObject()).getUserObject();
            if (string.equals("MY")) {
                schema = this._db.getDefaultSchema();
                continue;
            }
            if (!string.equals("SCHEMA")) continue;
            schema = this._db.getSchema(((JTreeCellData)jMutableTreeNode2.getUserObject()).getText());
        }
        return schema;
    }

    public String getType(JMutableTreeNode jMutableTreeNode) throws DBException {
        String string = null;
        for (int i = jMutableTreeNode.getPath().length - 1; string == null && i > -1; --i) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)jMutableTreeNode.getPath()[i];
            if (((JTreeCellData)jMutableTreeNode2.getUserObject()).getUserObject() == null) continue;
            String string2 = (String)((JTreeCellData)jMutableTreeNode2.getUserObject()).getUserObject();
            if (string2.equals("OBJECT_TYPE")) {
                string = ((JTreeCellData)jMutableTreeNode2.getUserObject()).getText();
                continue;
            }
            if (!string2.equals("SCHEMA") && !string2.equals("MY")) continue;
            string = "SCHEMA";
        }
        return string;
    }

    protected void populateChildren(JMutableTreeNode jMutableTreeNode, Object object) throws Exception {
        JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)((DefaultTreeModel)this._tree.getModel()).getChild(jMutableTreeNode, 0);
        boolean bl = ((JTreeCellData)((JMutableTreeNode)jMutableTreeNode2.getParent()).getUserObject()).getCheckBoxState() == TriStateBoolean.TRUE;
        String string = ((JTreeCellData)jMutableTreeNode2.getUserObject()).getText();
        if (string != null && string.equals("Loading....")) {
            ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent((MutableTreeNode)jMutableTreeNode2);
            String string2 = (String)((JTreeCellData)jMutableTreeNode.getUserObject()).getUserObject();
            Schema schema = this.getSchema(jMutableTreeNode);
            if (this._db == null) {
                this._db = (OracleDatabase)this._dbComboBox.getCurrentDatabase();
            }
            if (string2.equals("MY")) {
                this.addTypes(jMutableTreeNode);
            } else if (string2.equals("OTHERS")) {
                for (Schema schema2 : this._db.listSchemas()) {
                    if (this._db.getDefaultSchema().equals((Object)schema2)) continue;
                    JMutableTreeNode jMutableTreeNode3 = this.createCheck(schema2.toString(), "SCHEMA", bl);
                    ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode3, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
                    this.addTypes(jMutableTreeNode3);
                }
            } else {
                string2 = this.getType(jMutableTreeNode);
                String[] stringArray = this._db.listObjects(string2, schema);
                if (stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        JMutableTreeNode jMutableTreeNode4 = this.createCheck(stringArray[i], string2, bl);
                        ((DefaultTreeModel)this._tree.getModel()).insertNodeInto((MutableTreeNode)jMutableTreeNode4, (MutableTreeNode)jMutableTreeNode, jMutableTreeNode.getChildCount());
                    }
                }
            }
            this._tree.expandPath(this._tree.getSelectionPath());
        }
    }

    public void reset() {
        this.initTree();
    }
}

