/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.DBObjectSelector;
import oracle.dbtools.raptor.metadata.MetaData;
import oracle.dbtools.raptor.metadata.MetaDataOptionsPanel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.db.DBIcons;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public class ExportPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String EXPORT_NAME = "raptor.export";
    public static final int EXPORT_ACTION = Ide.findOrCreateCmdID((String)"raptor.export");
    private DBObjectSelector _objectSelector;
    private MetaData _meta = new MetaData();
    private MetaDataOptionsPanel _options;
    private static ExportPanel INSTANCE;

    private ExportPanel() {
        super(new BorderLayout());
        this._objectSelector = new DBObjectSelector();
        this.add((Component)this._objectSelector, "Center");
    }

    public void launch() {
        this._objectSelector = new DBObjectSelector();
        this._objectSelector.setMinimumSize(new Dimension(200, 400));
        this._objectSelector.setPreferredSize(new Dimension(200, 400));
        this._options = new MetaDataOptionsPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._options, "f1_idedexportobjects_html");
        HelpSystem.getHelpSystem().registerTopic((JComponent)this._objectSelector, "f1_idedexportobjects_html");
        JPanel[] jPanelArray = new JPanel[]{this._options, this._objectSelector};
        String[] stringArray = new String[]{"Options", "Objects"};
        UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, "Export", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("apply")) {
            class ExportRun
            extends ProgressRunnable {
                private ActionEvent _e;
                private boolean _cancel = false;

                ExportRun() {
                }

                public void set_e(ActionEvent actionEvent) {
                    this._e = actionEvent;
                }

                protected Object doWork() throws Exception {
                    this._cancel = false;
                    ExportPanel.this._meta.setCancel(false);
                    ExportPanel.this.export();
                    if (this._e.getSource() instanceof JEWTDialog && !this._cancel) {
                        JEWTDialog jEWTDialog = (JEWTDialog)this._e.getSource();
                        jEWTDialog.closeDialog(true);
                    }
                    return true;
                }

                protected void doCancel() {
                    super.doCancel();
                    this._cancel = true;
                    ExportPanel.this._meta.setCancel(true);
                }
            }
            ExportRun exportRun = new ExportRun();
            exportRun.set_e(actionEvent);
            exportRun.setTitle(Translate.translate((String)"Performing Export"));
            exportRun.setMessage(Translate.translate((String)"Performing Export operations please be patient."));
            try {
                exportRun.start(true);
            }
            catch (ProgressException progressException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
            }
        }
    }

    private void export() throws DBException {
        if (this._objectSelector.getTree() == null || this._objectSelector.getTree().getSelectionModel().getSelectionCount() == 0) {
            MessageDialog.error((Component)this, (Object)"Nothing Selected to Export", (String)"Export", (String)"f1_exportddl_html");
            return;
        }
        if (this._objectSelector.getTree().getSelectionModel().getSelectionCount() == 1 && ((JTreeCellData)((JMutableTreeNode)this._objectSelector.getTree().getSelectionModel().getSelectionPath().getLastPathComponent()).getUserObject()).getText().equals("All My Objects")) {
            MessageDialog.error((Component)this, (Object)"Nothing Selected to Export Expand Tree and Select Export Options", (String)"Export", (String)"f1_exportddl_html");
            return;
        }
        if (this._options.getFileName() == null) {
            MessageDialog.error((Component)this, (Object)"No File Specified", (String)"Export", (String)"f1_exportddl_html");
            return;
        }
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._objectSelector.getTree().getModel().getRoot();
        Enumeration enumeration = jMutableTreeNode.breadthFirstEnumeration();
        this._meta.reset();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (enumeration.hasMoreElements()) {
            String string;
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)enumeration.nextElement();
            JTreeCellData jTreeCellData = (JTreeCellData)jMutableTreeNode2.getUserObject();
            boolean bl = jTreeCellData.getCheckBoxState() == TriStateBoolean.TRUE;
            if (!bl || (string = jTreeCellData.getText()).equals("Loading....") || this._objectSelector.getSchema(jMutableTreeNode2) == null) continue;
            String string2 = this._objectSelector.getSchema(jMutableTreeNode2).getName();
            String string3 = this._objectSelector.getType(jMutableTreeNode2);
            String string4 = (String)jTreeCellData.getUserObject();
            if (string4 != null && string4.equals("OBJECT_TYPE")) {
                this._meta.addObject(string2, string3);
                arrayList.add(string3);
                continue;
            }
            if (arrayList.contains(string3)) continue;
            this._meta.addObject(string2, string3, string);
        }
        try {
            if (this._meta.getQueuedCount() > 0) {
                String string = this._options.getFileName();
                this._meta.setOutputStream(new FileOutputStream(this._options.getFileName()));
                this._meta.setConnection(this._objectSelector.getDatabase().getConnection());
                this._meta.setAlter(this._options.getAlter());
                this._meta.setByte(this._options.getByte());
                this._meta.setPretty(this._options.getPretty());
                this._meta.setSegments(this._options.getSegments());
                this._meta.setTerminator(this._options.getTerminator());
                this._meta.setData(this._options.getData());
                this._meta.setDrop(this._options.getDrop());
                this._meta.setforce(this._options.getForce());
                this._meta.setShowSchema(this._options.getSchema());
                this._meta.printDDL();
                this._meta.closeOutputStream();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)EXPORT_ACTION, null, (String)Translate.translate((String)"Export DDL (and Data)"), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(69), (ArrayResourceBundle)DBIcons.getInstance(), (int)5, null, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController(ExportController.INSTANCE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    private static ExportPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportPanel();
        }
        return INSTANCE;
    }

    private static class ExportController
    implements Controller {
        private static Controller INSTANCE = new ExportController();

        private ExportController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == EXPORT_ACTION) {
                ExportPanel.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == EXPORT_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

