/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.DnDDropGenerator;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ide.util.dnd.TransferablesList;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Function;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Procedure;

public class RaptorDnD
extends DropTargetAdapter {
    private JTextComponent _target;

    public RaptorDnD() {
        this(null);
        Logger.getLogger(RaptorDnD.class.getName());
    }

    public RaptorDnD(JTextComponent jTextComponent) {
        Logger.getLogger(RaptorDnD.class.getName());
        this._target = jTextComponent;
        this.init();
    }

    private void init() {
        DropTarget dropTarget = new DropTarget(this._target, 1, this, true, null);
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n = this._target.viewToModel(dropTargetDragEvent.getLocation());
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        this._target.setCaretPosition(n);
        try {
            Transferable transferable = dropTargetDragEvent.getTransferable();
            Object var5_7 = null;
            if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
                arrayList.addAll((Collection<DefaultMutableTreeNode>)((TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
            } else if (transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                arrayList.add((DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                ObjectNode objectNode;
                DBObject dBObject;
                Object object = null;
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                defaultMutableTreeNode = arrayList.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)arrayList.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)arrayList.get(i);
                object = defaultMutableTreeNode.getUserObject();
                String string = null;
                if (object instanceof ObjectNode && (dBObject = (objectNode = (ObjectNode)object).getDBObject()) != null) {
                    string = dBObject.getType();
                }
                if (string != null && (string.equals("TABLE") || string.equals("VIEW"))) continue;
                dropTargetDragEvent.rejectDrag();
                break;
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
        }
        catch (IOException iOException) {
            dropTargetDragEvent.rejectDrag();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.drop(dropTargetDropEvent, this._target);
    }

    public boolean drop(DropTargetDropEvent dropTargetDropEvent, JTextComponent jTextComponent) {
        Document document = jTextComponent.getDocument();
        this._target = jTextComponent;
        int n = jTextComponent.viewToModel(dropTargetDropEvent.getLocation());
        Transferable transferable = dropTargetDropEvent.getTransferable();
        jTextComponent.setAutoscrolls(true);
        boolean bl = false;
        try {
            if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR) || transferable.isDataFlavorSupported(TransferableTreeNode.TREE_NODE_FLAVOR)) {
                document.insertString(n, this.nodeDrop(transferable, n), null);
                bl = true;
            } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                document.insertString(n, string, null);
                bl = true;
            }
            jTextComponent.setCaretPosition(n);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
        }
        return bl;
    }

    private String nodeDrop(Transferable transferable, int n) throws UnsupportedFlavorException, IOException {
        ArrayList<DefaultMutableTreeNode> arrayList = new ArrayList<DefaultMutableTreeNode>();
        String string = null;
        if (transferable.isDataFlavorSupported(TransferablesList.TRANSFERABLE_LIST_FLAVOR)) {
            arrayList.addAll((Collection<DefaultMutableTreeNode>)((TransferablesList)transferable.getTransferData(TransferablesList.TRANSFERABLE_LIST_FLAVOR)));
        } else {
            arrayList.add((DefaultMutableTreeNode)transferable.getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR));
        }
        DnDDropGenerator dnDDropGenerator = new DnDDropGenerator();
        StringBuilder stringBuilder = new StringBuilder("");
        try {
            stringBuilder = dnDDropGenerator.generate(arrayList);
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        catch (AbortException abortException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, abortException.getStackTrace()[0].toString(), abortException);
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (stringBuilder.length() > 1) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private String getFunctionDrop(Function function) {
        StringBuilder stringBuilder = new StringBuilder("ret/*" + function.getReturnType() + "*/ := " + DBUtil.enquote((String)function.getSchema().getName()) + "." + DBUtil.enquote((String)function.getName()));
        PlSqlParameter[] plSqlParameterArray = function.getParameters();
        for (int i = 0; i < plSqlParameterArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(DBUtil.enquote((String)plSqlParameterArray[i].getName()) + "/*" + plSqlParameterArray[i].getDataType().getName() + "*/");
            if (i != plSqlParameterArray.length - 1) {
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }

    public String getProcedureDrop(Procedure procedure) {
        StringBuilder stringBuilder = new StringBuilder(DBUtil.enquote((String)procedure.getSchema().getName()) + "." + DBUtil.enquote((String)procedure.getName()));
        PlSqlParameter[] plSqlParameterArray = procedure.getParameters();
        for (int i = 0; i < plSqlParameterArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append("(");
            }
            stringBuilder.append(DBUtil.enquote((String)plSqlParameterArray[i].getName()) + "/*" + plSqlParameterArray[i].getDataType().getName() + "*/");
            if (i != plSqlParameterArray.length - 1) {
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(";\n");
        return stringBuilder.toString();
    }
}

