/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.JTableHeader;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.net.URLChooser;
import oracle.ide.util.ResourceUtils;

public abstract class ExtendedTypeEditPanel
extends JPanel {
    protected ExtendedType extendedType;
    protected URL saveToURL = null;
    protected static URL _lastSaveUrl;
    protected JButton loadButton = new JButton();
    protected JButton saveButton = new JButton();
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JLabel imageLabel = new JLabel();
    protected JTextArea textArea = new JTextArea();
    protected JCheckBox viewAsImageBtn;
    protected JCheckBox viewAsTextBtn;
    protected JTabbedPane tabbedPane;
    private JTable _table;
    protected static boolean showImage;
    protected static boolean showText;

    public ExtendedTypeEditPanel(ExtendedType extendedType) {
        this.extendedType = extendedType;
        this.createGUI();
    }

    protected abstract void createGUI();

    protected void createDefaultGUI() {
        showImage = false;
        showText = false;
        this.setLayout(new GridBagLayout());
        this.viewAsImageBtn = new JCheckBox();
        this.viewAsTextBtn = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.viewAsImageBtn, (String)Translate.translate((String)"&Image"));
        ResourceUtils.resButton((AbstractButton)this.viewAsTextBtn, (String)Translate.translate((String)"&Text"));
        this.viewAsImageBtn.setSelected(showImage);
        this.viewAsTextBtn.setSelected(showText);
        this.tabbedPane = new JTabbedPane(3);
        JScrollPane jScrollPane = new JScrollPane(this.createTable());
        jScrollPane.setPreferredSize(new Dimension(400, 300));
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportBorder(null);
        jScrollPane.getViewport().setBackground(Color.white);
        this.tabbedPane.addTab(Translate.translate((String)"Information"), jScrollPane);
        this.imageLabel.setVerticalAlignment(1);
        final JScrollPane jScrollPane2 = new JScrollPane(this.imageLabel);
        jScrollPane2.setPreferredSize(new Dimension(400, 300));
        jScrollPane2.setHorizontalScrollBarPolicy(30);
        jScrollPane2.setVerticalScrollBarPolicy(20);
        jScrollPane2.setViewportBorder(null);
        jScrollPane2.getViewport().setBackground(Color.white);
        try {
            if (showImage) {
                this.tabbedPane.addTab(Translate.translate((String)"Image"), jScrollPane2);
                this.showAsImage(this.extendedType);
            }
        }
        catch (Exception exception) {
            this.showAsImage(null);
        }
        this.textArea.setEditable(false);
        final JScrollPane jScrollPane3 = new JScrollPane(this.textArea);
        jScrollPane3.setPreferredSize(new Dimension(400, 300));
        jScrollPane3.setHorizontalScrollBarPolicy(32);
        jScrollPane3.setVerticalScrollBarPolicy(22);
        jScrollPane3.setViewportBorder(null);
        jScrollPane3.getViewport().setBackground(Color.white);
        try {
            if (showText) {
                this.tabbedPane.addTab(Translate.translate((String)"Text"), jScrollPane3);
                this.showAsText(this.extendedType);
            }
        }
        catch (Exception exception) {
            this.showAsText(null);
        }
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.viewAsImageBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.viewAsImageBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Translate.translate((String)"Image"), jScrollPane2);
                        ExtendedTypeEditPanel.this.showAsImage(ExtendedTypeEditPanel.this.extendedType);
                        showImage = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(jScrollPane2);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(jScrollPane2);
                        ExtendedTypeEditPanel.this.showAsImage(null);
                        showImage = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsImage(null);
                }
            }
        });
        this.buttonPanel.add((Component)new JLabel(Translate.translate((String)"View As:")), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.viewAsImageBtn, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.viewAsTextBtn.setSelected(showText);
        this.viewAsTextBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (ExtendedTypeEditPanel.this.viewAsTextBtn.isSelected()) {
                        ExtendedTypeEditPanel.this.tabbedPane.addTab(Translate.translate((String)"Text"), jScrollPane3);
                        ExtendedTypeEditPanel.this.showAsText(ExtendedTypeEditPanel.this.extendedType);
                        showText = true;
                        ExtendedTypeEditPanel.this.tabbedPane.setSelectedComponent(jScrollPane3);
                    } else {
                        ExtendedTypeEditPanel.this.tabbedPane.remove(jScrollPane3);
                        ExtendedTypeEditPanel.this.showAsText(null);
                        showText = false;
                    }
                }
                catch (Exception exception) {
                    ExtendedTypeEditPanel.this.showAsText(null);
                }
            }
        });
        this.buttonPanel.add((Component)this.viewAsTextBtn, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.buttonPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
    }

    protected JTable createTable() {
        Object[] objectArray = new String[]{Translate.translate((String)"Property"), Translate.translate((String)"Value")};
        Object[][] objectArray2 = this.getTableData();
        JTable jTable = new JTable(objectArray2, objectArray){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        jTable.setBackground(this.getBackground());
        jTable.setRowHeight(20);
        jTable.setCellSelectionEnabled(true);
        jTable.setPreferredSize(new Dimension(350, 200));
        jTable.setTableHeader(new JTableHeader());
        return jTable;
    }

    public void setJTable(JTable jTable) {
        this._table = jTable;
    }

    public JTable getJTable() {
        return this._table;
    }

    protected abstract String[][] getTableData();

    protected abstract boolean processExtendedType();

    protected abstract Component getDefaultComponent();

    protected abstract void load();

    protected JButton getLoadButton() {
        ResourceUtils.resButton((AbstractButton)this.loadButton, (String)Translate.translate((String)"&Load"));
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.load();
            }
        });
        return this.loadButton;
    }

    protected JButton getSaveButton() {
        ResourceUtils.resButton((AbstractButton)this.saveButton, (String)Translate.translate((String)"&Save"));
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedTypeEditPanel.this.save();
            }
        });
        return this.saveButton;
    }

    protected JPanel getButtonPanel() {
        this.buttonPanel.add((Component)this.getLoadButton(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.buttonPanel.add((Component)this.getSaveButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
        return this.buttonPanel;
    }

    protected void save() {
        Object object;
        URLChooser uRLChooser = new URLChooser();
        uRLChooser.setDefaultTitle(Translate.translate((String)"Choose File"));
        uRLChooser.setSelectionMode(0);
        uRLChooser.setSelectionScope(0);
        uRLChooser.clearChooseableURLFilters();
        if (_lastSaveUrl == null) {
            try {
                object = System.getProperty("user.home");
                File file = new File((String)object);
                uRLChooser.setSelectedURL(file.toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        } else {
            uRLChooser.setSelectedURL(_lastSaveUrl);
        }
        object = new File(uRLChooser.getSelectedURL().getFile());
        if (((File)object).isDirectory()) {
            try {
                uRLChooser.setSelectedURL(new URL(uRLChooser.getSelectedURL() + File.separator + this.getFileName()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRLChooser.showSaveDialog((Component)this) == 0) {
            this.saveToURL = uRLChooser.getSelectedURL();
            _lastSaveUrl = uRLChooser.getSelectedURL();
        }
    }

    public String getFileName() {
        String string = "";
        for (int i = 0; i < this.getJTable().getColumnCount(); ++i) {
            String string2 = this.getJTable().getColumnName(i);
            if (!string2.equalsIgnoreCase("file_name") && !string2.equalsIgnoreCase("file name")) continue;
            string = this.getJTable().getValueAt(this.getJTable().getSelectedRow(), i).toString();
        }
        return string;
    }

    public URL getSaveToURL() {
        return this.saveToURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showAsImage(ExtendedType extendedType) {
        if (extendedType == null) {
            this.imageLabel.setIcon(null);
            this.imageLabel.setText(null);
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = extendedType.getBinaryStream();
            if (inputStream == null) {
                this.imageLabel.setIcon(null);
                this.imageLabel.setText(null);
                return;
            }
            inputStream.mark(Integer.MAX_VALUE);
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            if (bufferedImage != null) {
                this.imageLabel.setIcon(new ImageIcon(bufferedImage));
            } else {
                inputStream.reset();
                if (this.skipOLEHeader(inputStream)) {
                    bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage != null) {
                        this.imageLabel.setIcon(new ImageIcon(bufferedImage));
                    } else {
                        this.imageLabel.setText(Translate.translate((String)"Image could not be decoded from the binary stream."));
                    }
                } else {
                    this.imageLabel.setText(Translate.translate((String)"Image could not be decoded from the binary stream."));
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private boolean skipOLEHeader(InputStream inputStream) {
        String string = "Bitmap Image";
        String string2 = "Paint.Picture";
        byte[] byArray = new byte[512];
        try {
            int n;
            int n2 = inputStream.read(byArray);
            if (n2 == -1 || n2 < 46) {
                return false;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 20; n < 20 + string.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string)) {
                return false;
            }
            stringBuffer = new StringBuffer();
            for (n = 33; n < 33 + string2.length(); ++n) {
                stringBuffer.append((char)byArray[n]);
            }
            if (!stringBuffer.toString().equals(string2)) {
                return false;
            }
            boolean bl = false;
            for (n = 33 + string2.length(); n < n2; ++n) {
                if (byArray[n] != 66 || byArray[n + 1] != 77) continue;
                bl = true;
                break;
            }
            if (bl) {
                inputStream.reset();
                inputStream.skip(n);
                return true;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showAsText(ExtendedType extendedType) {
        if (extendedType != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(extendedType.getBinaryStream()));
                if (bufferedReader != null) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        this.textArea.append(string + "\n");
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected boolean saveToDisk() {
        FileOutputStream fileOutputStream = null;
        URL uRL = this.getSaveToURL();
        if (uRL != null) {
            try {
                fileOutputStream = new FileOutputStream(uRL.getFile());
                this.extendedType.setToDiskStream((OutputStream)fileOutputStream);
                this.extendedType.saveToDisk(null, null, null, null, false);
                return true;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Exception)exception);
            }
        }
        return false;
    }

    public void setEditable(boolean bl) {
        this.loadButton.setEnabled(bl);
    }

    static {
        showImage = false;
        showText = false;
    }
}

