/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.celleditor;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Scanner;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.raptor.controls.ControlsArb;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.ExtensionBundle;
import oracle.ide.util.ResourceUtils;

public class LongCharEditPanel
extends JPanel
implements ChangeListener {
    IdeSettings settings = Ide.getSettings();
    String _EOLChars = null;
    String eolLabel = null;
    EnvironOptions envopts;
    protected Object value = null;
    protected boolean canChange = true;
    final JTextField _jtfLineTerminator = new JTextField();
    protected JTextArea jtaEditValue = new JTextArea();

    public LongCharEditPanel(Object object, boolean bl) {
        this.value = object;
        this.canChange = bl;
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        this.envopts.addChangeListener((ChangeListener)this);
        this.getEOLSettings();
        this.getLongCharEditPanel();
    }

    protected void getLongCharEditPanel() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        String string = EnvironOptionsArb.getString((int)34);
        this._jtfLineTerminator.setText(this.eolLabel);
        this._jtfLineTerminator.setEditable(false);
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._jtfLineTerminator, (String)string);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LongCharEditPanel.this.settings.showDialog((Frame)Ide.getMainWindow(), new String[]{ExtensionBundle.get((String)"ENVIRONMENT_SETTINGS")});
            }
        });
        ResourceUtils.resButton((AbstractButton)jButton, (String)Translate.translate((String)"&Change.."));
        JLabel jLabel2 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this.jtaEditValue, (String)ControlsArb.getString(1));
        JScrollPane jScrollPane = new JScrollPane(this.jtaEditValue);
        jScrollPane.setHorizontalScrollBarPolicy(32);
        jScrollPane.setVerticalScrollBarPolicy(22);
        this.jtaEditValue.setRows(10);
        this.jtaEditValue.setEditable(this.canChange);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this._jtfLineTerminator, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
    }

    protected void getEOLSettings() {
        this.settings = Ide.getSettings();
        this.envopts = (EnvironOptions)this.settings.getData("environment-options");
        int n = this.envopts.getLineTerminator();
        if (n == 1) {
            this._EOLChars = "\r\n";
            this.eolLabel = EnvironOptionsArb.getString((int)13);
        } else if (n == 3) {
            this._EOLChars = "\r";
            this.eolLabel = EnvironOptionsArb.getString((int)14);
        } else if (n == 2) {
            this._EOLChars = "\n";
            this.eolLabel = EnvironOptionsArb.getString((int)33);
        } else {
            this._EOLChars = System.getProperty("line.separator");
            this.eolLabel = EnvironOptionsArb.getString((int)6);
        }
    }

    public String getEOLChars() {
        return this._EOLChars;
    }

    public EnvironOptions getEnvopts() {
        return this.envopts;
    }

    public String getEolLabel() {
        return this.eolLabel;
    }

    public void setText(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(string);
        boolean bl = true;
        while (scanner.hasNextLine()) {
            if (bl) {
                bl = false;
                stringBuilder.append(scanner.nextLine());
                continue;
            }
            stringBuilder.append(System.getProperty("line.separator") + scanner.nextLine());
        }
        this.jtaEditValue.setText(stringBuilder.toString());
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        Scanner scanner = new Scanner(this.jtaEditValue.getText());
        boolean bl = true;
        while (scanner.hasNextLine()) {
            if (bl) {
                bl = false;
                stringBuilder.append(scanner.nextLine());
                continue;
            }
            stringBuilder.append(this._EOLChars + scanner.nextLine());
        }
        return stringBuilder.toString();
    }

    public Component getDefaultComponent() {
        return this.jtaEditValue;
    }

    public void setCanChange(boolean bl) {
        this.canChange = bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LongCharEditPanel.this.getEOLSettings();
                LongCharEditPanel.this._jtfLineTerminator.setText(LongCharEditPanel.this.eolLabel);
            }
        });
    }

    public void close() {
        this.envopts.removeChangeListener((ChangeListener)this);
    }
}

