/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.diff.DestinationSelector;
import oracle.dbtools.raptor.controls.diff.DiffArb;
import oracle.dbtools.raptor.controls.diff.ResultPanel;
import oracle.dbtools.raptor.controls.diff.SourceSelector;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.db.transfer.TransferHelper;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

public class DiffPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String DIFF_NAME = "raptor.diff";
    public static final int DIFF_ACTION = Ide.findOrCreateCmdID((String)"raptor.diff");
    private SourceSelector _source = new SourceSelector();
    private ResultPanel _result;
    private DestinationSelector _dest = new DestinationSelector();
    private ArrayList<SchemaObject> _sourceO;
    private SchemaObject[] _sourceObjects;
    private String _script;
    private static DiffPanel INSTANCE;

    private DiffPanel() {
        super(new BorderLayout());
        this._result = new ResultPanel(this._dest);
        this.add((Component)this._source, "Center");
    }

    public void launch() {
        this._result = null;
        this._source = null;
        this._dest = null;
        this._script = null;
        this._source = new SourceSelector();
        this._source.setMinimumSize(new Dimension(200, 400));
        this._source.setPreferredSize(new Dimension(200, 400));
        this._dest = new DestinationSelector();
        this._dest.setMinimumSize(new Dimension(200, 400));
        this._dest.setPreferredSize(new Dimension(200, 400));
        this._result = new ResultPanel(this._dest);
        this._result.setMinimumSize(new Dimension(200, 400));
        this._result.setPreferredSize(new Dimension(200, 400));
        JPanel[] jPanelArray = new JPanel[]{this._source, this._dest, this._result};
        String[] stringArray = new String[]{"Source", "Destination", "Results"};
        UIUtils.showPanelAsTabbedDialog2(jPanelArray, stringArray, "Schema Diff", this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("apply")) {
            class DiffRun
            extends ProgressRunnable {
                private boolean _canceled = false;

                DiffRun() {
                }

                protected Object doWork() throws Exception {
                    boolean bl = DiffPanel.this.diff();
                    if (!bl) {
                        DiffPanel.this._result.getSqlPane().setEditable(true);
                        DiffPanel.this._result.getSqlPane().setText("");
                        DiffPanel.this._result.getSqlPane().setEditable(false);
                    } else if (!this._canceled) {
                        DiffPanel.this._result.getSqlPane().setEditable(true);
                        DiffPanel.this._result.getSqlPane().setText(DiffPanel.this._script);
                        DiffPanel.this._result.getSqlPane().setEditable(false);
                    } else {
                        DiffPanel.this._result.getSqlPane().setEditable(true);
                        DiffPanel.this._result.getSqlPane().setText(DiffArb.getString(0));
                        DiffPanel.this._result.getSqlPane().setEditable(false);
                    }
                    return true;
                }

                protected void doCancel() {
                    super.doCancel();
                    this._canceled = true;
                }
            }
            DiffRun diffRun = new DiffRun();
            diffRun.setTitle(DiffArb.getString(1));
            diffRun.setMessage(DiffArb.getString(2));
            try {
                diffRun.start(true);
            }
            catch (ProgressException progressException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
            }
        }
    }

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)DIFF_ACTION);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    private boolean diff() throws DBException, ConnectionException {
        Schema schema;
        OracleDatabase oracleDatabase;
        int n;
        ((CustomTabbedPane)this._result.getParent().getParent()).setSelectedIndex(2);
        if (this._source.getTree() == null || this._source.getTree().getSelectionModel().getSelectionCount() == 0) {
            MessageDialog.error((Component)this, (Object)"No Source Objects Selected", (String)"Source", (String)"f1_diffsrcerror_html");
            return false;
        }
        if (this._dest.getSchema() == null) {
            MessageDialog.error((Component)this, (Object)"No Destination Schema Selected", (String)"Destination", (String)"f1_diffdesterror_html");
            return false;
        }
        this._sourceO = new ArrayList();
        JMutableTreeNode jMutableTreeNode = (JMutableTreeNode)this._source.getTree().getModel().getRoot();
        Enumeration enumeration = jMutableTreeNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            JMutableTreeNode jMutableTreeNode2 = (JMutableTreeNode)enumeration.nextElement();
            JTreeCellData jTreeCellData = (JTreeCellData)jMutableTreeNode2.getUserObject();
            n = jTreeCellData.getCheckBoxState() == TriStateBoolean.TRUE ? 1 : 0;
            if (n == 0) continue;
            String string = jTreeCellData.getText();
            Schema schema2 = this._source.getSchema(jMutableTreeNode2);
            String string2 = this._source.getType(jMutableTreeNode2);
            if (!string.equalsIgnoreCase(string2)) {
                oracleDatabase = this._source.getDatabase().getObject(string2, schema2, string);
                this._sourceO.add((SchemaObject)oracleDatabase);
                continue;
            }
            oracleDatabase = (JMutableTreeNode)jMutableTreeNode2.getFirstChild();
            schema = (JTreeCellData)oracleDatabase.getUserObject();
            String string3 = schema.getText();
            if (!string3.equals("Loading....")) continue;
            try {
                this._source.populateChildren(jMutableTreeNode2, null);
            }
            catch (Exception exception) {}
        }
        this._sourceObjects = new SchemaObject[this._sourceO.size()];
        for (n = 0; n < this._sourceO.size(); ++n) {
            this._sourceObjects[n] = this._sourceO.get(n);
        }
        OracleDatabase oracleDatabase2 = this._source.getDatabase();
        oracleDatabase = this._dest.getDatabase();
        schema = this._dest.getSchema();
        this._script = TransferHelper.getUpdateDDL((DBObjectProvider)oracleDatabase2, (SchemaObject[])this._sourceObjects, (DBObjectProvider)oracleDatabase, (Schema)schema);
        this._sourceObjects = null;
        this._sourceO = null;
        return true;
    }

    private static DiffPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DiffPanel();
        }
        return INSTANCE;
    }

    public static class DiffController
    implements Controller {
        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DIFF_ACTION) {
                DiffPanel.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == DIFF_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

