/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.sqldialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import oracle.dbtools.raptor.controls.sqldialog.ActionSql;
import oracle.dbtools.raptor.controls.sqldialog.SQLPromptPanel;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSqlPanel
extends JPanel {
    private BasicEditorPane _sql;
    private SQLPromptPanel _sqlPanel;
    private Map<String, Object> _binds;
    private FocusListener _focus = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            ActionSqlPanel.this.update();
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    };

    public ActionSqlPanel(SQLPromptPanel sQLPromptPanel) {
        super(new BorderLayout());
        this._sqlPanel = sQLPromptPanel;
        this.init();
    }

    private void init() {
        if (this._sql == null) {
            this._sql = EditorFactory.createIdeEditorPane();
            this._sql.setPreferredSize(new Dimension(300, 200));
            this._sql.setText("");
            this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
            this._sql.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)this._sql, 22, 32);
            jScrollPane.setPreferredSize(this._sql.getPreferredSize());
            jScrollPane.setSize(jScrollPane.getPreferredSize());
            this.add((Component)jScrollPane, "Center");
            this.addFocusListener(this._focus);
        }
    }

    public void update() {
        this.init();
        ActionSql actionSql = new ActionSql(this._sqlPanel.getAction().getSql(), this._sqlPanel.getDictionary());
        actionSql.processSql(this._sqlPanel.getTextValues(), this._sqlPanel.getValues());
        this._binds = actionSql.getBinds();
        String string = actionSql.manualSubs(actionSql.getSql(), this._sqlPanel.getDictionary());
        this._sql.setPreferredSize(new Dimension(50, 50));
        this._sql.setEditable(true);
        this._sql.setText(string);
        this._sql.setEditable(false);
    }

    public String getSQL() {
        this.update();
        String string = this._sql.getText();
        Pattern pattern = Pattern.compile("(\r\n|\r|\n|\n\r)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = matcher.replaceAll(" ");
        }
        return string;
    }

    public Map<String, Object> getBinds() {
        return this._binds;
    }

    public Map<String, Object> getDictionary() {
        return this._sqlPanel.getDictionary();
    }

    public SQLPromptPanel getPromptPanel() {
        return this._sqlPanel;
    }
}

