/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.table;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.EditableResultSetTable;
import oracle.dbtools.raptor.models.EditableResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.Translate;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.sql.Datum;
import oracle.sql.OPAQUE;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class CopyableResultSetTableAdapter {
    protected final JTable _table;
    protected String _nullValue = "(null)";

    public CopyableResultSetTableAdapter(JTable jTable) {
        this._table = jTable;
    }

    public void setNullString(String string) {
        this._nullValue = string;
    }

    public String getNullString() {
        return this._nullValue;
    }

    public boolean canCopy() {
        return CopyableResultSetTableAdapter.isSelectionSizeOk(this._table.getSelectedRowCount(), this._table.getSelectedRows()) && (this._table.getRowSelectionAllowed() || CopyableResultSetTableAdapter.isSelectionSizeOk(this._table.getSelectedColumnCount(), this._table.getSelectedColumns()));
    }

    public boolean canCut() {
        if (this._table.getModel() instanceof EditableResultSetTableModel) {
            return this.canCopy();
        }
        return false;
    }

    public boolean canPaste() {
        return this._table.getModel() instanceof EditableResultSetTableModel;
    }

    public boolean copyToClipboard() {
        return this.copyToClipboard(false, false);
    }

    public boolean copyToClipboard(boolean bl) {
        return this.copyToClipboard(bl, false);
    }

    public boolean copyToClipboard(boolean bl, boolean bl2) {
        int n = this._table.getSelectedRowCount();
        int[] nArray = this._table.getSelectedRows();
        int n2 = this._table.getColumnCount();
        int[] nArray2 = null;
        nArray2 = this._table.getSelectedColumns();
        Connection connection = null;
        StringBuilder stringBuilder = new StringBuilder(n * n2 * 10);
        if (this._table.getModel() instanceof ResultSetTableModel) {
            connection = ((ResultSetTableModel)this._table.getModel()).getConnection();
            if (bl2 && nArray.length > 0) {
                int n3 = 0;
                for (int i = 0; i < n2; ++i) {
                    if (!this._table.isCellSelected(nArray[0], i)) continue;
                    String string = this.sanitizeStringForCopy(((ResultSetTableModel)this._table.getModel()).getRawColumnName(i));
                    if (n3 != 0 && n3 <= n2 - 1) {
                        stringBuilder.append("\t");
                    }
                    stringBuilder.append(string);
                    ++n3;
                }
                if (nArray.length == 1 && stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
            }
            for (Object object : (StringSelection)nArray) {
                if (nArray.length > 1 && stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    String string;
                    if (!this._table.isCellSelected((int)object, i)) continue;
                    if (n4 != 0 && n4 <= n2 - 1) {
                        stringBuilder.append("\t");
                    }
                    ++n4;
                    Object object2 = this._table.getValueAt((int)object, i);
                    if (object2 instanceof JLabel) {
                        AccessibleContext accessibleContext;
                        JLabel jLabel = (JLabel)object2;
                        string = jLabel.getText();
                        if (!(string != null && string.length() != 0 || (string = (accessibleContext = jLabel.getAccessibleContext()).getAccessibleName()) != null && string.length() != 0)) {
                            string = accessibleContext.getAccessibleDescription();
                        }
                    } else {
                        string = connection != null ? (object2 != null ? DataTypesUtil.stringValue((Object)object2, (Connection)connection) : this._nullValue) : (object2 != null ? this.getValue(object2) : this._nullValue);
                    }
                    stringBuilder.append(this.sanitizeStringForCopy(string));
                    if (!bl || !(this._table.getModel() instanceof EditableResultSetTableModel)) continue;
                    this._table.setValueAt("", (int)object, i);
                }
            }
        }
        StringSelection stringSelection = new StringSelection(stringBuilder.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        if (bl) {
            this._table.repaint();
        }
        return true;
    }

    public void pasteToJTable() {
        if (this._table.getModel() instanceof EditableResultSetTableModel) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            int n = this._table.getSelectedRows()[0];
            int n2 = this._table.getSelectedColumns()[0];
            try {
                String string = (String)clipboard.getContents(this).getTransferData(DataFlavor.stringFlavor);
                ClipBoardPasteAdapter clipBoardPasteAdapter = new ClipBoardPasteAdapter(string);
                List list = clipBoardPasteAdapter.readAllRows();
                for (int i = 0; i < list.size(); ++i) {
                    String[] stringArray = (String[])list.get(i);
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string2 = stringArray[j];
                        int n3 = ((EditableResultSetTableModel)this._table.getModel()).getType(n2 + j);
                        if (DataTypesUtil.isExtendedType((Object)string2, (int)n3)) {
                            ((EditableResultSetTable)this._table).getLogPage().log("\n\n" + Translate.translate((String)"Cannot paste value for column type: ") + DataTypesUtil.getJdbcTypeName((int)n3));
                            continue;
                        }
                        if (n + i >= this._table.getRowCount() || n2 + j >= this._table.getColumnCount()) continue;
                        this._table.setValueAt(string2, n + i, n2 + j);
                    }
                }
                clipBoardPasteAdapter.close();
                this._table.repaint();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public static boolean isSelectionSizeOk(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        int n2 = nArray[nArray.length - 1] - nArray[0];
        return n - 1 == n2 && n == nArray.length;
    }

    protected static int[] _getColumnList(JTable jTable) {
        if (jTable == null) {
            return new int[0];
        }
        int n = jTable.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        return nArray;
    }

    protected String getValue(Object object) {
        TableModel tableModel = this._table.getModel();
        ResultSetTableModel resultSetTableModel = null;
        String string = this._nullValue;
        if (tableModel instanceof ResultSetTableModel) {
            resultSetTableModel = (ResultSetTableModel)tableModel;
        }
        try {
            string = object instanceof Clob ? ((Clob)object).getSubString(1L, (int)((Clob)object).length()) : (object instanceof OPAQUE ? ((OPAQUE)object).getSQLTypeName().trim() : (object instanceof TIMESTAMPTZ && resultSetTableModel != null ? ((TIMESTAMPTZ)object).stringValue(resultSetTableModel.getConnection()) : (object instanceof TIMESTAMPLTZ && resultSetTableModel != null ? ((TIMESTAMPLTZ)object).stringValue(resultSetTableModel.getConnection()) : (object instanceof Datum ? ((Datum)object).stringValue() : object.toString()))));
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        return string;
    }

    private String sanitizeStringForCopy(String string) {
        String string2 = "\r\n|[\r\n\u2028\u2029\u0085]|\t";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return "\"" + string + "\"";
        }
        return string;
    }

    private class ClipBoardPasteAdapter {
        private BufferedReader _reader;
        public boolean _hasMore = true;
        private char _separator = (char)9;
        private char _quotechar = (char)34;

        public ClipBoardPasteAdapter(String string) {
            this(new BufferedReader(new StringReader(string)));
        }

        public ClipBoardPasteAdapter(BufferedReader bufferedReader) {
            this._reader = bufferedReader;
        }

        public List readAllRows() throws IOException {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (this._hasMore) {
                String[] stringArray = this.readNextRow();
                if (stringArray == null) continue;
                arrayList.add(stringArray);
            }
            return arrayList;
        }

        public String[] readNextRow() throws IOException {
            String string = this.getNextRow();
            return this._hasMore ? this.parseRow(string) : null;
        }

        private String getNextRow() throws IOException {
            String string = this._reader.readLine();
            if (string == null) {
                this._hasMore = false;
            }
            return this._hasMore ? string : null;
        }

        private String[] parseRow(String string) throws IOException {
            if (string == null) {
                return null;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            do {
                if (bl) {
                    stringBuffer.append("\n");
                    string = this.getNextRow();
                    if (string == null) break;
                }
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == this._quotechar) {
                        if (bl && string.length() > i + 1 && string.charAt(i + 1) == this._quotechar) {
                            stringBuffer.append(string.charAt(i + 1));
                            ++i;
                            continue;
                        }
                        boolean bl2 = bl = !bl;
                        if (i <= 2 || string.charAt(i - 1) == this._separator || string.length() <= i + 1 || string.charAt(i + 1) == this._separator) continue;
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == this._separator && !bl) {
                        arrayList.add(stringBuffer.toString());
                        stringBuffer = new StringBuffer();
                        continue;
                    }
                    stringBuffer.append(c);
                }
            } while (bl);
            arrayList.add(stringBuffer.toString());
            return arrayList.toArray(new String[0]);
        }

        public void close() throws IOException {
            this._reader.close();
        }
    }
}

