/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.util.ArrayList;
import oracle.dbtools.raptor.data.core.Baseable;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.Table;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;

public class GenericTable
implements Baseable {
    private Table table;

    public GenericTable(Relation relation) {
        this.populateTable(relation);
    }

    public GenericTable(Table table) {
        this.table = table;
    }

    public GenericTable() {
        this.table = new Table();
    }

    private void populateTable(Relation relation) {
        try {
            Table table = new Table();
            table.setTablename(relation.getName());
            oracle.javatools.db.Column[] columnArray = relation.getColumns();
            for (int i = 0; i < columnArray.length; ++i) {
                Column column = new Column();
                column.setName(columnArray[i].getName());
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)columnArray[i].getDataTypeUsage());
                column.setType(dataType.getName());
                column.setNullable(columnArray[i].isNotNull());
                column.setComment((String)columnArray[i].getProperty("Comment"));
                Object object = columnArray[i].getDataTypeUsage().getAttributeValue("precision");
                if (object != null) {
                    column.setPrecision(Integer.parseInt(object.toString()));
                } else {
                    object = columnArray[i].getDataTypeUsage().getAttributeValue("size");
                    if (object != null) {
                        column.setPrecision(Integer.parseInt(object.toString()));
                    }
                }
                object = columnArray[i].getDataTypeUsage().getAttributeValue("scale");
                if (object != null) {
                    column.setScale(Integer.parseInt(object.toString()));
                }
                table.addColumn(column);
                this.table = table;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
    }

    public void addColumn(Column column) {
        this.table.addColumn(column);
    }

    public Column getColumn(int n) {
        return this.getColumns()[n];
    }

    public Column[] getColumns() {
        return this.table.getColumns().toArray(new Column[this.table.getColumns().size()]);
    }

    public String getDataType(Column column) {
        return column.getType();
    }

    public Table getTable() {
        return this.table;
    }

    public void setColumns(Column[] columnArray) {
        ArrayList<Column> arrayList = this.table.getColumns();
        if (arrayList != null) {
            arrayList.clear();
            for (int i = 0; i < columnArray.length; ++i) {
                arrayList.add(columnArray[i]);
            }
            this.table.setColumns(arrayList.toArray(new Column[arrayList.size()]));
        }
    }

    public void setTableName(String string) {
        this.table.setTablename(string);
    }
}

