/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.core;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.ui.PreReqListener;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.util.ModelUtil;

public class ImportPreRequisiteChecker {
    public static final int ALL_OK = 0;
    public static final int FAIL = 1;
    public static final int WARN = 2;
    private ArrayList<PreReqListener> m_audience = new ArrayList();
    private TraversableContext m_ctx;
    private GenericTable table;
    private Column[] selectedColumns;
    private int testResult = 0;

    public ImportPreRequisiteChecker(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
    }

    public int runTests() {
        this.table = (GenericTable)this.m_ctx.get("TABLE");
        this.selectedColumns = (Column[])this.m_ctx.get("SELECTED_COLUMNS");
        this.tableNameOK();
        this.allColumnsMapped();
        this.columnsHaveDataTypes();
        this.columnsHaveSize();
        this.datesHaveMasks();
        this.dataTypeSupported();
        return this.testResult;
    }

    private void allColumnsMapped() {
        this.fireStartTest(DataImportArb.getString(53), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (Column column : this.table.getColumns()) {
            if (ModelUtil.hasLength((String)column.getName())) continue;
            bl = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString(53), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString(53), false, DataImportArb.format(61, stringBuffer.toString()));
        }
    }

    private void tableNameOK() {
        this.fireStartTest(DataImportArb.getString(51), null);
        String string = this.table.getTable().getTablename();
        if (ModelUtil.hasLength((String)string)) {
            if (ImportPreRequisiteChecker.containsWhiteSpace(string)) {
                this.testResult = 1;
                this.fireEndTest(DataImportArb.getString(51), false, DataImportArb.format(59, string));
            } else {
                this.fireEndTest(DataImportArb.getString(51), true, null);
            }
        } else {
            this.fireEndTest(DataImportArb.getString(51), false, DataImportArb.getString(58));
        }
    }

    private void columnNamesOK() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        this.fireStartTest(DataImportArb.getString(52), null);
        for (Column column : this.table.getColumns()) {
            if (!ModelUtil.hasLength((String)column.getName()) || !ImportPreRequisiteChecker.containsWhiteSpace(column.getName())) continue;
            bl = true;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString(52), false, DataImportArb.format(60, stringBuffer.toString()));
        } else {
            this.fireEndTest(DataImportArb.getString(52), true, null);
        }
    }

    private void columnsHaveDataTypes() {
        this.fireStartTest(DataImportArb.getString(54), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (Column column : this.table.getColumns()) {
            if (ModelUtil.hasLength((String)column.getType())) continue;
            bl = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString(54), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString(54), false, DataImportArb.format(62, stringBuffer.toString()));
        }
    }

    private void columnsHaveSize() {
        this.fireStartTest(DataImportArb.getString(57), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        for (Column column : this.table.getColumns()) {
            String string = column.getType();
            if (!DataType.VARCHAR2.toString().equals(string) && !DataType.CHAR.toString().equals(string) && !DataType.NCHAR.toString().equals(string) && !DataType.NVARCHAR2.toString().equals(string) || column.getPrecision() > 0) continue;
            bl = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString(57), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString(57), false, DataImportArb.format(65, stringBuffer.toString()));
        }
    }

    private void datesHaveMasks() {
        this.fireStartTest(DataImportArb.getString(55), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Locale locale = (Locale)this.m_ctx.get("LOCALE");
        for (Column column : this.table.getColumns()) {
            if (!ModelUtil.hasLength((String)column.getType()) || !DataType.DATE.toString().equals(column.getType())) continue;
            String string = column.getFormat();
            if (ModelUtil.hasLength((String)string)) {
                try {
                    OraDATEFormat oraDATEFormat = new OraDATEFormat(string, OraLocaleInfo.getInstance((Locale)locale));
                }
                catch (ParseException parseException) {
                    bl = false;
                    stringBuffer.append(column.getSourceColumnName());
                    stringBuffer.append(", ");
                }
                continue;
            }
            bl = false;
            stringBuffer.append(column.getSourceColumnName());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString(55), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString(55), false, DataImportArb.format(63, stringBuffer.toString()));
        }
    }

    private void dataTypeSupported() {
        this.fireStartTest(DataImportArb.getString(56), null);
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        List list = DataType.getValuesAsList();
        for (Column column : this.table.getColumns()) {
            if (!ModelUtil.hasLength((String)column.getType()) || list.contains(column.getType())) continue;
            bl = false;
            stringBuffer.append(column.getType());
            stringBuffer.append(", ");
        }
        if (bl) {
            this.fireEndTest(DataImportArb.getString(56), true, null);
        } else {
            this.testResult = 1;
            this.fireEndTest(DataImportArb.getString(56), false, DataImportArb.format(64, stringBuffer.toString()));
        }
    }

    public void addListener(PreReqListener preReqListener) {
        if (!this.m_audience.contains(preReqListener)) {
            this.m_audience.add(preReqListener);
        }
    }

    protected boolean fireEndTest(String string, boolean bl, String string2) {
        for (PreReqListener preReqListener : this.m_audience) {
            preReqListener.testCompleted(string, bl, string2);
        }
        return bl;
    }

    protected void fireStartTest(String string, String string2) {
        for (PreReqListener preReqListener : this.m_audience) {
            preReqListener.testStarted(string, string2);
        }
    }

    public static boolean containsWhiteSpace(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }
}

