/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.ui.ColumnListPanel;
import oracle.dbtools.raptor.data.ui.ColumnMapMediator;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;
import oracle.dbtools.raptor.data.ui.KnownColumnPropertiesPanel;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Relation;

public class ColumnPanel
extends DefaultTraversablePanel
implements ListSelectionListener,
ColumnChangeListener {
    private static final long serialVersionUID = 8282169188783793125L;
    private JTextField tableNameField;
    private GenericTable table;
    private JTextPane instructions;
    private ColumnListPanel clp;
    private boolean insertToExistingTable;
    private ColumnPropertyPanel colPanel;
    private GridBagConstraints cppConstraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private static final String HTMLCONTENT = "text/html";
    private Column column;
    private TraversableContext m_ctx;

    public ColumnPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{7, 7, 7, 7, 0};
        this.setLayout(gridBagLayout);
        this.instructions = new JTextPane();
        this.instructions.setContentType(HTMLCONTENT);
        this.instructions.setEditable(false);
        this.instructions.setOpaque(false);
        this.instructions.setRequestFocusEnabled(false);
        this.instructions.setFocusable(false);
        this.add(this.instructions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("Table Name");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.tableNameField = new JTextField();
        this.tableNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                String string = ((JTextField)keyEvent.getSource()).getText();
                ColumnPanel.this.table.setTableName(string);
                ColumnPanel.this.table.getTable().setTablename(string);
                if (string.trim().length() > 0) {
                    ColumnPanel.this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.add(jPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.tableNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.clp = new ColumnListPanel();
        this.clp.getLstColumns().setSelectionModel(new SingleSelectionModel(){

            public void updateSingleSelection(int n, int n2) {
                if (n >= 0) {
                    Column column = (Column)ColumnPanel.this.clp.getLstColumns().getModel().getElementAt(n);
                    if (ColumnPanel.this.colPanel != null && column != null) {
                        column.refreshData(ColumnPanel.this.colPanel.getColumnDetails());
                    }
                }
            }
        });
        this.clp.getLstColumns().addListSelectionListener(this);
        this.add(this.clp, new GridBagConstraints(0, 2, 1, 1, 2.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void notifyMediator() {
        ColumnMapMediator.getInstance().selChangeNotification(this.clp);
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this.populateDBO(traversableContext);
        this.populateTableName();
        this.populateSrcDataColumns(traversableContext);
        this.setupColumnDetails(traversableContext);
        if (this.insertToExistingTable) {
            this.refreshColumnData();
        }
        this.column = (Column)this.clp.getLstColumns().getModel().getElementAt(0);
        this.colPanel.setColumn(this.column);
    }

    private void refreshColumnData() {
        for (int i = 0; i < this.clp.getLstColumns().getModel().getSize(); ++i) {
            Column column = (Column)this.clp.getLstColumns().getModel().getElementAt(i);
            Column column2 = this.table.getTable().getColumnByName(column.getName().trim());
            column.refreshData(column2);
        }
    }

    private void setupColumnDetails(TraversableContext traversableContext) {
        if (this.colPanel != null) {
            this.remove(this.colPanel);
        }
        if (this.insertToExistingTable) {
            KnownColumnPropertiesPanel knownColumnPropertiesPanel = new KnownColumnPropertiesPanel();
            knownColumnPropertiesPanel.setTable((Relation)((DBObject)traversableContext.get("DBOBJECT")).getSchemaObject());
            this.colPanel = knownColumnPropertiesPanel;
            this.add(knownColumnPropertiesPanel, this.cppConstraints);
            knownColumnPropertiesPanel.addColumnChangeListener(this);
        } else {
            ColumnPropertiesPanel columnPropertiesPanel = new ColumnPropertiesPanel();
            this.colPanel = columnPropertiesPanel;
            columnPropertiesPanel.setTable(this.table);
            this.add(columnPropertiesPanel, this.cppConstraints);
            columnPropertiesPanel.addColumnChangeListener(this);
        }
        this.validate();
    }

    private void populateTableName() {
        this.tableNameField.setEditable(!this.insertToExistingTable);
        this.tableNameField.setFocusable(!this.insertToExistingTable);
        this.tableNameField.setText(this.table.getTable().getTablename());
        if (this.tableNameField.getText().trim().length() > 0) {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        } else {
            this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        }
    }

    private void populateSrcDataColumns(TraversableContext traversableContext) {
        ((DefaultListModel)this.clp.getLstColumns().getModel()).clear();
        Column[] columnArray = (Column[])traversableContext.get("SELECTED_COLUMNS");
        for (int i = 0; i < columnArray.length; ++i) {
            this.clp.addColumn(columnArray[i]);
        }
        this.clp.getLstColumns().setSelectedIndex(0);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        Column column = (Column)this.clp.getLstColumns().getSelectedValue();
        column.refreshData(this.colPanel.getColumnDetails());
        ListModel listModel = this.clp.getLstColumns().getModel();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < listModel.getSize(); ++i) {
            arrayList.add((Column)listModel.getElementAt(i));
        }
        Column[] columnArray = arrayList.toArray(new Column[arrayList.size()]);
        traversableContext.put("INSERT_INTO_EXISTING_TABLE", (Object)this.insertToExistingTable);
        if (!this.insertToExistingTable) {
            this.table.setColumns(columnArray);
        }
        traversableContext.put("TABLE_NAME", (Object)this.tableNameField.getText());
        this.table.setTableName(this.tableNameField.getText());
        this.table.setColumns(columnArray);
        traversableContext.put("TABLE", (Object)this.table);
        traversableContext.put("VALIDATED", (Object)Boolean.FALSE);
    }

    private void populateDBO(TraversableContext traversableContext) {
        GenericTable genericTable = null;
        if (traversableContext.get("DBOBJECT") == null) {
            genericTable = new GenericTable();
        } else if (((DBObject)traversableContext.get("DBOBJECT")).getObjectName() != null) {
            this.insertToExistingTable = true;
            genericTable = new GenericTable((Relation)((DBObject)traversableContext.get("DBOBJECT")).getSchemaObject());
        } else {
            genericTable = new GenericTable();
            ArrayList<Column> arrayList = new ArrayList<Column>();
            ListModel listModel = this.clp.getLstColumns().getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                if (listModel.getElementAt(i) == null) continue;
                arrayList.add((Column)listModel.getElementAt(i));
            }
            genericTable.getTable().setColumns(arrayList.toArray(new Column[arrayList.size()]));
        }
        if (traversableContext.get("TABLE") != null) {
            this.setTable((GenericTable)traversableContext.get("TABLE"));
        } else {
            this.setTable(genericTable);
        }
        this.setInstruction((DBObject)traversableContext.get("DBOBJECT"));
    }

    private void setInstruction(DBObject dBObject) {
        if (dBObject != null && dBObject.getObjectName() != null) {
            this.instructions.setText(DataImportArb.getString(13));
            return;
        }
        this.instructions.setText(DataImportArb.getString(14));
    }

    private void setTable(GenericTable genericTable) {
        this.table = genericTable;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            this.column = (Column)((JList)listSelectionEvent.getSource()).getSelectedValue();
            if (this.column != null && this.colPanel != null) {
                this.colPanel.setColumn(this.column);
            }
        }
    }

    public void columnChanged(ColumnChangeEvent columnChangeEvent) {
        Column column = columnChangeEvent.getColumn();
        this.column.refreshData(column);
        System.out.println("Panel Properties");
        System.out.println("NAme:" + column.getName());
        System.out.println("src NameNAme:" + column.getSourceColumnName());
    }

    private class SingleSelectionModel
    extends DefaultListSelectionModel {
        public SingleSelectionModel() {
            this.setSelectionMode(0);
        }

        public void setSelectionInterval(int n, int n2) {
            int n3 = this.getMinSelectionIndex();
            super.setSelectionInterval(n, n2);
            int n4 = this.getMinSelectionIndex();
            if (n3 != n4) {
                this.updateSingleSelection(n3, n4);
            }
        }

        public void updateSingleSelection(int n, int n2) {
        }
    }
}

