/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.ui.ColumnPropertyPanel;

public class ColumnPropertiesPanel
extends ColumnPropertyPanel {
    private static final long serialVersionUID = -320015483611378667L;

    public ColumnPropertiesPanel() {
        this.typeField = new JComboBox<DataType>(DataType.values());
        this.add(this.typeField, this.typeFieldConstraints);
        ((JComboBox)this.typeField).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                switch ((DataType)((Object)jComboBox.getSelectedItem())) {
                    case DATE: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.addDateMask();
                        break;
                    }
                    case INTEGER: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    case TIMESTAMP: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.removeDateMask();
                        break;
                    }
                    default: {
                        ColumnPropertiesPanel.this.removePrecisionScale();
                        ColumnPropertiesPanel.this.addPrecisionScale();
                        ColumnPropertiesPanel.this.removeDateMask();
                    }
                }
            }
        });
        this.nameField = new JTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)this.nameField, gridBagConstraints);
    }

    void switchColumn(Column column) {
        Column column2 = null;
        if (column != null) {
            column2 = this.m_table.getSrcColName(column.getName());
        }
        if (column2 == null) {
            column2 = this.m_table.getColumnByName(column.getName());
        }
        if (column2 == null) {
            this.m_table.addColumn(column);
        }
        if (column != null) {
            this.setColumn(column);
        }
    }

    void setTable(GenericTable genericTable) {
        this.m_table = genericTable.getTable();
        for (Column column : this.m_table.getColumns()) {
        }
    }

    void setColumnName(String string) {
        this.nameField.setText(string);
    }

    void setDataType(String string) {
        if (string != null) {
            ComboBoxModel comboBoxModel = ((JComboBox)this.typeField).getModel();
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                DataType dataType = (DataType)((Object)comboBoxModel.getElementAt(i));
                if (!string.toUpperCase().equals(dataType.toString())) continue;
                ((JComboBox)this.typeField).setSelectedIndex(i);
                return;
            }
        }
    }

    public Column getColumnDetails() {
        Column column = new Column();
        column.setName(this.nameField.getText());
        column.setType(((DataType)((Object)((JComboBox)this.typeField).getSelectedItem())).toString());
        if (this.scaleField.getText() != null && !this.scaleField.getText().equals("")) {
            column.setScale(Integer.parseInt(this.scaleField.getText()));
        }
        if (this.precisionField.getText() != null && !this.precisionField.getText().equals("")) {
            column.setPrecision(Integer.parseInt(this.precisionField.getText()));
        }
        column.setNullable(this.nullCheck.isSelected());
        column.setComment(this.commentArea.getText());
        column.setDefault(this.defaultField.getText());
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType())) {
            column.setFormat(this.dateMask.getText());
        }
        if (column.getType().equals((Object)DataType.VARCHAR2) && column.getScale() < 1) {
            column.setScale(200);
        }
        this.column = column;
        return column;
    }

    void setColumn(Column column) {
        this.column = column;
        this.setColumnName(column.getName());
        this.setDataType(column.getType());
        this.setPrecision(column.getPrecision());
        this.setScale(column.getScale());
        this.setNullable(column.isNullable());
        this.defaultField.setText(column.getDefault());
        this.setComment(column.getComment());
        if (DataType.DATE.toString().equalsIgnoreCase(column.getType())) {
            this.setDateMask(column.getFormat());
        }
    }
}

