/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.core.ColumnChangeEvent;
import oracle.dbtools.raptor.data.core.ColumnChangeListener;
import oracle.dbtools.raptor.data.core.DataType;
import oracle.dbtools.raptor.data.core.GenericTable;
import oracle.dbtools.raptor.data.core.Table;
import oracle.dbtools.raptor.data.ui.ColumnPropertiesPanel;
import oracle.javatools.util.ModelUtil;

abstract class ColumnPropertyPanel
extends JPanel {
    private static final long serialVersionUID = 7720631577011179873L;
    protected Column currentSrcColumn;
    protected Table m_table;
    protected JLabel nameLabel;
    protected JLabel typeLabel;
    protected JLabel scaleLabel;
    protected JLabel precisionLabel;
    protected JLabel defaultLabel;
    protected JTextField nameField;
    protected Component typeField;
    protected JTextField scaleField;
    protected JTextField precisionField;
    protected JTextField defaultField;
    protected JCheckBox nullCheck;
    protected JLabel commentLabel;
    protected JTextArea commentArea;
    protected JScrollPane commentPane;
    protected GridBagConstraints precisionTextfieldConstraints;
    protected GridBagConstraints scaleTextfieldConstraints;
    protected GridBagConstraints precisionLabelConstraints;
    protected GridBagConstraints scaleLabelConstraints;
    protected GridBagConstraints dateMaskLblConstraints;
    protected GridBagConstraints dateMaskConstraints;
    protected Column column;
    protected GridBagConstraints typeFieldConstraints = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
    private ArrayList<ColumnChangeListener> listeners = new ArrayList();
    protected JTextField dateMask;
    protected JLabel dateMaskLbl;

    public ColumnPropertyPanel() {
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(DataImportArb.getString(16)));
        this.nameLabel = new JLabel();
        this.nameLabel.setText(DataImportArb.getString(31));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.typeLabel = new JLabel();
        this.typeLabel.setText(DataImportArb.getString(32));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add((Component)this.typeLabel, gridBagConstraints2);
        this.precisionLabel = new JLabel();
        this.precisionLabel.setText(DataImportArb.getString(35));
        this.precisionLabelConstraints = new GridBagConstraints();
        this.precisionLabelConstraints.insets = new Insets(5, 5, 0, 5);
        this.precisionLabelConstraints.gridy = 3;
        this.precisionLabelConstraints.gridx = 0;
        this.precisionLabelConstraints.anchor = 13;
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.scaleLabel = new JLabel();
        this.scaleLabel.setText(DataImportArb.getString(34));
        this.scaleLabelConstraints = new GridBagConstraints();
        this.scaleLabelConstraints.insets = new Insets(5, 5, 0, 5);
        this.scaleLabelConstraints.gridy = 4;
        this.scaleLabelConstraints.gridx = 0;
        this.scaleLabelConstraints.anchor = 13;
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.dateMaskLbl = new JLabel();
        this.dateMaskLbl.setText("Date Format");
        this.dateMaskLblConstraints = new GridBagConstraints();
        this.dateMaskLblConstraints.insets = new Insets(5, 5, 0, 5);
        this.dateMaskLblConstraints.gridy = 5;
        this.dateMaskLblConstraints.gridx = 0;
        this.dateMaskLblConstraints.anchor = 13;
        this.defaultLabel = new JLabel();
        this.defaultLabel.setText(DataImportArb.getString(33));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints3.gridy = 6;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 13;
        this.add((Component)this.defaultLabel, gridBagConstraints3);
        this.precisionField = new JTextField();
        this.precisionTextfieldConstraints = new GridBagConstraints();
        this.precisionTextfieldConstraints.gridwidth = 2;
        this.precisionTextfieldConstraints.insets = new Insets(5, 5, 0, 5);
        this.precisionTextfieldConstraints.fill = 2;
        this.precisionTextfieldConstraints.weightx = 1.0;
        this.precisionTextfieldConstraints.gridy = 3;
        this.precisionTextfieldConstraints.gridx = 1;
        this.precisionField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent focusEvent) {
                String string = ((JTextField)focusEvent.getSource()).getText();
                ColumnPropertyPanel.this.scaleField.setEditable(false);
                String string2 = "";
                if (ColumnPropertyPanel.this.typeField instanceof JComboBox) {
                    string2 = ((JComboBox)ColumnPropertyPanel.this.typeField).getSelectedItem().toString();
                } else if (ColumnPropertyPanel.this.typeField instanceof JTextField) {
                    string2 = ((JTextField)ColumnPropertyPanel.this.typeField).getText();
                }
                if (ModelUtil.hasLength((String)string) && DataType.NUMBER.toString().equals(string2) && Integer.parseInt(string.trim()) > 0) {
                    ColumnPropertyPanel.this.scaleField.setEditable(true);
                }
            }

            public void focusGained(FocusEvent focusEvent) {
            }
        });
        this.add((Component)this.precisionField, this.precisionTextfieldConstraints);
        this.scaleField = new JTextField();
        this.scaleTextfieldConstraints = new GridBagConstraints();
        this.scaleTextfieldConstraints.gridwidth = 2;
        this.scaleTextfieldConstraints.insets = new Insets(5, 5, 0, 5);
        this.scaleTextfieldConstraints.fill = 2;
        this.scaleTextfieldConstraints.weightx = 1.0;
        this.scaleTextfieldConstraints.gridy = 4;
        this.scaleTextfieldConstraints.gridx = 1;
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        this.scaleField.setEditable(false);
        this.dateMask = new JTextField();
        this.dateMaskConstraints = new GridBagConstraints();
        this.dateMaskConstraints.gridwidth = 2;
        this.dateMaskConstraints.insets = new Insets(5, 5, 0, 5);
        this.dateMaskConstraints.fill = 2;
        this.dateMaskConstraints.weightx = 1.0;
        this.dateMaskConstraints.gridy = 5;
        this.dateMaskConstraints.gridx = 1;
        this.addDateMask();
        this.defaultField = new JTextField();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 6;
        gridBagConstraints4.gridx = 2;
        this.add((Component)this.defaultField, gridBagConstraints4);
        this.nullCheck = new JCheckBox("Nullable?");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.gridy = 6;
        gridBagConstraints5.gridx = 0;
        this.add((Component)this.nullCheck, gridBagConstraints5);
        this.commentLabel = new JLabel();
        this.commentLabel.setText(DataImportArb.getString(36));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints6.gridy = 7;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.anchor = 17;
        this.add((Component)this.commentLabel, gridBagConstraints6);
        this.commentArea = new JTextArea();
        this.commentPane = new JScrollPane(this.commentArea);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.gridwidth = 3;
        gridBagConstraints7.gridy = 8;
        gridBagConstraints7.gridx = 0;
        this.add((Component)this.commentPane, gridBagConstraints7);
        this.removeDateMask();
    }

    protected void addPrecisionScale() {
        this.add((Component)this.precisionLabel, this.precisionLabelConstraints);
        this.add((Component)this.scaleLabel, this.scaleLabelConstraints);
        this.add((Component)this.precisionField, this.precisionTextfieldConstraints);
        this.add((Component)this.scaleField, this.scaleTextfieldConstraints);
        if (this.column != null) {
            this.precisionField.setText(String.valueOf(this.column.getPrecision()));
            this.scaleField.setText(String.valueOf(this.column.getScale()));
        }
        this.revalidate();
        this.repaint();
    }

    protected void removePrecisionScale() {
        this.remove(this.precisionLabel);
        this.remove(this.scaleLabel);
        this.remove(this.precisionField);
        this.remove(this.scaleField);
        this.revalidate();
        this.repaint();
    }

    protected void addDateMask() {
        this.add((Component)this.dateMaskLbl, this.dateMaskLblConstraints);
        this.add((Component)this.dateMask, this.dateMaskConstraints);
        this.revalidate();
        this.repaint();
    }

    protected void removeDateMask() {
        this.remove(this.dateMaskLbl);
        this.remove(this.dateMask);
        this.revalidate();
        this.repaint();
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        ColumnPropertiesPanel columnPropertiesPanel = new ColumnPropertiesPanel();
        jDialog.add(columnPropertiesPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    abstract void setColumn(Column var1);

    public Column getColumn() {
        return this.column;
    }

    protected void setComment(String string) {
        this.commentArea.setText(string);
    }

    protected String getComment() {
        return this.commentArea.getText();
    }

    protected void setNullable(boolean bl) {
        this.nullCheck.setSelected(bl);
    }

    protected boolean setNullable() {
        return this.nullCheck.isSelected();
    }

    protected void setScale(int n) {
        if (this.scaleField != null) {
            this.scaleField.setText(String.valueOf(n));
        }
    }

    protected int getScale() {
        if (this.scaleField != null) {
            return Integer.parseInt(this.scaleField.getText());
        }
        return 0;
    }

    protected void setPrecision(int n) {
        this.precisionField.setText(String.valueOf(n));
    }

    abstract void setDataType(String var1);

    abstract void setColumnName(String var1);

    abstract void switchColumn(Column var1);

    public void editable(boolean bl) {
        this.precisionField.setEditable(bl);
        this.precisionField.setFocusable(bl);
        this.scaleField.setEditable(bl);
        this.scaleField.setFocusable(bl);
        this.commentArea.setEditable(bl);
        this.commentArea.setFocusable(bl);
        this.nullCheck.setEnabled(bl);
        this.nullCheck.setFocusable(bl);
        this.defaultField.setEditable(bl);
        this.defaultField.setFocusable(bl);
    }

    public void setDataTable(GenericTable genericTable) {
        this.setTable(genericTable);
    }

    abstract void setTable(GenericTable var1);

    abstract Column getColumnDetails();

    public void addColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.listeners.add(columnChangeListener);
    }

    public void removeColumnChangeListener(ColumnChangeListener columnChangeListener) {
        this.listeners.remove(columnChangeListener);
    }

    public void firelisteners(ColumnChangeEvent columnChangeEvent) {
        Iterator<ColumnChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().columnChanged(columnChangeEvent);
        }
    }

    public JTextField getDateMask() {
        return this.dateMask;
    }

    public void setDateMask(String string) {
        if (this.dateMask != null) {
            this.dateMask.setText(string);
        }
    }
}

