/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.readers.DataReadable;
import oracle.dbtools.raptor.data.readers.DataReaderEvent;
import oracle.dbtools.raptor.data.readers.DataReaderListener;
import oracle.dbtools.raptor.data.readers.DataReaderRegistry;
import oracle.i18n.util.OraLocaleInfo;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;

public class DataPreviewPanel
extends DefaultTraversablePanel
implements DataReaderListener {
    private static final long serialVersionUID = -5525219439802104748L;
    private String filename;
    private String type;
    private boolean header;
    private String[] columns;
    private JTable table;
    private int pageId = 0;
    private JComboBox comboBox;
    private JLabel worksheetLabel;
    private DataReadable datareader;
    private JCheckBox headerCheckBox;
    private int pages;
    private final GridBagConstraints singlePageHeaderConstraints = new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints pageLabelConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints pagelistComboConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints pagelistHeaderConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints scrollPaneConstraints = new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints useMapChkBoxConstraints = new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints filePanelConstraints = new GridBagConstraints(0, 5, 3, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0);
    private JScrollPane scrollPane;
    private ActionListener comboListener;
    private FilePanel filePanel;
    private JCheckBox useMapChkBox;
    private JComboBox localeCbx;
    private JLabel localeLbl;
    private final GridBagConstraints localeCbxConstraints = new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private final GridBagConstraints localeLblConstraints = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
    private boolean resetData;
    private TraversableContext m_ctx;

    public DataPreviewPanel() {
        this.initUI();
    }

    private void initUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.worksheetLabel = new JLabel();
        this.add(this.worksheetLabel, this.pageLabelConstraints);
        this.comboBox = new JComboBox();
        this.comboBox.addActionListener(this.comboListener);
        this.comboListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataPreviewPanel.this.fireComboChanged();
            }
        };
        this.comboBox.setRenderer(new DefaultListCellRenderer());
        this.add(this.comboBox, this.pagelistComboConstraints);
        this.headerCheckBox = new JCheckBox();
        this.headerCheckBox.setSelected(true);
        this.headerCheckBox.setText(DataImportArb.getString(3));
        this.headerCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                DataPreviewPanel.this.populateDataTable(DataPreviewPanel.this.datareader);
                if (jCheckBox.isSelected()) {
                    DataPreviewPanel.access$302(DataPreviewPanel.this, DataPreviewPanel.this.datareader.getColumnNames());
                }
                DataPreviewPanel.this.resetData = true;
            }
        });
        this.add(this.headerCheckBox, this.pagelistHeaderConstraints);
        this.localeLbl = new JLabel(DataImportArb.getString(68));
        this.localeCbx = new JComboBox();
        String[] stringArray = OraLocaleInfo.getAvailableLanguages();
        this.localeCbx.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.localeCbx.setSelectedItem(OraLocaleInfo.getDefault().getLanguage());
        this.add(this.localeLbl, this.localeLblConstraints);
        this.add(this.localeCbx, this.localeCbxConstraints);
        this.scrollPane = new JScrollPane(22, 32);
        this.add(this.scrollPane, this.scrollPaneConstraints);
        this.table = new JTable();
        this.scrollPane.setViewportView(this.table);
        this.filePanel = new FilePanel();
    }

    private void addFilePanel() {
        this.add(this.filePanel, this.filePanelConstraints);
        this.revalidate();
        this.repaint();
    }

    private void removeFilePanel() {
        this.remove(this.filePanel);
        this.revalidate();
        this.repaint();
    }

    private void fireComboChanged() {
        this.pageId = this.comboBox.getSelectedIndex();
        this.datareader.setPage(this.pageId);
        this.populateDataTable(this.datareader);
        this.resetData = true;
    }

    public JLabel getWorksheetLabel() {
        return this.worksheetLabel;
    }

    public void setWorksheetLabel(JLabel jLabel) {
        this.worksheetLabel = jLabel;
    }

    public DataReadable getDataReader() {
        return this.datareader;
    }

    public void setDataReader(DataReadable dataReadable) {
        this.datareader = dataReadable;
        this.pages = dataReadable.getNosPages();
        this.worksheetLabel = new JLabel(dataReadable.getPageLabel());
        this.fireReaderChanged();
    }

    private void fireReaderChanged() {
        if (this.pages <= 1) {
            this.remove(this.worksheetLabel);
            this.remove(this.comboBox);
            this.remove(this.headerCheckBox);
            this.add(this.headerCheckBox, this.singlePageHeaderConstraints);
        } else if (this.pages > 1) {
            this.removeAll();
            this.add(this.worksheetLabel, this.pageLabelConstraints);
            this.rebuildCombo();
            this.add(this.comboBox, this.pagelistComboConstraints);
            this.add(this.headerCheckBox, this.pagelistHeaderConstraints);
            this.add(this.localeLbl, this.localeLblConstraints);
            this.add(this.localeCbx, this.localeCbxConstraints);
            this.add(this.scrollPane, this.scrollPaneConstraints);
        }
        this.populateDataTable(this.datareader);
        this.columns = this.datareader.getColumnNames();
        this.resetData = true;
    }

    private void rebuildCombo() {
        this.comboBox = new JComboBox<String>(this.datareader.getPageNames());
        this.comboBox.addActionListener(this.comboListener);
    }

    private void populateDataTable(DataReadable dataReadable) {
        this.table.setModel(dataReadable.getTableModel(this.headerCheckBox.isSelected()));
    }

    public void setHeader(boolean bl) {
        this.headerCheckBox.setSelected(bl);
    }

    public boolean isHeaderSelected() {
        return this.headerCheckBox.isSelected();
    }

    public static void main(String[] stringArray) {
        DataReadable dataReadable = DataReaderRegistry.getReader("CSV");
        dataReadable.setFileName("d:\\code\\test.csv");
        JDialog jDialog = new JDialog();
        jDialog.setLayout(new BorderLayout());
        DataPreviewPanel dataPreviewPanel = new DataPreviewPanel();
        dataPreviewPanel.setDataReader(dataReadable);
        dataReadable.addListener(dataPreviewPanel);
        jDialog.add((Component)((Object)dataPreviewPanel), "Center");
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(true);
    }

    public void raiseEvent(DataReaderEvent dataReaderEvent) {
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        traversableContext.put("HEADER", (Object)(this.isHeaderSelected() ? Boolean.TRUE : Boolean.FALSE));
        traversableContext.put("FILENAME", (Object)this.filename);
        traversableContext.put("IMPORT_TYPE", (Object)this.type);
        traversableContext.put("PAGEID", (Object)this.pageId);
        String string = (String)this.localeCbx.getSelectedItem();
        Locale locale = new Locale(string);
        traversableContext.put("LOCALE", (Object)locale);
        TableColumnModel tableColumnModel = this.table.getTableHeader().getColumnModel();
        ArrayList<Column> arrayList = new ArrayList<Column>();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            Column column = new Column();
            column.setSourceColumnName(tableColumnModel.getColumn(i).getHeaderValue().toString());
            column.setName(column.getSourceColumnName());
            column.setSourceColID(this.getSourceID(column.getSourceColumnName()));
            arrayList.add(i, column);
        }
        traversableContext.put("DATA_COLUMNS", (Object)arrayList.toArray(new Column[arrayList.size()]));
        if (this.resetData) {
            traversableContext.remove("SELECTABLE_COLUMNS");
            traversableContext.remove("SELECTED_COLUMNS");
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        this.filename = (String)traversableContext.get("FILENAME");
        this.header = traversableContext.get("HEADER") == null ? false : (Boolean)traversableContext.get("HEADER");
        this.setHeader(this.header);
        if (this.filename != null) {
            this.type = this.filename.substring(this.filename.lastIndexOf(".", this.filename.length()) + 1);
            DataReadable dataReadable = DataReaderRegistry.getReader(this.type);
            dataReadable.setFileName(this.filename);
            if (traversableContext.get("PAGEID") != null) {
                dataReadable.setPage((Integer)traversableContext.get("PAGEID"));
            }
            this.setDataReader(dataReadable);
        }
        if (traversableContext.get("HEADER") != null) {
            this.setHeader((Boolean)traversableContext.get("HEADER"));
        }
        this.resetData = false;
    }

    private String getFileName() {
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        int n = uRLChooser.showOpenDialog((Component)((Object)this));
        if (n == 0) {
            URL uRL = uRLChooser.getSelectedURL();
            String string = uRL.getPath();
            return string;
        }
        return "";
    }

    private int getSourceID(String string) {
        int n = -1;
        String[] stringArray = null;
        if (this.isHeaderSelected()) {
            this.getDataReader().setHeader(true);
            stringArray = this.getDataReader().getColumnNames();
        } else {
            this.getDataReader().setHeader(false);
            stringArray = this.getDataReader().getColumnNames();
        }
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    static /* synthetic */ String[] access$302(DataPreviewPanel dataPreviewPanel, String[] stringArray) {
        dataPreviewPanel.columns = stringArray;
        return stringArray;
    }

    class FilePanel
    extends JPanel
    implements ActionListener {
        private JButton _browse;
        private JTextField _file;

        public FilePanel() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("File:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 5, 0, 5), 0, 0));
            this._file = new JTextField();
            this.add((Component)this._file, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 1, 0, 5), 0, 0));
            this._browse = new JButton("Browse");
            this._browse.addActionListener(this);
            this.add((Component)this._browse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 1, 0, 0), 0, 0));
            this._file.requestFocus();
        }

        public String getFileName() {
            return this._file.getText();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.setSelectionScope(2);
            uRLChooser.setSelectionMode(0);
            int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow());
            if (n == 0) {
                this._file.setText(uRLChooser.getSelectedURL().getFile());
            }
        }
    }
}

