/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.data.DataImportArb;
import oracle.dbtools.raptor.data.core.ImportPreRequisiteChecker;
import oracle.dbtools.raptor.data.ui.PreReqResultsPanel;
import oracle.dbtools.raptor.data.writers.ImportGenerator;
import oracle.dbtools.raptor.data.writers.ImportWriteStream;
import oracle.ide.Ide;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.editor.BasicEditorPane;

public class DataSummaryPage
extends DefaultTraversablePanel {
    private JLabel verfiyImportParametersLabel;
    private JButton verifyButton;
    private PreReqResultsPanel panel;
    private static final long serialVersionUID = -4806824652842858395L;
    private static final String HTMLCONTENT = "text/html";
    private JCheckBox sendToWorksheetCombo;
    private TraversableContext m_ctx;
    private URL url;

    public void onEntry(TraversableContext traversableContext) {
        this.m_ctx = traversableContext;
        if (traversableContext.get("SEND_TO_WORKSHEET") != null) {
            this.sendToWorksheetCombo.setSelected((Boolean)traversableContext.get("SEND_TO_WORKSHEET"));
        } else {
            this.sendToWorksheetCombo.setSelected(Boolean.FALSE);
        }
        if (traversableContext.get("VALIDATED") != null) {
            if (((Boolean)traversableContext.get("VALIDATED")).booleanValue()) {
                traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
            } else {
                traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
            }
        } else {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (this.sendToWorksheetCombo.isSelected()) {
            traversableContext.put("SEND_TO_WORKSHEET", (Object)Boolean.TRUE);
        } else {
            traversableContext.put("SEND_TO_WORKSHEET", (Object)Boolean.FALSE);
        }
        if (traversableContext.getDirection() == 1) {
            try {
                ImportWriteStream importWriteStream = this.createPrintStream();
                ImportGenerator importGenerator = new ImportGenerator(importWriteStream, traversableContext);
                if (((Boolean)traversableContext.get("SEND_TO_WORKSHEET")).booleanValue()) {
                    importGenerator.setUrl(this.url);
                }
                importGenerator.generate();
            }
            catch (Exception exception) {
                Logger.getLogger(ConnectionDialog.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public DataSummaryPage() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.add(this.getVerfiyImportParametersLabel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getVerifyButton(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.getPanel().getPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.createSendtoWorksheet(), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private Component createCodePanel() {
        BasicEditorPane basicEditorPane = new BasicEditorPane();
        basicEditorPane.setText(this.getSummary());
        return basicEditorPane;
    }

    private String getSummary() {
        return null;
    }

    private JCheckBox createSendtoWorksheet() {
        this.sendToWorksheetCombo = new JCheckBox();
        this.sendToWorksheetCombo.setText(DataImportArb.getString(41));
        return this.sendToWorksheetCombo;
    }

    private JTextPane createInstructions() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType(HTMLCONTENT);
        jTextPane.setText(DataImportArb.getString(40));
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        return jTextPane;
    }

    public static void main(String[] stringArray) {
        JDialog jDialog = new JDialog();
        DataSummaryPage dataSummaryPage = new DataSummaryPage();
        jDialog.add((Component)((Object)dataSummaryPage));
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        jDialog.setVisible(Boolean.TRUE);
    }

    protected PreReqResultsPanel getPanel() {
        if (this.panel == null) {
            this.panel = new PreReqResultsPanel();
        }
        return this.panel;
    }

    protected JButton getVerifyButton() {
        if (this.verifyButton == null) {
            this.verifyButton = new JButton();
            this.verifyButton.setText(DataImportArb.getString(49));
            this.verifyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataSummaryPage.this.performTest();
                }
            });
        }
        return this.verifyButton;
    }

    protected JLabel getVerfiyImportParametersLabel() {
        if (this.verfiyImportParametersLabel == null) {
            this.verfiyImportParametersLabel = new JLabel();
            this.verfiyImportParametersLabel.setText(DataImportArb.getString(50));
        }
        return this.verfiyImportParametersLabel;
    }

    private ImportWriteStream createPrintStream() throws IOException, UnsupportedEncodingException {
        File file = File.createTempFile("import-", "sql");
        file.deleteOnExit();
        this.url = file.toURL();
        ImportWriteStream importWriteStream = null;
        String string = Ide.getEnvironOptions().getEncoding();
        importWriteStream = string == null ? new ImportWriteStream(new PrintStream(file)) : new ImportWriteStream(new PrintStream(file, string));
        importWriteStream.seturl(this.url);
        return importWriteStream;
    }

    private void performTest() {
        ImportPreRequisiteChecker importPreRequisiteChecker = new ImportPreRequisiteChecker(this.m_ctx);
        importPreRequisiteChecker.addListener(this.panel);
        int n = importPreRequisiteChecker.runTests();
        switch (n) {
            case 0: {
                this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
                break;
            }
            case 1: {
                this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                break;
            }
            case 2: {
                this.m_ctx.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true));
                break;
            }
        }
    }
}

