/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.data.ui.AbstractUpdatableTableModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class SimpleTablePanel
extends JPanel {
    private JTable m_table;

    public SimpleTablePanel(int n, String string, AbstractUpdatableTableModel abstractUpdatableTableModel) {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(n, 125));
        JScrollPane jScrollPane = new JScrollPane();
        this.add((Component)jScrollPane, "Center");
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.m_table = new JTable();
        TableCellRenderer tableCellRenderer = this.m_table.getTableHeader().getDefaultRenderer();
        if (tableCellRenderer instanceof JLabel) {
            ((JLabel)((Object)tableCellRenderer)).setHorizontalAlignment(10);
        }
        this.setToolTipText(string);
        jScrollPane.setViewportView(this.m_table);
        this.m_table.setModel(abstractUpdatableTableModel);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    SimpleTablePanel.this.popupCurrentCell(mouseEvent.getPoint());
                }
            }
        };
        this.m_table.addMouseListener(mouseAdapter);
    }

    public void updateProgress(Object object) {
        if (object != null) {
            AbstractUpdatableTableModel abstractUpdatableTableModel = (AbstractUpdatableTableModel)this.m_table.getModel();
            abstractUpdatableTableModel.update(object);
            this.m_table.scrollRectToVisible(this.m_table.getCellRect(abstractUpdatableTableModel.getRowCount() - 1, 0, true));
        }
    }

    private void popupCurrentCell(Point point) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(200, 200));
        JTextArea jTextArea = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jPanel.add((Component)jScrollPane, "Center");
        int n = this.m_table.rowAtPoint(point);
        int n2 = this.m_table.columnAtPoint(point);
        Object object = this.m_table.getValueAt(n, n2);
        jTextArea.setText(object == null ? "" : object.toString());
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)"Cell Value", (int)2);
        jEWTDialog.setMinimumSize(new Dimension(200, 200));
        jEWTDialog.setPreferredSize(new Dimension(200, 200));
        jEWTDialog.setSize(200, 200);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }
}

