/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.util.HashMap;
import oracle.dbtools.raptor.data.writers.CharFormattor;
import oracle.dbtools.raptor.data.writers.DateFormattor;
import oracle.dbtools.raptor.data.writers.ITypeFormattor;
import oracle.dbtools.raptor.data.writers.NumberFormattor;
import oracle.dbtools.raptor.utils.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeFormatterRegistry {
    private HashMap<String, Class<? extends ITypeFormattor>> _fmtMap = new HashMap();
    private static DataTypeFormatterRegistry INSTANCE;

    public synchronized void registerFormattor(String string, Class<? extends ITypeFormattor> clazz) {
        if (this._fmtMap == null) {
            this._fmtMap = new HashMap();
        }
        this._fmtMap.put(string, clazz);
    }

    public synchronized void unregisterFormattor(String string) {
        if (this._fmtMap != null) {
            this._fmtMap.remove(string);
        }
    }

    public ITypeFormattor getFormattor(String string) {
        if (this._fmtMap != null && string != null) {
            try {
                return this._fmtMap.get(string).newInstance();
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Exception)exception);
            }
        }
        return null;
    }

    private DataTypeFormatterRegistry() {
        this.registerFormattor("NUMBER", NumberFormattor.class);
        this.registerFormattor("INTEGER", NumberFormattor.class);
        this.registerFormattor("LONG", NumberFormattor.class);
        this.registerFormattor("FLOAT", NumberFormattor.class);
        this.registerFormattor("CHAR", CharFormattor.class);
        this.registerFormattor("NCHAR", CharFormattor.class);
        this.registerFormattor("VARCHAR2", CharFormattor.class);
        this.registerFormattor("NVARCHAR2", CharFormattor.class);
        this.registerFormattor("DATE", DateFormattor.class);
        this.registerFormattor("TIME", DateFormattor.class);
        this.registerFormattor("TIMESTAMP", DateFormattor.class);
    }

    public static DataTypeFormatterRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataTypeFormatterRegistry();
        }
        return INSTANCE;
    }
}

