/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.data.writers;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.data.core.Column;
import oracle.dbtools.raptor.data.writers.ITypeFormattor;

public class NumberFormattor
implements ITypeFormattor {
    private Locale _l;

    public String formatColumn(Column column) {
        String string = null;
        string = DBUtil.enquote((String)column.getName()) + " " + column.getType();
        if (column.getName() != null && column.getPrecision() > 0) {
            string = column.getScale() > 0 ? string + "(" + column.getPrecision() + ", " + column.getScale() + ")" : string + "(" + column.getPrecision() + ")";
        }
        if (column.getDefault() != null && column.getDefault().trim().length() > 0) {
            string = string + " DEFAULT " + column.getDefault();
        }
        if (!column.isNullable()) {
            string = string + " NOT NULL";
        }
        return string;
    }

    public String formatData(Object object, Column column) {
        String string = "NULL";
        NumberFormat numberFormat = null;
        numberFormat = this._l != null ? NumberFormat.getInstance(this._l) : NumberFormat.getInstance();
        if (object != null) {
            try {
                string = column.getPrecision() > 0 && column.getScale() > 0 || column.getPrecision() == 0 && column.getScale() == 0 ? "" + numberFormat.parse(object.toString()).doubleValue() : "" + numberFormat.parse(object.toString()).longValue();
            }
            catch (ParseException parseException) {
                string = object.toString();
            }
        }
        if (string.length() == 0) {
            return "NULL";
        }
        return string;
    }

    public void setLocale(Locale locale) {
        this._l = locale;
    }

    public Locale getLocale() {
        return this._l;
    }
}

