/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.RaptorDBAddin;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.UIUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.Element;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLContextMenuListener
implements ContextMenuListener,
Controller {
    private JMenu _menu;
    public static final String DDL_AS_FILE_CMD = "DatabaseNavigator.DDL_AS_FILE_CMD";
    public static final int DDL_AS_FILE_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_AS_FILE_CMD");
    public static final String DDL_TO_WRKSHEET_CMD = "DatabaseNavigator.DDL_TO_WRKSHEET_CMD";
    public static final int DDL_TO_WRKSHEET_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_WRKSHEET_CMD");
    public static final String DDL_TO_CLIPBOARD_CMD = "DatabaseNavigator.DDL_TO_CLIPBOARD_CMD";
    public static final int DDL_TO_CLIPBOARD_CMD_ID = Ide.findOrCreateCmdID((String)"DatabaseNavigator.DDL_TO_CLIPBOARD_CMD");
    public static final String DDL_TO_HTML_FILE_CMD = "DatabaseNavigator.EXPORT_DDL_TO_HTML_FILE";
    public static final IdeAction DDL_TO_FILE = IdeAction.get((int)DDL_AS_FILE_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(14)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(14))));
    public static final IdeAction DDL_TO_WRKSHEET = IdeAction.get((int)DDL_TO_WRKSHEET_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(15)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(15))));
    public static final IdeAction DDL_TO_CLIPBOARD = IdeAction.get((int)DDL_TO_CLIPBOARD_CMD_ID, (String)StringUtils.stripMnemonic((String)DatabaseNavigatorResources.getString(16)), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)DatabaseNavigatorResources.getString(16))));

    private void init() {
        if (this._menu == null) {
            this._menu = new JMenu(DatabaseNavigatorResources.getString(13));
            this._menu.add((Action)DDL_TO_FILE);
            this._menu.add((Action)DDL_TO_WRKSHEET);
            this._menu.add((Action)DDL_TO_CLIPBOARD);
            DDL_TO_FILE.addController((Controller)this);
            DDL_TO_WRKSHEET.addController((Controller)this);
            DDL_TO_CLIPBOARD.addController((Controller)this);
        }
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.init();
        DBObject dBObject = null;
        boolean bl = true;
        Element[] elementArray = contextMenu.getContext().getSelection();
        if (elementArray.length == 0) {
            bl = false;
        }
        for (Element element : elementArray) {
            dBObject = new DBObject(element);
            if (DDLRegistry.isSupported(dBObject.getKey())) continue;
            bl = false;
        }
        if (bl) {
            contextMenu.add((Component)this._menu);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == DDL_AS_FILE_CMD_ID) {
            this.saveToFile(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_WRKSHEET_CMD_ID) {
            this.saveToWorkSheet(context);
            return true;
        }
        if (ideAction.getCommandId() == DDL_TO_CLIPBOARD_CMD_ID) {
            this.saveToClip(context);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    private List<DBObject> getList(Context context) {
        Element[] elementArray;
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        for (Element element : elementArray = context.getSelection()) {
            arrayList.add(new DBObject(element));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveToWorkSheet(Context context) {
        Ide.getWaitCursor().show();
        try {
            try {
                DBObject dBObject = new DBObject(context.getSelection()[0]);
                RaptorDBAddin.getSqlOpener().openNewEditor(DDLGenerator.getInstance().getDDL(this.getList(context)), dBObject.getConnectionName());
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                Object var4_5 = null;
                Ide.getWaitCursor().hide();
                return;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Ide.getWaitCursor().hide();
            throw throwable;
        }
        Ide.getWaitCursor().hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveToClip(Context context) {
        Ide.getWaitCursor().show();
        try {
            try {
                UIUtils.setClipboard(DDLGenerator.getInstance().getDDL(this.getList(context)));
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                Object var4_3 = null;
                Ide.getWaitCursor().hide();
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Ide.getWaitCursor().hide();
            throw throwable;
        }
        Ide.getWaitCursor().hide();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveToFile(Context context) {
        File file;
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        String string = DBConfig.getInstance().getString("EXPORTDIR");
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            try {
                uRLChooser.setSelectedURL(file.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getStackTrace()[0].toString(), malformedURLException);
            }
        }
        uRLChooser.setSelectionScope(2);
        uRLChooser.setSelectionMode(0);
        file = new DefaultURLFilter("SQL Script", "sql");
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.setURLFilter((URLFilter)file);
        int n = uRLChooser.showSaveDialog((Component)Ide.getMainWindow());
        if (n != 0) return;
        URL uRL = uRLChooser.getSelectedURL();
        DBObject dBObject = new DBObject(context.getSelection()[0]);
        if (dBObject == null) return;
        if (uRL.getFile().indexOf(".sql") == -1) {
            DDLGenerator.getInstance().setFile(uRL.getFile() + ".sql", null);
        } else {
            DDLGenerator.getInstance().setFile(uRL.getFile(), null);
        }
        Ide.getWaitCursor().show();
        try {
            try {
                DDLGenerator.getInstance().openFile();
                DDLGenerator.getInstance().getWriter().write(DDLGenerator.getInstance().getDDL(this.getList(context)));
                DDLGenerator.getInstance().closeFile();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                Object var10_10 = null;
                Ide.getWaitCursor().hide();
                return;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                Object var10_11 = null;
                Ide.getWaitCursor().hide();
                return;
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            Ide.getWaitCursor().hide();
            throw throwable;
        }
        Ide.getWaitCursor().hide();
    }
}

