/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLMetaObject;
import oracle.dbtools.raptor.ddl.DDLRegistry;
import oracle.dbtools.raptor.ddl.IObjectDDL;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.util.IdeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLGenerator {
    public static Logger logger = Logger.getLogger(DDLGenerator.class.toString());
    private static final Object LOCK = new Object();
    private static DDLGenerator _generator;
    DDLFormat _format;
    OutputStreamWriter _out = null;
    String _file = null;
    String _enc = null;
    ArrayList<DDLMetaObject> _objects = new ArrayList();

    private DDLGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DDLGenerator getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_generator == null) {
                _generator = new DDLGenerator();
            }
        }
        return _generator;
    }

    public void setFormating(DDLFormat dDLFormat) {
        this._format = dDLFormat;
    }

    public DDLFormat getFormating() {
        return this._format;
    }

    public void setFile(String string, String string2) {
        this._file = string;
        this._enc = string2 != null ? string2 : IdeUtil.getIdeEncoding();
    }

    public boolean openFile() throws Exception {
        if (this._file == null || this._enc == null) {
            logger.severe("Unable to open file to write export.");
            return false;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(this._file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this._out = new OutputStreamWriter((OutputStream)bufferedOutputStream, this._enc);
        return true;
    }

    public void closeFile() throws IOException {
        this._out.flush();
        this._out.close();
    }

    private void checkFormat() {
        if (this._format == null) {
            this._format = new DDLFormat();
        }
    }

    public void setWriter(OutputStreamWriter outputStreamWriter) {
        this._out = outputStreamWriter;
    }

    public OutputStreamWriter getWriter() {
        return this._out;
    }

    public ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2, String string3) {
        try {
            return DDLRegistry.getInstanceFor(string3).getSchemaObjects(connection, string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getGrants(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL.getGrantsDDL(dBObject);
        }
        catch (Exception exception) {
            logger.severe("getGrantsDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getDDL(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL.getDDL(dBObject);
        }
        catch (Exception exception) {
            logger.severe("getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getDDL(List<DBObject> list) throws Exception {
        try {
            this.checkFormat();
            StringBuilder stringBuilder = new StringBuilder();
            for (DBObject dBObject : list) {
                IObjectDDL iObjectDDL = this.getRegistry(dBObject);
                stringBuilder.append(iObjectDDL.getDDL(dBObject));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            logger.severe("getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getDDL(DBObject dBObject, String string) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            return iObjectDDL.getDDL(dBObject, string);
        }
        catch (Exception exception) {
            logger.severe("getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    private IObjectDDL getRegistry(DBObject dBObject) {
        String string = this.getKey(dBObject);
        IObjectDDL iObjectDDL = DDLRegistry.getInstanceFor(string);
        return iObjectDDL;
    }

    private String getKey(DBObject dBObject) {
        String string = dBObject.getKey().replace(" ", "_");
        if ("Oracle#PUBLIC_SYNONYM".equals(string)) {
            string = "Oracle#SYNONYM";
        } else if ("Oracle#PUBLIC_DATABASE_LINK".equals(string)) {
            string = "Oracle#DATABASE_LINK";
        }
        return string;
    }

    public String getScriptDDL(DBObject dBObject, String string) throws Exception {
        try {
            this.checkFormat();
            IObjectDDL iObjectDDL = this.getRegistry(dBObject);
            if (string != null) {
                iObjectDDL.setFilter(string);
            }
            String string2 = iObjectDDL.getScriptDDL(dBObject);
            return string2;
        }
        catch (Exception exception) {
            logger.severe("getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getCopyDDL(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            return this.getRegistry(dBObject).getCopyDDL(dBObject);
        }
        catch (Exception exception) {
            logger.severe("getDDL - " + exception.getMessage());
            throw exception;
        }
    }

    public String getScriptDDL(DBObject dBObject) throws Exception {
        try {
            this.checkFormat();
            return this.getRegistry(dBObject).getScriptDDL(dBObject);
        }
        catch (Exception exception) {
            logger.severe("getDDL - " + exception.getMessage());
            throw exception;
        }
    }
}

