/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.ddl.oracle;

import java.io.OutputStreamWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.IObjectDDL;
import oracle.dbtools.raptor.ddl.oracle.OracleMetaSetup;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OracleObjectDDL
implements IObjectDDL {
    private static String LIST_OBJECTS;
    private static String GRANT_SQL;
    OutputStreamWriter _out = DDLGenerator.getInstance().getWriter();
    DDLFormat _format = DDLGenerator.getInstance().getFormating();
    private String _filter;
    protected String _EOL;

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    private void getQueries(Connection connection) {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/ddl/oracle/ObjectSql.xml");
        Query query = queryXMLSupport.getQuery("list_objects", connection);
        LIST_OBJECTS = query.getSql();
        query = queryXMLSupport.getQuery("grant_sql", connection);
        GRANT_SQL = query.getSql();
    }

    public abstract String doGetDDL(DBObject var1);

    @Override
    public String getDDL(DBObject dBObject, String string) {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), string);
        return this.doGetDDL(dBObject);
    }

    @Override
    public String getDDL(DBObject dBObject) {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), "DDL");
        return this.doGetDDL(dBObject);
    }

    public abstract String doGetDDLScript(DBObject var1);

    @Override
    public String getCopyDDL(DBObject dBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), "COPY");
        return this.doGetDDLScript(dBObject);
    }

    @Override
    public String getScriptDDL(DBObject dBObject) throws Exception {
        this.getTerm();
        new OracleMetaSetup(dBObject.getConnection(), "SCRIPT");
        return this.doGetDDLScript(dBObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String getGrantsDDL(DBObject dBObject) {
        StringBuilder stringBuilder;
        block15: {
            ResultSet resultSet;
            block14: {
                this.getTerm();
                stringBuilder = new StringBuilder();
                this.getQueries(dBObject.getConnection());
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("OWNER", dBObject.getSchemaName());
                hashMap.put("NAME", dBObject.getObjectName());
                DBUtil dBUtil = DBUtil.getInstance();
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(dBObject.getConnection(), GRANT_SQL, hashMap);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        stringBuilder.append(resultSet.getString(1) + this._EOL);
                    }
                    break block14;
                }
                stringBuilder.append("");
            }
            Object var8_6 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block15;
                }
                catch (Exception exception2) {}
            }
            break block15;
            {
                catch (Exception exception) {
                    stringBuilder.append("");
                    Object var8_7 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        try {
                            resultSet.close();
                            break block15;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public ArrayList<DBObject> getSchemaObjects(Connection connection, String string, String string2) {
        ArrayList<DBObject> arrayList;
        block13: {
            this.getQueries(connection);
            arrayList = new ArrayList<DBObject>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSet resultSet = null;
            hashMap.put("OWNER", string);
            hashMap.put("TYPE", string2);
            resultSet = DBUtil.getInstance().executeQuery(connection, LIST_OBJECTS, hashMap);
            String string3 = Connections.getInstance().getConnectionName(connection);
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, string, string2);
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                arrayList.add(new DBObject(uRL));
            }
            Object var11_11 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block13;
                }
                catch (Exception exception2) {}
            }
            break block13;
            {
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    Object var11_12 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        try {
                            resultSet.close();
                            break block13;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    @Override
    public void setFilter(String string) {
        this._filter = string;
    }

    public String getFilter() {
        return this._filter;
    }
}

