/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.actions;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.format.ui.ExportContextMenuListener;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.utils.AbstractFolderedXml;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.FileUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.resource.IdeArb;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLBasedObjectAction {
    private static Logger logger = Logger.getLogger(XMLBasedObjectAction.class.getName());
    private static XMLBasedObjectAction _instance;
    private static Object LOCK;
    private static Object REGISTEREDPACKAGESLOCK;
    private static ArrayList<URL> _registeredContextMenus;
    private static ArrayList<String> _registeredPackages;
    private static final Float CTX_MENU_WEIGHT;
    private DefaultController _controller = null;
    private Map _menus = new HashMap();
    private List<ObjectAction> _actions;
    private Map _menus_to_actions = new HashMap();
    private IdeAction defaultAction = IdeAction.get((int)DEFAULT_CMD_ID, null, (String)Translate.translate((String)"Actions"), null, null, (Icon)IdeArb.getIcon((int)58), null, (boolean)true);
    static final int DEFAULT_CMD_ID;

    public static synchronized void registerContextMenus(URL uRL) {
        _registeredContextMenus.add(uRL);
    }

    public static synchronized void registerContextMenus(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                logger.severe(malformedURLException2.getLocalizedMessage());
            }
        }
        if (uRL != null) {
            _registeredContextMenus.add(uRL);
        } else {
            logger.severe("Could not add Actions:" + string);
        }
    }

    public static synchronized ArrayList<URL> getRegisterContextMenus() {
        return _registeredContextMenus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void registerPackage(String string) {
        Object object = REGISTEREDPACKAGESLOCK;
        synchronized (object) {
            if (!_registeredPackages.contains(string)) {
                _registeredPackages.add(string);
            }
        }
    }

    public static synchronized ArrayList<String> getRegisteredPackages() {
        return _registeredPackages;
    }

    private XMLBasedObjectAction() {
        this._controller = new DefaultController();
        this.defaultAction.addController((Controller)this._controller);
        XMLBasedObjectAction.registerPackage("oracle.dbtools.raptor.dialogs.actions.xml");
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
                Thread thread = new Thread(){

                    public void run() {
                        if (DBConfig.getInstance() != null && DBConfig.getInstance().getExtensions("ACTION") != null) {
                            ArrayList<String> arrayList = DBConfig.getInstance().getExtensions("ACTION");
                            if (arrayList != null) {
                                for (int i = 0; i < arrayList.size(); ++i) {
                                    XMLBasedObjectAction.registerContextMenus(arrayList.get(i));
                                }
                            }
                            XMLBasedObjectAction.this.loadXML();
                        }
                    }
                };
                thread.setName("XML Action Loader");
                thread.start();
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }

            public void mainWindowOpened(IdeEvent ideEvent) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLBasedObjectAction getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new XMLBasedObjectAction();
            }
        }
        return _instance;
    }

    public ObjectAction findCurrentAction(IdeAction ideAction) {
        ObjectAction objectAction = null;
        for (int i = 0; objectAction == null && i < this._actions.size(); ++i) {
            if (this._actions.get(i).getId() != ideAction.getCommandId()) continue;
            objectAction = this._actions.get(i);
        }
        return objectAction;
    }

    public IdeAction getIdeAction() {
        return this.defaultAction;
    }

    public void setController(Controller controller) {
        this._controller.setController(controller);
    }

    public JPopupMenu getMenu(DBObject dBObject) {
        int n;
        if (this._menus == null || Resource.DEV_MODE) {
            this.loadXML();
        }
        List list = (List)this._menus.get(dBObject.getKey());
        List list2 = (List)this._menus.get(dBObject.getKey() + "_MENUS");
        this.checkActionVersions(dBObject, false);
        JPopupMenu jPopupMenu = new JPopupMenu(Translate.translate((String)"Actions"));
        for (n = 0; list2 != null && n < list2.size(); ++n) {
            JMenu jMenu = (JMenu)list2.get(n);
            jPopupMenu.add(jMenu);
            JPopupMenu jPopupMenu2 = jMenu.getPopupMenu();
            int n2 = jPopupMenu2.getComponentCount();
            for (int i = 0; i < n2; ++i) {
                Component component = jPopupMenu2.getComponent(i);
                if (!(component instanceof JMenuItem)) continue;
                ((JMenuItem)component).putClientProperty("ObjectAction.DBOBJECT", dBObject);
            }
        }
        for (n = 0; list != null && n < list.size(); ++n) {
            jPopupMenu.add(((ObjectAction)list.get(n)).getMenuItem());
        }
        return jPopupMenu;
    }

    public void checkActionVersions(DBObject dBObject, boolean bl) {
        String string = dBObject.getConnectionType();
        String string2 = null;
        string2 = bl ? "MULTI_" + dBObject.getKey() : dBObject.getKey();
        ArrayList arrayList = (ArrayList)this._menus.get(string2);
        ArrayList arrayList2 = (ArrayList)this._menus.get(string2 + "_MENUS");
        if (arrayList != null) {
            for (Object object : arrayList) {
                if (((ObjectAction)object).isValidForVersion(dBObject)) {
                    ((ObjectAction)object).getAction().setEnabled(true);
                    ((ObjectAction)object).getMenuItem().setEnabled(true);
                    continue;
                }
                ((ObjectAction)object).getAction().setEnabled(false);
                ((ObjectAction)object).getMenuItem().setEnabled(false);
            }
        }
        for (int i = 0; arrayList2 != null && i < arrayList2.size(); ++i) {
            Object object;
            object = (JMenu)arrayList2.get(i);
            this.setEnabled(((JMenu)object).getPopupMenu(), dBObject);
            for (int j = 0; j < ((JMenu)object).getPopupMenu().getComponentCount(); ++j) {
                Component component = ((JMenu)object).getPopupMenu().getComponent(j);
                if (!(component instanceof JMenuItem)) continue;
                IdeAction ideAction = (IdeAction)((JMenuItem)component).getAction();
                ObjectAction objectAction = (ObjectAction)ideAction.getValue("ObjectAction.KEY");
                if (objectAction.isValidForVersion(dBObject)) {
                    objectAction.getAction().setEnabled(true);
                    objectAction.getMenuItem().setEnabled(true);
                    continue;
                }
                objectAction.getAction().setEnabled(false);
                objectAction.getMenuItem().setEnabled(false);
            }
        }
    }

    private ArrayList<ObjectAction> getActions(String string, boolean bl) {
        ArrayList arrayList = (ArrayList)this._menus.get(string);
        ArrayList<ObjectAction> arrayList2 = new ArrayList<ObjectAction>();
        if (arrayList != null) {
            for (ObjectAction objectAction : arrayList) {
                if (bl && objectAction.getSelectionMode() == ObjectAction.MULTI_SELECT) {
                    arrayList2.add(objectAction);
                    continue;
                }
                if (!bl && objectAction.getSelectionMode() == ObjectAction.SINGLE_SELECT) {
                    arrayList2.add(objectAction);
                    continue;
                }
                if (objectAction.getSelectionMode() != ObjectAction.BOTH_SELECT) continue;
                arrayList2.add(objectAction);
            }
        }
        return arrayList2;
    }

    private ArrayList getMenus(String string, boolean bl) {
        ArrayList arrayList = (ArrayList)this._menus.get(string + "_MENUS");
        ArrayList<JMenu> arrayList2 = new ArrayList<JMenu>();
        if (arrayList != null) {
            for (JMenu jMenu : arrayList) {
                boolean bl2 = false;
                for (Component component : jMenu.getPopupMenu().getComponents()) {
                    int n;
                    ObjectAction objectAction = (ObjectAction)this._menus_to_actions.get(component);
                    int n2 = n = bl ? ObjectAction.MULTI_SELECT : ObjectAction.SINGLE_SELECT;
                    if (objectAction.isSelectable(n)) {
                        component.setVisible(true);
                        bl2 = true;
                        continue;
                    }
                    component.setVisible(false);
                }
                if (!bl2) continue;
                arrayList2.add(jMenu);
            }
        }
        return arrayList2;
    }

    public void addToMenu(ContextMenu contextMenu, DBObject dBObject, boolean bl) {
        JMenuItem jMenuItem;
        int n;
        if (this._menus == null || Resource.DEV_MODE) {
            this.loadXML();
        }
        this.checkActionVersions(dBObject, bl);
        ArrayList<ObjectAction> arrayList = this.getActions(dBObject.getKey(), bl);
        ArrayList arrayList2 = this.getMenus(dBObject.getKey(), bl);
        for (n = 0; arrayList2 != null && n < arrayList2.size(); ++n) {
            jMenuItem = (JMenu)arrayList2.get(n);
            contextMenu.add((Component)jMenuItem, CTX_MENU_WEIGHT.floatValue());
        }
        for (n = 0; arrayList != null && n < arrayList.size(); ++n) {
            jMenuItem = arrayList.get(n).getMenuItem(contextMenu);
            Float f = (Float)jMenuItem.getClientProperty("menu-section-id");
            if (f == null) {
                f = CTX_MENU_WEIGHT;
            }
            contextMenu.add((Component)jMenuItem, f.floatValue());
        }
    }

    public void setEnabled(JPopupMenu jPopupMenu, DBObject dBObject) {
        Component[] componentArray = jPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            ObjectAction objectAction = (ObjectAction)this._menus_to_actions.get(component);
            if (objectAction == null) continue;
            if (objectAction.isValidForVersion(dBObject)) {
                component.setEnabled(true);
                continue;
            }
            component.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackages(AbstractFolderedXml abstractFolderedXml) {
        Object object = REGISTEREDPACKAGESLOCK;
        synchronized (object) {
            for (String string : XMLBasedObjectAction.getRegisteredPackages()) {
                try {
                    for (URL uRL : FileUtils.getFilesInPackage(string, "xml")) {
                        try {
                            abstractFolderedXml.processXML(uRL.openStream());
                        }
                        catch (Exception exception) {
                            logger.log(Level.SEVERE, "Could not process user actions", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Could not process user actions", exception);
                }
            }
        }
    }

    public void loadXML() {
        XMLParser xMLParser = new XMLParser();
        this._actions = new ArrayList<ObjectAction>();
        if (System.getProperty("raptor.user.contextmenu") != null) {
            String[] stringArray = System.getProperty("raptor.user.contextmenu").split("[:;]");
            Object object = null;
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File((String)stringArray[i]);
                if (!file.exists()) continue;
                try {
                    xMLParser.processXML(new FileInputStream(file));
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Could not process user actions", exception);
                    logger.log(Level.SEVERE, "Could not process user actions", exception);
                }
            }
        }
        this.addPackages(xMLParser);
        for (URL uRL : XMLBasedObjectAction.getRegisterContextMenus()) {
            try {
                xMLParser.processXML(uRL.openStream());
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Could not process user actions", exception);
            }
        }
        for (String string : this._menus.keySet()) {
            if (string.indexOf("_MENUS") <= 0) continue;
            ArrayList arrayList = (ArrayList)this._menus.get(string);
            for (JMenu jMenu : arrayList) {
                ArrayList<Character> arrayList2 = new ArrayList<Character>();
                block8: for (Component component : jMenu.getPopupMenu().getComponents()) {
                    if (!(component instanceof JMenuItem)) continue;
                    String string2 = ((JMenuItem)component).getText();
                    for (int i = 0; i < string2.length(); ++i) {
                        if (arrayList2.contains(Character.valueOf(string2.charAt(i)))) continue;
                        ((JMenuItem)component).setMnemonic(string2.charAt(i));
                        arrayList2.add(Character.valueOf(string2.charAt(i)));
                        continue block8;
                    }
                }
            }
        }
    }

    public void addAction(ObjectAction objectAction) {
        String string = objectAction.getConnType() + "#" + objectAction.getType();
        if (this._menus.get(string) == null) {
            this._menus.put(string, new ArrayList());
        }
        ((ArrayList)this._menus.get(objectAction.getConnType() + "#" + objectAction.getType())).add(objectAction);
    }

    public void addAction(JMenu jMenu, String string, String string2) throws Exception {
        if (this._menus.get(string + "#" + string2 + "_MENUS") != null) {
            throw new Exception("Menu Exists");
        }
        this._menus.put(string + "#" + string2 + "_MENUS", jMenu);
    }

    public void addAction(String string, ObjectAction objectAction) throws Exception {
        ArrayList arrayList = (ArrayList)this._menus.get(objectAction.getConnType() + "#" + objectAction.getType() + "_MENUS");
        if (arrayList == null) {
            throw new Exception("Menu Does Not Exist");
        }
        for (JMenu jMenu : arrayList) {
            if (!jMenu.getName().equalsIgnoreCase(string)) continue;
            jMenu.add((Action)objectAction.getAction());
        }
    }

    private ObjectAction processNode(Node node) {
        ObjectAction objectAction = new ObjectAction(node);
        this._actions.add(objectAction);
        return objectAction;
    }

    static {
        LOCK = new Object();
        REGISTEREDPACKAGESLOCK = new Object();
        _registeredContextMenus = new ArrayList();
        _registeredPackages = new ArrayList();
        CTX_MENU_WEIGHT = Float.valueOf(12.0f);
        DEFAULT_CMD_ID = Ide.findOrCreateCmdID((String)"DEFAULT_XML_ACTION_ID");
    }

    private class DefaultController
    implements Controller {
        private Controller _controller;

        private DefaultController() {
        }

        public void setController(Controller controller) {
            this._controller = controller;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n == DEFAULT_CMD_ID && context.getNode() instanceof IViewerNode) {
                context.getView().getGUI().requestFocus();
                DBObject dBObject = new DBObject((Element)((IViewerNode)context.getNode()).getBaseNode());
                JPopupMenu jPopupMenu = XMLBasedObjectAction.this.getMenu(dBObject);
                XMLBasedObjectAction.this.checkActionVersions(dBObject, false);
                if (jPopupMenu.getComponentCount() > 0) {
                    Component component = null;
                    if (ideAction.getValue("BUTTON") != null) {
                        component = (Component)ideAction.getValue("BUTTON");
                    } else if (context.getEvent() != null && context.getEvent().getSource() != null) {
                        component = (Component)context.getEvent().getSource();
                    }
                    context.setProperty("ObjectAction.DBOBJECT", (Object)dBObject);
                    this.updateMenu(jPopupMenu, context);
                    ContextMenu contextMenu = new ContextMenu();
                    Context context2 = EditorManager.getEditorManager().getCurrentEditor().getContext();
                    contextMenu.addContextMenuListener((ContextMenuListener)ExportContextMenuListener.getInstance());
                    contextMenu.prepareShow(context2);
                    contextMenu.sortContainer((Container)jPopupMenu);
                    for (Component component2 : jPopupMenu.getComponents()) {
                        contextMenu.add(component2);
                    }
                    jPopupMenu = (JPopupMenu)contextMenu.getGUI(true);
                    jPopupMenu.show(component, 0, 0);
                }
            }
            if (this._controller != null) {
                return this._controller.handleEvent(ideAction, context);
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (this._controller != null) {
                return this._controller.update(ideAction, context);
            }
            return false;
        }

        private void updateMenu(JPopupMenu jPopupMenu, Context context) {
            int n = jPopupMenu.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = jPopupMenu.getComponent(i);
                if (component instanceof JMenu) {
                    this.updateMenu(((JMenu)component).getPopupMenu(), context);
                    continue;
                }
                if (!(component instanceof JMenuItem)) continue;
                IdeAction ideAction = (IdeAction)((JMenuItem)component).getAction();
                ideAction.updateAction(context);
            }
        }
    }

    private final class XMLParser
    extends AbstractFolderedXml {
        private Stack<JMenu> folders = new Stack();

        private XMLParser() {
        }

        public void openFolder(String string, String string2, String string3, Node node) {
            Object object;
            String string4 = XMLHelper.getAttributeNode((Node)node, (String)"type");
            String string5 = XMLHelper.getAttributeNode((Node)node, (String)"connType");
            float f = 1.0f;
            try {
                object = XMLHelper.getAttributeNode((Node)node, (String)"weight");
                if (object != null) {
                    f = Float.valueOf((String)object).floatValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.log(Level.SEVERE, "Menu Weight", numberFormatException);
            }
            if (string5 == null) {
                string5 = "Oracle";
            }
            if (this.folders.size() == 0) {
                object = new JMenu(string);
                ((JComponent)object).putClientProperty("menu-weight", Float.valueOf(f));
                this.folders.push((JMenu)object);
                if (XMLBasedObjectAction.this._menus.get(string5 + "#" + string4 + "_MENUS") == null) {
                    XMLBasedObjectAction.this._menus.put(string5 + "#" + string4 + "_MENUS", new ArrayList());
                }
                ((ArrayList)XMLBasedObjectAction.this._menus.get(string5 + "#" + string4 + "_MENUS")).add(object);
            } else {
                object = new JMenu(string);
                ((JComponent)object).putClientProperty("menu-weight", Float.valueOf(f));
                this.folders.peek().add((JMenuItem)object);
            }
        }

        public void newItem(Node node) {
            ObjectAction objectAction = XMLBasedObjectAction.this.processNode(node);
            if (this.folders.size() > 0) {
                JMenuItem jMenuItem = this.folders.peek().add((Action)objectAction.getAction());
                jMenuItem.putClientProperty("menu-weight", Float.valueOf(objectAction.getWeight()));
                XMLBasedObjectAction.this._menus_to_actions.put(jMenuItem, objectAction);
            } else {
                if (XMLBasedObjectAction.this._menus.get(objectAction.getConnType() + "#" + objectAction.getType()) == null) {
                    XMLBasedObjectAction.this._menus.put(objectAction.getConnType() + "#" + objectAction.getType(), new ArrayList());
                }
                boolean bl = true;
                for (Object e : (ArrayList)XMLBasedObjectAction.this._menus.get(objectAction.getConnType() + "#" + objectAction.getType())) {
                    if (!(e instanceof ObjectAction) || !((ObjectAction)e).getTitle().equals(objectAction.getTitle())) continue;
                    bl = false;
                }
                if (bl) {
                    ((ArrayList)XMLBasedObjectAction.this._menus.get(objectAction.getConnType() + "#" + objectAction.getType())).add(objectAction);
                }
            }
        }

        public void closeFolder() {
            this.folders.pop();
        }
    }
}

