/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.conn;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.dbtools.raptor.dialogs.conn.ConnectionInfoPanel;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.adapter.ConnectionCreator;
import oracle.jdevimpl.db.adapter.PasswordPrompter;

public class ConnectionPrompt
implements PasswordPrompter {
    private Map<String, String> m_cache = new HashMap<String, String>();

    public Connection promptForPassword(Properties properties, ConnectionCreator connectionCreator) throws SQLException {
        Connection connection = null;
        String string = this.m_cache.get(this.getKey(properties));
        boolean bl = Boolean.parseBoolean(properties.getProperty("NoPasswordConnection", "true"));
        if (string != null && ModelUtil.hasLength((String)string)) {
            properties.setProperty("password", string);
        } else if (bl) {
            ConnectionInfoPanel.promptForConnection(properties);
        }
        connection = connectionCreator.getConnection(properties);
        this.cache(properties);
        return connection;
    }

    public void cache(Properties properties) {
        String string = this.getKey(properties);
        String string2 = properties.getProperty("password");
        if (string != null && string2 != null) {
            this.m_cache.put(string, string2);
        }
    }

    public void uncache(Properties properties) {
        this.m_cache.remove(this.getKey(properties));
    }

    public void disconnect(Properties properties) {
        this.m_cache.remove(this.getKey(properties));
    }

    private String getKey(Properties properties) {
        String string = properties.getProperty("user");
        String string2 = properties.getProperty("customUrl");
        return string + "@" + string2;
    }
}

