/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.importdata;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.cellrenderers.DefaultCellRenderer;
import oracle.dbtools.raptor.dialogs.importdata.ExcelDialogArb;
import oracle.dbtools.raptor.dialogs.importdata.ExcelHelper;
import oracle.dbtools.raptor.dialogs.importdata.ExcelImportUtil;
import oracle.dbtools.raptor.dialogs.importdata.ExcelTabPanel;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelImportDialog {
    private DefaultTableModel _model = new DefaultTableModel();
    private TableSorter sorter = new TableSorter((TableModel)this._model);
    private JEWTDialog dlg;
    private HSSFWorkbook _workbook;
    private HSSFSheet currentSheet;
    private JTable _table;
    private DBObject _dbObject;
    private JButton _btnInsert;
    private JButton _btnCancel;
    private boolean _header = true;
    private ExcelTabPanel tabPanel;
    private JLabel m_newTableLabel = new JLabel();
    private JTextField m_newTableName = new JTextField();
    private boolean m_newTable = false;

    public void displayExcelDialog(HSSFWorkbook hSSFWorkbook, final DBObject dBObject) {
        Object object;
        this._workbook = hSSFWorkbook;
        this.setCurrentSheet(this._workbook.getSheetAt(0));
        this._dbObject = dBObject;
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(Translate.translate((String)"Worksheet"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        final JComboBox<String> jComboBox = new JComboBox<String>(ExcelHelper.getSheetNames(hSSFWorkbook));
        this.setCurrentSheet(this._workbook.getSheetAt(jComboBox.getSelectedIndex()));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 8.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 1;
        jPanel.add(jComboBox, gridBagConstraints2);
        final JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText(Translate.translate((String)"Header row?"));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 5, 0, 25);
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.gridx = 2;
        jPanel.add((Component)jCheckBox, gridBagConstraints3);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HSSFSheet hSSFSheet = ExcelImportDialog.this.getCurrentSheet();
                ExcelImportDialog.this.setCurrentSheet(ExcelImportDialog.this._workbook.getSheetAt(jComboBox.getSelectedIndex()));
                ExcelImportDialog.this.populateModel(ExcelImportDialog.this.getCurrentSheet(), ExcelImportDialog.this.is_header());
                if (!hSSFSheet.equals(ExcelImportDialog.this.getCurrentSheet())) {
                    ExcelImportDialog.this.tabPanel.populateShuttle(ExcelImportDialog.this._workbook, ExcelImportDialog.this.getCurrentSheet(), ExcelImportDialog.this._model);
                    ExcelImportDialog.this.tabPanel.setWorkSheet(ExcelImportDialog.this.getCurrentSheet());
                }
            }
        });
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ExcelImportDialog.this.set_header(jCheckBox.isSelected());
                ExcelImportDialog.this.populateModel(ExcelImportDialog.this.getCurrentSheet(), ExcelImportDialog.this.is_header());
                if (ExcelImportDialog.this.is_header()) {
                    ExcelImportDialog.this.tabPanel.populateShuttle(ExcelImportDialog.this._workbook, ExcelImportDialog.this.getCurrentSheet(), ExcelImportDialog.this._model);
                } else {
                    ExcelImportDialog.this.tabPanel.populateShuttle(ExcelImportDialog.this._model, ExcelImportDialog.this._table);
                }
                ExcelImportDialog.this.tabPanel.setWorkSheet(ExcelImportDialog.this.getCurrentSheet());
                ExcelImportDialog.this.tabPanel.refreshAndReset();
            }
        });
        this.populateModel(hSSFWorkbook.getSheetAt(0), jCheckBox.isSelected());
        this._model.fireTableDataChanged();
        this._table = new JTable((TableModel)this.sorter);
        this.sorter.setTableHeader(this._table.getTableHeader());
        this._table.setEnabled(false);
        this._table.setAutoResizeMode(0);
        this._table.setDefaultRenderer(TableColumn.class, new DefaultCellRenderer());
        this.sorter.getTableHeader().setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this._table, 21, 32);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.ipady = 80;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        jPanel2.add((Component)jScrollPane, gridBagConstraints4);
        jPanel2.setBorder(BorderFactory.createTitledBorder(ExcelDialogArb.getString(2)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        jPanel3.setLayout(new GridBagLayout());
        String string = "";
        string = this._dbObject == null || this._dbObject.getObjectType().equals("TABLE_FOLDER") ? ExcelDialogArb.getString(0) : ExcelDialogArb.getString(1) + " " + this._dbObject.getObjectName();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 0;
        jPanel3.add((Component)jPanel, gridBagConstraints6);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 3;
        if (this._dbObject == null || this._dbObject.getElement() instanceof ObjectFolder) {
            object = new JPanel(new GridBagLayout());
            this.m_newTableLabel.setText(ExcelDialogArb.getString(3));
            ((Container)object).add((Component)this.m_newTableLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            ((Container)object).add((Component)this.m_newTableName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            gridBagConstraints4.gridy = 2;
            jPanel3.add((Component)object, gridBagConstraints7);
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 2.0;
            this.m_newTable = true;
        }
        this.tabPanel = this._dbObject != null && this._dbObject.getObjectType().equals("TABLE") ? new ExcelTabPanel(this._dbObject) : new ExcelTabPanel();
        this.setTableName();
        this.m_newTableName.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                ExcelImportDialog.this.tabPanel.setTableName(ExcelImportDialog.this.m_newTableName.getText());
            }

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.tabPanel.setTableName(this.m_newTableName.getText());
        this.tabPanel.populateShuttle(this._workbook, this.getCurrentSheet(), this._model);
        this.tabPanel.setTabPlacement(1);
        this.tabPanel.setTabLayoutPolicy(0);
        this.tabPanel.setWorkSheet(this.getCurrentSheet());
        this.tabPanel.refreshExcelColumnPositions();
        jPanel3.add((Component)this.tabPanel, gridBagConstraints7);
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel3, null, (String)string, (int)4);
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel3, "f1_excelimport_html");
        this._btnInsert = new JButton(ExcelDialogArb.getString(5));
        this._btnCancel = new JButton(ExcelDialogArb.getString(6));
        this.dlg.addCustomButton((Component)this._btnInsert);
        this.dlg.addCustomButton((Component)this._btnCancel);
        object = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object.equals(ExcelImportDialog.this._btnInsert)) {
                    ArrayList<String> arrayList = ExcelImportDialog.this.tabPanel.getDML();
                    if (arrayList != null && arrayList.size() > 0 && arrayList.get(0).contains(ExcelDialogArb.getString(7))) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(ExcelDialogArb.getString(8), ExcelImportDialog.this._dbObject.getObjectName()), (String)ExcelDialogArb.getString(9), null);
                    } else if (!ExcelImportDialog.this.tabPanel.isFormatEntered()) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)ExcelDialogArb.getString(10), (String)ExcelDialogArb.getString(9), null);
                    } else {
                        ProgressRunnable progressRunnable = new ProgressRunnable(){

                            protected void doCancel() {
                                ExcelImportUtil.cancel();
                                super.doCancel();
                            }

                            protected void finish(Object object) {
                                super.finish(object);
                            }

                            protected Object doWork() throws Exception {
                                int n = ExcelImportUtil.insertExcelFromModel(dBObject, ExcelImportDialog.this.tabPanel.getDML(), ExcelImportDialog.this.tabPanel.getDDL());
                                if (n > 0) {
                                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)MessageFormat.format(ExcelDialogArb.getString(11), n), (String)ExcelDialogArb.getString(12), null);
                                }
                                return null;
                            }
                        };
                        progressRunnable.setTitle(MessageFormat.format(ExcelDialogArb.getString(11), dBObject.getObjectName()));
                        progressRunnable.setCancelable(true);
                        try {
                            progressRunnable.start(true);
                        }
                        catch (ProgressException progressException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
                        }
                        ExcelImportDialog.this.dlg.dispose();
                        ExcelImportDialog.this._workbook = null;
                    }
                } else if (object.equals(ExcelImportDialog.this._btnCancel)) {
                    ExcelImportDialog.this.dlg.dispose();
                    ExcelImportDialog.this._workbook = null;
                }
            }
        };
        this._btnInsert.addActionListener((ActionListener)object);
        this._btnCancel.addActionListener((ActionListener)object);
        this.dlg.setSize(700, 475);
        this.dlg.setVisible(true);
    }

    private void setTableName() {
        int n = 1;
        String string = ExcelDialogArb.getString(4);
        String string2 = string + n;
        this.m_newTableName.setText(string2);
    }

    private Object Value(HSSFCell hSSFCell) {
        if (hSSFCell != null) {
            switch (hSSFCell.getCellType()) {
                case 1: {
                    return hSSFCell.getStringCellValue() == null ? "" : hSSFCell.getStringCellValue();
                }
                case 3: {
                    return "";
                }
                case 0: {
                    double d = hSSFCell.getNumericCellValue();
                    String string = "";
                    if (HSSFDateUtil.isCellDateFormatted((HSSFCell)hSSFCell)) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(HSSFDateUtil.getJavaDate((double)d));
                        string = String.valueOf(calendar.get(1)).substring(2);
                        string = calendar.get(2) + 1 + "/" + calendar.get(5) + "/" + string;
                    } else {
                        Double d2 = hSSFCell.getNumericCellValue();
                        DecimalFormat decimalFormat = new DecimalFormat();
                        if (d2 != (double)Math.round(d2)) {
                            decimalFormat.applyPattern("#.###########");
                        }
                        string = decimalFormat.format(d2);
                    }
                    return string;
                }
                case 4: {
                    if (hSSFCell.getBooleanCellValue()) {
                        return "true";
                    }
                    return "false";
                }
            }
            return "";
        }
        return "";
    }

    public void populateModel(HSSFSheet hSSFSheet, boolean bl) {
        this._model = new DefaultTableModel();
        this.sorter.setTableModel((TableModel)this._model);
        int n = 0;
        HSSFRow hSSFRow = hSSFSheet.getRow(0);
        if (hSSFRow != null) {
            int n2;
            if (this._model.getColumnCount() == 0 && bl) {
                for (n2 = 0; n2 < hSSFRow.getLastCellNum(); n2 = (short)(n2 + 1)) {
                    this._model.addColumn(this.Value(hSSFRow.getCell((short)n2)));
                }
                n = 1;
            } else {
                for (n2 = 0; n2 < hSSFRow.getLastCellNum(); ++n2) {
                    int n3 = n2 + 1;
                    this._model.addColumn(ExcelDialogArb.getString(14) + n2);
                }
            }
            for (n2 = n; n2 < hSSFSheet.getLastRowNum() + 1; ++n2) {
                hSSFRow = hSSFSheet.getRow(n2);
                Object[] objectArray = new Object[hSSFRow.getLastCellNum() + 1];
                for (short s = 0; s < hSSFRow.getLastCellNum(); s = (short)(s + 1)) {
                    objectArray[s] = hSSFRow.getCell(s) == null ? "" : this.Value(hSSFRow.getCell(s));
                }
                this._model.addRow(objectArray);
            }
            this._model.fireTableDataChanged();
        }
    }

    public HSSFSheet getCurrentSheet() {
        return this.currentSheet;
    }

    protected void setCurrentSheet(HSSFSheet hSSFSheet) {
        this.currentSheet = hSSFSheet;
    }

    protected boolean is_header() {
        return this._header;
    }

    protected void set_header(boolean bl) {
        this._header = bl;
    }

    protected String getTableName() {
        return this.m_newTableName.getText();
    }
}

