/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.importdata;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.dialogs.importdata.ExcelImportUtil;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.XlsNode;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.javatools.dialogs.MessageDialog;

public class ExcelImportEditor {
    private DBObject _dbObject;

    public ExcelImportEditor(DBObject dBObject) {
        this._dbObject = dBObject;
    }

    public ExcelImportEditor() {
    }

    public void importExcel() {
        int n = 0;
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.clearChooseableURLFilters();
        uRLChooser.addChooseableURLFilter(XlsNode.XLS_FILTER);
        n = uRLChooser.showOpenDialog((Component)new JPanel());
        switch (n) {
            case 1: {
                break;
            }
            case 0: {
                URL uRL = uRLChooser.getSelectedURL();
                try {
                    if (uRL != null && (uRL.getFile().toLowerCase().endsWith("xls") || uRL.getFile().toLowerCase().endsWith("csv"))) {
                        try {
                            this.importExcelToTable(uRL, this._dbObject);
                        }
                        catch (FileNotFoundException fileNotFoundException) {}
                        break;
                    }
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)CommonArb.getString(6), (String)CommonArb.getString(7), null);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    ExceptionHandler.handleException((Exception)exception);
                }
                break;
            }
        }
    }

    private void importExcelToTable(URL uRL, DBObject dBObject) throws IOException {
        ExcelImportUtil.insertExcelToTable(uRL, dBObject);
    }

    public void setDBObject(DBObject dBObject) {
        this._dbObject = dBObject;
    }
}

