/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.dialogs.user;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.raptor.dialogs.user.PrivilegeObject;
import oracle.dbtools.raptor.dialogs.user.QuotaObject;
import oracle.dbtools.raptor.dialogs.user.RoleObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserObject {
    private Connection conn;
    private String userName = null;
    private boolean alter;
    private String password;
    private boolean expired = false;
    private boolean locked = false;
    private String defTableSpace;
    private String tempTableSpace;
    private HashMap<String, RoleObject> roles = new HashMap();
    private HashMap<String, PrivilegeObject> privs = new HashMap();
    private HashMap<String, QuotaObject> quotas = new HashMap();
    private ArrayList<String> tablespaceGroups = new ArrayList();
    private String defRoles;
    private String get_privs = "select m.name, decode(nvl(s.admin_option,'NULL'),'NO','YES','NULL','NO','YES') granted,nvl(admin_option,'NO') admin from system_privilege_map m, (select * from dba_sys_privs where (grantee = ? or ? = null)) s where s.privilege(+) = m.name order by 1 ";
    private String get_roles = "select r.role,decode(s.name,r.role,'YES','NO') granted ,nvl(s.admin,'NO') admin,nvl(s.def,'NO') def from dba_roles r, (select granted_role name,admin_option admin ,default_role def from dba_role_privs where grantee = ?) s where s.name(+) = r.role order by 1";
    private String get_quotas = "select t.tablespace_name,nvl(q.unlimited,'NO') unlimited,q.quota,q.unit,t.contents from dba_tablespaces t, (select  tablespace_name,  decode(max_bytes,-1,'YES','NO') unlimited,  decode(max_blocks,-1,null,1,max_bytes/1024,1024,max_bytes/1024/1024) quota , decode(max_blocks,1024,'M',-1,null,'K') unit from dba_ts_quotas where (username = :1 or :1 = null)) q where q.tablespace_name(+) = t.tablespace_name order by 1";
    private String get_user = "select account_status, default_tablespace def,temporary_tablespace temp from dba_users where username = ?";
    private String get_tablespace_groups = "select distinct group_name from dba_tablespace_groups";

    public UserObject(Connection connection, String string) {
        this.userName = string;
        this.conn = connection;
        this.loadUser();
        this.loadPrivs();
        this.loadQuotas();
        this.loadRoles();
        this.loadTablespaceGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadUser() {
        block17: {
            block18: {
                ResultSet resultSet;
                CallableStatement callableStatement;
                block14: {
                    callableStatement = null;
                    resultSet = null;
                    if (this.userName == null) break block18;
                    this.alter = true;
                    callableStatement = this.conn.prepareCall(this.get_user);
                    callableStatement.setString(1, this.userName);
                    resultSet = callableStatement.executeQuery();
                    if (!resultSet.next()) break block14;
                    String string = resultSet.getString(1);
                    if (string.indexOf("LOCKED") != -1) {
                        this.locked = true;
                    }
                    if (string.indexOf("EXPIRED") != -1) {
                        this.expired = true;
                    }
                    this.defTableSpace = resultSet.getString(2);
                    this.tempTableSpace = resultSet.getString(3);
                }
                Object var5_5 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {}
                break block17;
                {
                    catch (Exception exception) {
                        Object var5_6 = null;
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        try {
                            callableStatement.close();
                        }
                        catch (Exception exception2) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            this.alter = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadPrivs() {
        block15: {
            CallableStatement callableStatement = null;
            ResultSet resultSet = null;
            callableStatement = this.conn.prepareCall(this.get_privs);
            callableStatement.setString(1, this.userName);
            callableStatement.setString(2, this.userName);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                PrivilegeObject privilegeObject = new PrivilegeObject(string, string2, string3);
                this.privs.put(string, privilegeObject);
            }
            Object var8_8 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (Exception exception) {
                    Object var8_9 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadQuotas() {
        block15: {
            CallableStatement callableStatement = null;
            ResultSet resultSet = null;
            callableStatement = this.conn.prepareCall(this.get_quotas);
            callableStatement.setString(1, this.userName);
            callableStatement.setString(2, this.userName);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                String string5 = resultSet.getString(5);
                QuotaObject quotaObject = new QuotaObject(string, string2, string3, string4, string5);
                this.quotas.put(string, quotaObject);
            }
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (Exception exception) {
                    Object var10_11 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadTablespaceGroups() {
        block15: {
            CallableStatement callableStatement = null;
            ResultSet resultSet = null;
            callableStatement = this.conn.prepareCall(this.get_tablespace_groups);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                this.tablespaceGroups.add(string);
            }
            Object var5_5 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (Exception exception) {
                    Object var5_6 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadRoles() {
        block15: {
            CallableStatement callableStatement = null;
            ResultSet resultSet = null;
            callableStatement = this.conn.prepareCall(this.get_roles);
            callableStatement.setString(1, this.userName);
            resultSet = callableStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                String string3 = resultSet.getString(3);
                String string4 = resultSet.getString(4);
                RoleObject roleObject = new RoleObject(string, string2, string3, string4);
                this.roles.put(string, roleObject);
            }
            Object var9_9 = null;
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                callableStatement.close();
            }
            catch (Exception exception) {}
            break block15;
            {
                catch (Exception exception) {
                    Object var9_10 = null;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        callableStatement.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    callableStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getSql() {
        this.defRoles = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-- USER SQL\n");
        if (this.alter) {
            stringBuffer.append("ALTER USER ");
            stringBuffer.append(this.userName);
            stringBuffer.append(" ");
            if (this.password != null) {
                stringBuffer.append(" IDENTIFIED BY ");
                stringBuffer.append(this.password);
                stringBuffer.append(" ");
            }
            if (this.defTableSpace != null) {
                stringBuffer.append("\nDEFAULT TABLESPACE ");
                stringBuffer.append(this.defTableSpace);
            }
            if (this.tempTableSpace != null) {
                stringBuffer.append("\nTEMPORARY TABLESPACE ");
                stringBuffer.append(this.tempTableSpace);
            }
            if (this.expired) {
                stringBuffer.append("\nPASSWORD EXPIRE ");
            }
            if (this.locked) {
                stringBuffer.append("\nACCOUNT LOCK ");
            } else {
                stringBuffer.append("\nACCOUNT UNLOCK ");
            }
            stringBuffer.append(";\n");
        } else if (this.userName != null) {
            stringBuffer.append("CREATE USER ");
            stringBuffer.append(this.userName);
            stringBuffer.append(" IDENTIFIED BY ");
            stringBuffer.append(this.password);
            stringBuffer.append(" ");
            if (this.defTableSpace != null) {
                stringBuffer.append("\nDEFAULT TABLESPACE ");
                stringBuffer.append(this.defTableSpace);
            }
            if (this.tempTableSpace != null) {
                stringBuffer.append("\nTEMPORARY TABLESPACE ");
                stringBuffer.append(this.tempTableSpace);
            }
            if (this.expired) {
                stringBuffer.append("\nPASSWORD EXPIRE ");
            }
            if (this.locked) {
                stringBuffer.append("\nACCOUNT LOCK ");
            }
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- ROLES\n");
        for (String string : this.roles.keySet()) {
            RoleObject roleObject = this.roles.get(string);
            if (roleObject.doGrant()) {
                stringBuffer.append("GRANT \"");
                stringBuffer.append(string);
                stringBuffer.append("\" TO ");
                stringBuffer.append(this.userName);
                stringBuffer.append(" ");
                if (roleObject.isAdmin()) {
                    stringBuffer.append("WITH ADMIN OPTION");
                }
                stringBuffer.append(";\n");
            }
            if (roleObject.doRevoke()) {
                stringBuffer.append("REVOKE \"");
                stringBuffer.append(string);
                stringBuffer.append("\" FROM ");
                stringBuffer.append(this.userName);
                stringBuffer.append(";\n");
            }
            if (!roleObject.isDef()) continue;
            if (this.defRoles == null) {
                this.defRoles = "\"" + string + "\"";
                continue;
            }
            this.defRoles = this.defRoles + ",\"" + string + "\"";
        }
        if (this.defRoles != null) {
            stringBuffer.append("ALTER USER " + this.userName + " DEFAULT ROLE " + this.defRoles + ";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- SYSTEM PRIVILEGES\n");
        for (String string : this.privs.keySet()) {
            PrivilegeObject privilegeObject = this.privs.get(string);
            if (privilegeObject.doGrant()) {
                stringBuffer.append("GRANT ");
                stringBuffer.append(string);
                stringBuffer.append(" TO ");
                stringBuffer.append(this.userName);
                stringBuffer.append(" ");
                if (privilegeObject.isAdmin()) {
                    stringBuffer.append("WITH ADMIN OPTION");
                }
                stringBuffer.append(";\n");
            }
            if (!privilegeObject.doRevoke()) continue;
            stringBuffer.append("REVOKE ");
            stringBuffer.append(string);
            stringBuffer.append(" FROM ");
            stringBuffer.append(this.userName);
            stringBuffer.append(";\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append("-- QUOTAS\n");
        for (String string : this.quotas.keySet()) {
            QuotaObject quotaObject = this.quotas.get(string);
            if (quotaObject.isUnlimited()) {
                stringBuffer.append("ALTER USER " + this.userName + " QUOTA UNLIMITED ON " + string + ";\n");
                continue;
            }
            if (quotaObject.getQuota() == null) continue;
            stringBuffer.append("ALTER USER " + this.userName + " QUOTA " + quotaObject.getQuotaString() + " ON " + string + ";\n");
        }
        return stringBuffer.toString();
    }

    public String getDefTableSpace() {
        return this.defTableSpace;
    }

    public void setDefTableSpace(String string) {
        this.defTableSpace = string;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean bl) {
        this.expired = bl;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getTempTableSpace() {
        return this.tempTableSpace;
    }

    public void setTempTableSpace(String string) {
        this.tempTableSpace = string;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void updateRole(String string, boolean bl, boolean bl2, boolean bl3) {
        this.roles.get(string).setGranted(bl);
        this.roles.get(string).setAdmin(bl2);
        this.roles.get(string).setDef(bl3);
    }

    public void updateRole(RoleObject roleObject) {
        RoleObject roleObject2 = this.roles.get(roleObject.getName());
        roleObject2.setAdmin(roleObject.isAdmin());
        roleObject2.setDef(roleObject.isDef());
        roleObject2.setGranted(roleObject.isGranted());
    }

    public void updatePriv(String string, boolean bl, boolean bl2) {
        this.privs.get(string).setGranted(bl);
        this.privs.get(string).setAdmin(bl2);
    }

    public void updatePrivs(PrivilegeObject privilegeObject) {
        PrivilegeObject privilegeObject2 = this.privs.get(privilegeObject.getName());
        privilegeObject2.setAdmin(privilegeObject.isAdmin());
        privilegeObject2.setGranted(privilegeObject.isGranted());
    }

    public void updateQuota(String string, boolean bl, String string2, String string3) {
        this.quotas.get(string).setUnlimited(bl);
        this.quotas.get(string).setQuota(string2);
        this.quotas.get(string).setUnit(string3);
    }

    public void updateQuota(QuotaObject quotaObject) {
        QuotaObject quotaObject2 = this.quotas.get(quotaObject.getName());
        quotaObject2.setUnlimited(quotaObject.isUnlimited());
        quotaObject2.setQuota(quotaObject.getQuota());
        quotaObject2.setUnit(quotaObject.getUnit());
    }

    public HashMap<String, PrivilegeObject> getPrivs() {
        return this.privs;
    }

    public HashMap<String, QuotaObject> getQuotas() {
        return this.quotas;
    }

    public HashMap<String, RoleObject> getRoles() {
        return this.roles;
    }

    public ArrayList<String> getTablespaceGroups() {
        return this.tablespaceGroups;
    }

    public boolean isAlter() {
        return this.alter;
    }
}

