/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.diff.core.CompareObject;
import oracle.dbtools.raptor.diff.core.DiffObject;
import oracle.dbtools.raptor.diff.oracle.db_link.OracleDbLinkDiff;
import oracle.dbtools.raptor.diff.oracle.index.OracleIndexDiff;
import oracle.dbtools.raptor.diff.oracle.mat_view.OracleMatViewDiff;
import oracle.dbtools.raptor.diff.oracle.mat_view_log.OracleMatViewLogDiff;
import oracle.dbtools.raptor.diff.oracle.plsql.OraclePlSqlDiff;
import oracle.dbtools.raptor.diff.oracle.sequence.OracleSequenceDiff;
import oracle.dbtools.raptor.diff.oracle.synonym.OracleSynonymDiff;
import oracle.dbtools.raptor.diff.oracle.table.OracleTableDiff;
import oracle.dbtools.raptor.diff.ui.DiffEditorNode;
import oracle.dbtools.raptor.diff.ui.DiffWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffApi {
    private static HashMap<String, Class> typeRegistry = new HashMap();
    private String sourceConnName;
    private Connection sourceConn;
    private String destConnName;
    private Connection destConn;
    private ArrayList<URL> _objectList;
    private LinkedList<DiffObject> _diffList;
    private static Exception registryTypeExists;
    private DDLFormat _ddlFormat = null;
    private DDLTypes _ddlType = null;
    private String _EOL;
    private String badSetup = null;
    private String lineSep = "-----------------------------------------------------------------" + this.getTerm();
    private Context context;
    private boolean _cancel = false;
    DelayedProgressRunnable dpr;
    LinkedList<DiffObject> list;

    public DiffApi(Connection connection, Connection connection2, DDLFormat dDLFormat, DDLTypes dDLTypes, ArrayList<URL> arrayList) {
        this._ddlFormat = dDLFormat;
        this._ddlType = dDLTypes;
        this._objectList = arrayList;
        this.sourceConn = connection;
        this.destConn = connection2;
        this.sourceConnName = Connections.getConnectionName(Connections.getInstance().getConnectionName(this.sourceConn));
        this.destConnName = Connections.getConnectionName(Connections.getInstance().getConnectionName(this.destConn));
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (this.sourceConnName == null) {
            stringBuilder.append(DiffWizArb.getString(2) + this.getTerm());
            bl = false;
        }
        if (this.destConnName == null) {
            stringBuilder.append(DiffWizArb.getString(3) + this.getTerm());
            bl = false;
        }
        if (this._ddlFormat == null) {
            stringBuilder.append(DiffWizArb.getString(65) + this.getTerm());
            bl = false;
        }
        if (this._ddlType == null) {
            stringBuilder.append(DiffWizArb.getString(66) + this.getTerm());
            bl = false;
        }
        this.badSetup = stringBuilder.toString();
        return bl;
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public static void registerType(String string, Class clazz) throws Exception {
        if (typeRegistry.get(string) != null) {
            throw registryTypeExists;
        }
        typeRegistry.put(string, clazz);
    }

    public static void unRegisterType(String string) {
        if (typeRegistry.get(string) == null) {
            return;
        }
        typeRegistry.remove(string);
    }

    public void addObject(DBObject dBObject) {
        if (this._objectList.indexOf(dBObject.getURL()) == -1) {
            this._objectList.add(dBObject.getURL());
        }
    }

    public void addObject(URL uRL) {
        if (this._objectList.indexOf(uRL) == -1) {
            this._objectList.add(uRL);
        }
    }

    public void addObject(String string, String string2, String string3) throws Exception {
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", this.sourceConnName, null, string, string2);
        URL uRL2 = DBURLFormatHelper.getURL(uRL, string3);
        if (this._objectList.indexOf(uRL2) == -1) {
            this._objectList.add(uRL2);
        }
    }

    public void removeObject(DBObject dBObject) {
        int n = this._objectList.indexOf(dBObject.getURL());
        if (n > -1) {
            this._objectList.remove(n);
        }
    }

    public void removeObject(URL uRL) {
        int n = this._objectList.indexOf(uRL);
        if (n > -1) {
            this._objectList.remove(n);
        }
    }

    public void removeObject(String string, String string2, String string3) throws Exception {
        URL uRL = DBURLFormatHelper.getURL("sqldev.nav", this.sourceConnName, null, string, string2);
        URL uRL2 = DBURLFormatHelper.getURL(uRL, string3);
        int n = this._objectList.indexOf(uRL2);
        if (n > -1) {
            this._objectList.remove(n);
        }
    }

    public void doDiffWithDialog() {
        this._cancel = false;
        this.dpr = new DelayedProgressRunnable("Comparing...", null, 500, null, new JLabel());
        ((JLabel)this.dpr.getDetailComponent()).setText(DiffWizArb.getString(68));
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

            public void cancel() {
                DiffApi.this._cancel = true;
            }

            public void finish(Object object) {
                try {
                    DiffEditorNode diffEditorNode = new DiffEditorNode();
                    diffEditorNode.setDiffObjects(DiffApi.this.list);
                    DiffApi.this.context = Context.newIdeContext((Node)diffEditorNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(DiffApi.this.context);
                    openEditorOptions.setFlags(1);
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void preWork() {
            }

            public Object doWork() {
                try {
                    DiffApi.this.list = DiffApi.this.processDiffs();
                    return true;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    return false;
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DiffApi.this.dpr.setRunnable(iDelayedProgressRunnable);
                DiffApi.this.dpr.setCancellable(true);
                DiffApi.this.dpr.start();
            }
        });
    }

    public void doDiff() {
        try {
            this._cancel = false;
            this.list = this.processDiffs();
            DiffEditorNode diffEditorNode = new DiffEditorNode();
            diffEditorNode.setDiffObjects(this.list);
            this.context = Context.newIdeContext((Node)diffEditorNode);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(this.context);
            openEditorOptions.setFlags(1);
            EditorManager.getEditorManager().openEditor(openEditorOptions);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void setProg(String string) {
        if (this.dpr != null) {
            this.dpr.getProgressPanel().setMessage(string);
        }
    }

    public LinkedList<DiffObject> processDiffs() throws Exception {
        this.loadList();
        this._diffList = new LinkedList();
        LinkedList<String> linkedList = DiffApi.getOrderedTypes();
        block2: for (String string : linkedList) {
            if (!typeRegistry.containsKey(string)) continue;
            String[] stringArray = string.split("#");
            ArrayList<URL> arrayList = this.getTypeList(stringArray[1].replace("_", " "));
            for (URL uRL : arrayList) {
                if (this._cancel) continue block2;
                try {
                    this.setProg(DBURLFormatHelper.getName(uRL));
                    Object t = typeRegistry.get(string).newInstance();
                    ((CompareObject)t).setup(this.sourceConn, this.destConn, uRL);
                    ((CompareObject)t).setDDLFormat(this._ddlFormat);
                    this._diffList.add(((CompareObject)t).getDiff());
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
        return this._diffList;
    }

    private static synchronized LinkedList<String> getOrderedTypes() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("Oracle#DATABASE_LINK");
        linkedList.add("Oracle#SEQUENCE");
        linkedList.add("Oracle#TABLE");
        linkedList.add("Oracle#DATA");
        linkedList.add("Oracle#CONSTRAINT");
        linkedList.add("Oracle#INDEX");
        linkedList.add("Oracle#REFCONSTRAINT");
        linkedList.add("Oracle#TRIGGER");
        linkedList.add("Oracle#MATERIALIZED_VIEW");
        linkedList.add("Oracle#MATERIALIZED_VIEW_LOG");
        linkedList.add("Oracle#VIEW");
        linkedList.add("Oracle#FUNCTION");
        linkedList.add("Oracle#PACKAGE");
        linkedList.add("Oracle#PACKAGE_BODY");
        linkedList.add("Oracle#PROCEDURE");
        linkedList.add("Oracle#TYPE");
        linkedList.add("Oracle#SYNONYM");
        return linkedList;
    }

    private ArrayList<URL> getTypeList(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this._objectList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    private void loadList() throws SQLException {
        String string = this.sourceConn.getMetaData().getUserName();
        LinkedHashMap<String, String> linkedHashMap = this._ddlType.getTypes();
        String string2 = Connections.getInstance().getConnectionName(this.sourceConn);
        for (String string3 : linkedHashMap.keySet()) {
            ArrayList<DBObject> arrayList;
            Object object;
            if ((string3.equals("CONSTRAINT") || string3.equals("REFCONSTRAINT")) && this.getTypeList("TABLE").size() > 0) {
                object = this.getTypeList("TABLE");
                arrayList = ((ArrayList)object).iterator();
                while (arrayList.hasNext()) {
                    DBObject dBObject = new DBObject(arrayList.next());
                    URL uRL = DBURLFormatHelper.getURL("sqldev.nav", string2, null, dBObject.getSchemaName(), string3);
                    URL uRL2 = DBURLFormatHelper.getURL(uRL, dBObject.getObjectName());
                    this.addObject(uRL2);
                }
                continue;
            }
            if (this.getTypeList(string3).size() > 0) {
                object = this.getTypeList(string3);
                arrayList = ((ArrayList)object).iterator();
                while (arrayList.hasNext()) {
                    this.addObject(arrayList.next());
                }
                continue;
            }
            object = linkedHashMap.get(string3);
            arrayList = DDLGenerator.getInstance().getSchemaObjects(this.sourceConn, string, string3, (String)object);
            if (arrayList == null) continue;
            for (DBObject dBObject : arrayList) {
                this.addObject(dBObject);
            }
        }
    }

    public String getSummary() {
        ArrayList<URL> arrayList;
        if (!this.checkSetup()) {
            return this.badSetup;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Export Summary");
        stringBuilder.append(this.getTerm());
        stringBuilder.append(this.getTerm());
        stringBuilder.append(DiffWizArb.getString(0) + this.sourceConnName + this.getTerm());
        stringBuilder.append(this.lineSep);
        stringBuilder.append(DiffWizArb.getString(1) + this.destConnName + this.getTerm());
        stringBuilder.append(this.lineSep);
        stringBuilder.append(DiffWizArb.getString(46) + this.getTerm());
        if (this._ddlFormat.getSchema()) {
            stringBuilder.append("\t" + DiffWizArb.getString(13) + this.getTerm());
        }
        if (this._ddlFormat.getSegments()) {
            stringBuilder.append("\t" + DiffWizArb.getString(14) + this.getTerm());
        }
        if (this._ddlFormat.getTerminator()) {
            stringBuilder.append("\t" + DiffWizArb.getString(15) + this.getTerm());
        }
        if (this._ddlFormat.getPretty()) {
            stringBuilder.append("\t" + DiffWizArb.getString(16) + this.getTerm());
        }
        if (this._ddlFormat.getByte()) {
            stringBuilder.append("\t" + DiffWizArb.getString(17) + this.getTerm());
        }
        if (this._ddlFormat.getForce()) {
            stringBuilder.append("\t" + DiffWizArb.getString(18) + this.getTerm());
        }
        if (this._ddlFormat.getDrop()) {
            stringBuilder.append("\t" + DiffWizArb.getString(20) + this.getTerm());
        }
        stringBuilder.append(this.lineSep);
        if (this._ddlType.getTable()) {
            if (this._ddlType.getTableDeps()) {
                stringBuilder.append(DiffWizArb.getString(47) + this.getTerm());
            } else {
                stringBuilder.append(DiffWizArb.getString(32) + this.getTerm());
            }
            arrayList = this.getTypeList("TABLE");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(48) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getView()) {
            stringBuilder.append(DiffWizArb.getString(39) + this.getTerm());
            arrayList = this.getTypeList("VIEW");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(49) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getIndex()) {
            stringBuilder.append(DiffWizArb.getString(30) + this.getTerm());
            arrayList = this.getTypeList("INDEX");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(50) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getPackSpec()) {
            stringBuilder.append(DiffWizArb.getString(37) + this.getTerm());
            arrayList = this.getTypeList("PACKAGE");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(51) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getPackBody()) {
            stringBuilder.append(DiffWizArb.getString(36) + this.getTerm());
            arrayList = this.getTypeList("PACKAGE BODY");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(52) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getProcedure()) {
            stringBuilder.append(DiffWizArb.getString(34) + this.getTerm());
            arrayList = this.getTypeList("PROCEDURE");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(53) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getFunction()) {
            stringBuilder.append(DiffWizArb.getString(38) + this.getTerm());
            arrayList = this.getTypeList("FUNCTION");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(54) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getTrigger()) {
            stringBuilder.append(DiffWizArb.getString(40) + this.getTerm());
            arrayList = this.getTypeList("TRIGGER");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(55) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getType()) {
            stringBuilder.append(DiffWizArb.getString(31) + this.getTerm());
            arrayList = this.getTypeList("TYPE");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(56) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getSequence()) {
            stringBuilder.append(DiffWizArb.getString(35) + this.getTerm());
            arrayList = this.getTypeList("SEQUENCE");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(57) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getMatView()) {
            stringBuilder.append(DiffWizArb.getString(27) + this.getTerm());
            arrayList = this.getTypeList("MATERIALIZED VIEW");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(58) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getMatViewLog()) {
            stringBuilder.append(DiffWizArb.getString(24) + this.getTerm());
            arrayList = this.getTypeList("MATERIALIZED VIEW LOG");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(59) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getSynonymn()) {
            stringBuilder.append(DiffWizArb.getString(26) + this.getTerm());
            arrayList = this.getTypeList("SYNONYM");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(60) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        if (this._ddlType.getDbLink()) {
            stringBuilder.append(DiffWizArb.getString(25) + this.getTerm());
            arrayList = this.getTypeList("DATABASE LINK");
            if (arrayList.size() == 0) {
                stringBuilder.append(DiffWizArb.getString(61) + this.getTerm());
            } else {
                for (URL uRL : arrayList) {
                    stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                }
            }
            stringBuilder.append(this.lineSep);
        }
        return stringBuilder.toString();
    }

    static {
        try {
            DiffApi.registerType("Oracle#VIEW", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#PROCEDURE", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#FUNCTION", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#PACKAGE", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#PACKAGE_BODY", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#TRIGGER", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#TYPE", OraclePlSqlDiff.class);
            DiffApi.registerType("Oracle#MATERIALIZED_VIEW", OracleMatViewDiff.class);
            DiffApi.registerType("Oracle#MATERIALIZED_VIEW_LOG", OracleMatViewLogDiff.class);
            DiffApi.registerType("Oracle#TABLE", OracleTableDiff.class);
            DiffApi.registerType("Oracle#INDEX", OracleIndexDiff.class);
            DiffApi.registerType("Oracle#SEQUENCE", OracleSequenceDiff.class);
            DiffApi.registerType("Oracle#SYNONYM", OracleSynonymDiff.class);
            DiffApi.registerType("Oracle#DATABASE_LINK", OracleDbLinkDiff.class);
        }
        catch (Exception exception) {
            Logger.getLogger(DiffApi.class.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }
}

