/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.core;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.diff.core.DiffObjectAttributes;
import oracle.dbtools.raptor.diff.core.RowDiffInfo;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompareAttribute {
    private DiffObjectAttributes _diffObj;
    private static String _EOL;

    public DiffObjectAttributes getObj() {
        return this._diffObj;
    }

    public void setObj(DiffObjectAttributes diffObjectAttributes) {
        this._diffObj = diffObjectAttributes;
    }

    protected String getTerm() {
        if (_EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            _EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return _EOL;
    }

    protected void loadDestCols(String string, HashMap<String, String> hashMap) {
        block17: {
            ResultSet resultSet = null;
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            try {
                resultSet = dBUtil.executeQuery(this.getObj().getDest(), string, hashMap);
                if (resultSet == null) break block17;
                int n = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
                    String string2 = resultSet.getString(1);
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSet.getMetaData().getColumnTypeName(i);
                        if (string3.equals("VARCHAR2")) {
                            hashMap2.put(i, resultSet.getString(i));
                            continue;
                        }
                        if (!string3.equals("NUMBER")) continue;
                        hashMap2.put(i, resultSet.getBigDecimal(i));
                    }
                    this.getObj().putDestRow(string2, hashMap2);
                }
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    protected void loadSourceCols(String string, HashMap<String, String> hashMap) {
        block17: {
            ResultSet resultSet = null;
            DBUtil dBUtil = DBUtil.getInstance();
            dBUtil.setRaiseError(false);
            try {
                resultSet = dBUtil.executeQuery(this.getObj().getSource(), string, hashMap);
                if (resultSet == null) break block17;
                int n = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
                    String string2 = resultSet.getString(1);
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSet.getMetaData().getColumnTypeName(i);
                        if (string3.equals("VARCHAR2")) {
                            hashMap2.put(i, resultSet.getString(i));
                            continue;
                        }
                        if (!string3.equals("NUMBER")) continue;
                        hashMap2.put(i, resultSet.getBigDecimal(i));
                    }
                    this.getObj().putSourceRow(string2, hashMap2);
                }
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                try {
                    if (resultSet != null && resultSet.getStatement() != null) {
                        resultSet.getStatement().close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    protected void loadDiff() {
        HashMap<Integer, Object> hashMap;
        for (String string : this.getObj().getSourceRows().keySet()) {
            hashMap = this.getObj().getDestRow(string);
            if (hashMap != null) continue;
            this.getObj().putDiff(string, new RowDiffInfo(true, false));
        }
        for (String string : this.getObj().getDestRows().keySet()) {
            hashMap = this.getObj().getSourceRow(string);
            if (hashMap != null) continue;
            this.getObj().putDiff(string, new RowDiffInfo(false, true));
        }
        for (String string : this.getObj().getSourceRows().keySet()) {
            if (this.getObj().getDiffs().get(string) != null) continue;
            hashMap = this.getObj().getSourceRow(string);
            HashMap<Integer, Object> hashMap2 = this.getObj().getDestRow(string);
            RowDiffInfo rowDiffInfo = new RowDiffInfo(false, false);
            if (hashMap2 != null) {
                for (int n : hashMap.keySet()) {
                    Object object = hashMap.get(n);
                    Object object2 = hashMap2.get(n);
                    if (object instanceof BigDecimal) {
                        if (((BigDecimal)object).compareTo((BigDecimal)object2) == 0) continue;
                        rowDiffInfo.addCol(n, String.valueOf(object));
                        continue;
                    }
                    if (object != null && object2 == null) {
                        rowDiffInfo.addCol(n, String.valueOf(object));
                        continue;
                    }
                    if (object == null || object2 == null || object.equals(object2)) continue;
                    rowDiffInfo.addCol(n, String.valueOf(object));
                }
            }
            if (rowDiffInfo.getCols().size() <= 0) continue;
            this.getObj().putDiff(string, rowDiffInfo);
        }
    }

    public abstract void doDiff();

    public abstract String getSql();
}

