/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.oracle.table;

import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.diff.core.CompareAttribute;
import oracle.dbtools.raptor.diff.core.RowDiffInfo;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.utils.Connections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffTableColumns
extends CompareAttribute {
    private String dColSql;
    private String sColSql;

    private void getQueries() {
        QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/diff/oracle/table/TableColSql.xml");
        Query query = queryXMLSupport.getQuery("col_sql", Connections.getInstance().getConnectionName(this.getObj().getDest()));
        this.dColSql = query.getSql();
        query = queryXMLSupport.getQuery("col_sql", Connections.getInstance().getConnectionName(this.getObj().getSource()));
        this.sColSql = query.getSql();
    }

    @Override
    public void doDiff() {
        this.getQueries();
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = this.getObj().getDest().getMetaData().getUserName();
            String string2 = this.getObj().getSource().getMetaData().getUserName();
            URL uRL = this.getObj().getUrl();
            hashMap.put("NAME", DBURLFormatHelper.getName(uRL));
            hashMap.put("OWNER", string);
            this.loadDestCols(this.dColSql, hashMap);
            hashMap.put("OWNER", string2);
            this.loadSourceCols(this.sColSql, hashMap);
            this.loadDiff();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    @Override
    public String getSql() {
        URL uRL = this.getObj().getUrl();
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, RowDiffInfo> hashMap = this.getObj().getDiffs();
        for (String string : hashMap.keySet()) {
            String string2;
            HashMap<Integer, Object> hashMap2;
            RowDiffInfo rowDiffInfo = hashMap.get(string);
            if (rowDiffInfo.isDrop()) {
                stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " drop column " + string + ";" + this.getTerm());
                continue;
            }
            if (rowDiffInfo.isCreate()) {
                hashMap2 = this.getObj().getSourceRow(string);
                stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " add ( " + string + this.getDataType(hashMap2) + this.getDefault(hashMap2.get(7)) + this.getNull(hashMap2.get(6)) + ");" + this.getTerm());
                continue;
            }
            hashMap2 = this.getObj().getSourceRow(string);
            HashMap<Integer, Object> hashMap3 = this.getObj().getDestRow(string);
            String string3 = String.valueOf(hashMap2.get(2));
            if (this.canMapType(string3, string2 = String.valueOf(hashMap3.get(2)))) {
                stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " modify ( " + string + this.getDataType(hashMap2) + this.getDefault(hashMap2.get(7)) + this.getNull(hashMap2.get(6)) + ");" + this.getTerm());
                continue;
            }
            stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " rename column " + string + " to " + this.getOldName(string) + ";" + this.getTerm());
            stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " add ( " + string + this.getDataType(hashMap2) + this.getDefault(hashMap2.get(7)) + this.getNull(hashMap2.get(6)) + ");" + this.getTerm());
            stringBuilder.append("update " + DBURLFormatHelper.getName(uRL) + " set " + string + " = " + this.getOldName(string) + ";" + this.getTerm());
            stringBuilder.append("commit;" + this.getTerm());
            stringBuilder.append("alter table " + DBURLFormatHelper.getName(uRL) + " drop column " + this.getOldName(string) + ";" + this.getTerm());
        }
        return stringBuilder.toString();
    }

    private String getOldName(String string) {
        if (string.length() > 27) {
            return string.substring(1, 28) + "_OLD";
        }
        return string + "_OLD";
    }

    private boolean canMapType(String string, String string2) {
        boolean bl = true;
        if (string2.equals("CLOB") || string.equals("CLOB")) {
            return false;
        }
        return bl;
    }

    private String getDefault(Object object) {
        if (object != null) {
            return " DEFAULT " + (String)object;
        }
        return "";
    }

    private String getNull(Object object) {
        if (object != null && ((String)object).equals("N")) {
            return " NOT NULL ";
        }
        return "";
    }

    private String getDataType(HashMap<Integer, Object> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = String.valueOf(hashMap.get(2));
        String string2 = String.valueOf(hashMap.get(3));
        String string3 = String.valueOf(hashMap.get(4));
        String string4 = String.valueOf(hashMap.get(5));
        if (string.equals("VARCHAR2")) {
            stringBuilder.append(" VARCHAR2(" + string2 + ") ");
        } else if (string.equals("NUMBER")) {
            stringBuilder.append(" NUMBER ");
            if (!string3.equals("null")) {
                stringBuilder.append("(" + string3 + "," + string4 + ") ");
            }
        } else if (string.equals("CHAR")) {
            stringBuilder.append(" CHAR(" + string2 + ") ");
        } else {
            stringBuilder.append(" " + string + " ");
        }
        return stringBuilder.toString();
    }
}

