/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.diff.core.DiffObject;
import oracle.dbtools.raptor.diff.ui.DiffEditorNode;
import oracle.dbtools.raptor.diff.ui.DiffTableModel;
import oracle.dbtools.raptor.diff.ui.FilePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class DiffEditor
extends Editor
implements Controller {
    private JPanel _panel = new JPanel();
    private Toolbar _toolbar = new Toolbar();
    private JPanel _ui = new JPanel();
    private DiffTableModel _model;
    private JTable _table;
    private BasicEditorPane _sql;
    private String _sName = null;
    private String _dName = null;
    private JLabel lab = new JLabel();
    private boolean isDirty = true;
    JCheckBox _cb = new JCheckBox("Show Equal Objects");
    private DiffEditor _editor;
    private String _encode = null;
    private boolean _cancel = false;
    private SqlNode _exp;

    public void open() {
    }

    public DiffEditor() {
        this.setEditorAttribute("scrollable", Boolean.FALSE);
        this._model = new DiffTableModel();
        this._model.addColumn("Include");
        this._model.addColumn("Type");
        this._model.addColumn("Owner");
        this._model.addColumn("Name");
        this._model.addColumn("Change");
        this._model.addColumn("Diff Count");
        this._table = new JTable();
        this._table.setModel(this._model);
        SelectionListener selectionListener = new SelectionListener(this._table);
        this._table.getSelectionModel().addListSelectionListener(selectionListener);
        this._table.setSelectionMode(0);
        TableColumn tableColumn = this._table.getColumnModel().getColumn(0);
        JCheckBox jCheckBox = new JCheckBox();
        tableColumn.setCellEditor(new CheckboxEditor(jCheckBox));
        tableColumn.setCellRenderer(new CheckboxRenderer());
        tableColumn.setHeaderRenderer(new CheckBoxHeader(new MyItemListener()));
        tableColumn.sizeWidthToFit();
        tableColumn.setWidth(tableColumn.getWidth() + 20);
        tableColumn.setMinWidth(tableColumn.getWidth() + 20);
        tableColumn.setMaxWidth(tableColumn.getWidth() + 20);
        tableColumn = this._table.getColumnModel().getColumn(5);
        tableColumn.setCellRenderer(new ColumnRenderer());
        this._panel.setLayout(new BorderLayout());
        this.buildToolbar();
        this._panel.add((Component)this._toolbar, "First");
        this.buildUI();
        this._panel.add(this._ui);
        this._editor = this;
    }

    public Component getGUI() {
        this.refresh();
        this.lab.setText(this._sName + " -> " + this._dName);
        return this._panel;
    }

    private void refresh() {
        if (this.isDirty) {
            Context context = this.getContext();
            DiffEditorNode diffEditorNode = (DiffEditorNode)context.getNode();
            LinkedList<DiffObject> linkedList = diffEditorNode.getDiffObjects();
            this._model.clear();
            for (DiffObject diffObject : linkedList) {
                if (this._cb.isSelected()) {
                    this._model.addRow(diffObject);
                } else if (diffObject.getDiffCount() > 0) {
                    this._model.addRow(diffObject);
                }
                if (this._sName == null) {
                    this._sName = Connections.getConnectionName(Connections.getInstance().getConnectionName(diffObject.getSource()));
                }
                if (this._dName != null) continue;
                this._dName = Connections.getConnectionName(Connections.getInstance().getConnectionName(diffObject.getDest()));
            }
            this._model.fireTableDataChanged();
            this._sql.setEditable(true);
            this._sql.setText("");
            this._sql.setEditable(false);
            this.isDirty = false;
        }
    }

    private void buildToolbar() {
        AbstractAction abstractAction = new AbstractAction("Generate Script", CommonArb.getIcon(0)){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                FilePanel filePanel = new FilePanel(DiffEditor.this._editor.getGUI());
                filePanel.prompt();
                if (!filePanel.getFileName().equals("")) {
                    DiffEditor.this.writeDiff(filePanel.getFileName(), filePanel.getEncoding());
                }
            }
        };
        abstractAction.putValue("ShortDescription", "Generate Script");
        this._toolbar.add((Action)abstractAction);
        this._toolbar.addFiller();
        this._toolbar.addSeparator();
        this._toolbar.addFiller();
        this._toolbar.add((Component)this.lab);
        this._toolbar.addFiller();
        this._toolbar.addSeparator();
        this._toolbar.addFiller();
        this._cb.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DiffEditor.this.isDirty = true;
                DiffEditor.this.refresh();
            }
        });
        this._toolbar.add((Component)this._cb);
    }

    public void writeDiff(String string, String string2) {
        this._encode = string2;
        final String string3 = string;
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

            public void cancel() {
                DiffEditor.this._cancel = true;
            }

            public Object doWork() {
                Object var1_1 = null;
                try {
                    DiffEditor.this.outputDiff(string3, DiffEditor.this._encode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File file = new File(string3);
                try {
                    URL uRL = file.toURL();
                    DiffEditor.this._exp = new SqlNode(uRL);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Context context = Context.newIdeContext((Node)DiffEditor.this._exp);
                            OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                            openEditorOptions.setFlags(1);
                            EditorManager.getEditorManager().openEditor(openEditorOptions);
                        }
                    });
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
                return var1_1;
            }

            public void finish(Object object) {
            }

            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Exporting", null, 500, iDelayedProgressRunnable);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    public void outputDiff(String string, String string2) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
        Context context = this.getContext();
        DiffEditorNode diffEditorNode = (DiffEditorNode)context.getNode();
        LinkedList<DiffObject> linkedList = diffEditorNode.getDiffObjects();
        for (DiffObject diffObject : linkedList) {
            if (this._cancel || !diffObject.isScript()) continue;
            outputStreamWriter.write(diffObject.getSql());
        }
        outputStreamWriter.flush();
        outputStreamWriter.close();
    }

    private void buildUI() {
        this._sql = EditorFactory.createIdeEditorPane();
        this._sql.setDocument((Document)new BasicDocument("foo.plsql"));
        this._sql.setPreferredSize(new Dimension(300, 200));
        this._sql.setText("");
        this._sql.setEditable(false);
        this._ui.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this._table);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView((Component)this._sql);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this._ui.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void update(Object object, UpdateMessage updateMessage) {
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable jTable) {
            this.table = jTable;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            int n = DiffEditor.this._table.getSelectedRow();
            if (n != -1) {
                DiffEditor.this._sql.setEditable(true);
                DiffEditor.this._sql.setText(DiffEditor.this._model.getRow(n).getSql());
                DiffEditor.this._sql.setEditable(false);
            }
        }
    }

    public class CheckboxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public CheckboxRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            boolean bl3 = object != null && (Boolean)object != false;
            this.setSelected(bl3);
            return this;
        }
    }

    public class CheckboxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;

        public CheckboxEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (!(object instanceof AbstractButton)) {
                return;
            }
            boolean bl = itemEvent.getStateChange() == 1;
            int n = DiffEditor.this._table.getRowCount();
            for (int i = 0; i < n; ++i) {
                DiffEditor.this._table.setValueAt(new Boolean(bl), i, 0);
            }
        }
    }

    class CheckBoxHeader
    extends JCheckBox
    implements TableCellRenderer,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected CheckBoxHeader rendererComponent = this;
        protected int column;
        protected boolean mousePressed = false;

        public CheckBoxHeader(ItemListener itemListener) {
            this.rendererComponent.setSelected(true);
            this.rendererComponent.addItemListener(itemListener);
            this.rendererComponent.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.rendererComponent.setForeground(jTableHeader.getForeground());
                this.rendererComponent.setBackground(jTableHeader.getBackground());
                this.rendererComponent.setFont(jTableHeader.getFont());
                jTableHeader.addMouseListener(this.rendererComponent);
            }
            this.setColumn(n2);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this.rendererComponent;
        }

        protected void setColumn(int n) {
            this.column = n;
        }

        public int getColumn() {
            return this.column;
        }

        protected void handleClickEvent(MouseEvent mouseEvent) {
            if (this.mousePressed) {
                this.mousePressed = false;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                JTable jTable = jTableHeader.getTable();
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable.convertColumnIndexToModel(n);
                if (n == this.column && mouseEvent.getClickCount() == 1 && n2 != -1) {
                    this.doClick();
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.handleClickEvent(mouseEvent);
            ((JTableHeader)mouseEvent.getSource()).repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mousePressed = true;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }
    }

    class ColumnRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        ColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (n2 == 5) {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }
}

