/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.diff.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import oracle.dbtools.raptor.controls.OracleConnectionComboBox;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.diff.ui.DiffWizArb;
import oracle.dbtools.raptor.diff.ui.TypeOptionsPanel;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;

public class DiffWizDBSelector
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 1L;
    private final JCheckBox cbBlockFinish = new JCheckBox(DiffWizArb.getString(12));
    private DDLTypes ddlTypes;
    private DDLFormat _ddlOptions;
    private ArrayList<URL> oList = new ArrayList();
    private HashMap<URL, String> dList = new HashMap();
    private OracleConnectionComboBox sourceConnSelector = new OracleConnectionComboBox();
    private OracleConnectionComboBox destConnSelector = new OracleConnectionComboBox();
    private static TypeOptionsPanel _typeOptions = new TypeOptionsPanel();
    private static LinkedHashMap<String, String> types;

    public DiffWizDBSelector() {
        this.sourceConnSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    DiffWizDBSelector.this.sourceConnSelector.getCurrentDatabase();
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    DiffWizDBSelector.this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Exception)exception2);
                }
            }
        });
        this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
        this.destConnSelector.getJComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    DiffWizDBSelector.this.destConnSelector.getCurrentDatabase();
                }
                catch (Exception exception) {
                    Throwable throwable;
                    Exception exception2;
                    DiffWizDBSelector.this.destConnSelector.getJComboBox().setSelectedIndex(-1);
                    while (exception2 instanceof DBException && (throwable = exception2.getCause()) instanceof Exception) {
                        exception2 = (Exception)throwable;
                    }
                    ExceptionHandler.handleException((Exception)exception2);
                }
            }
        });
        this.destConnSelector.getJComboBox().setSelectedIndex(-1);
        this.setLayout(new GridBagLayout());
        this.add(new JLabel(DiffWizArb.getString(0)), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.sourceConnSelector.getJComboBox(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.add(new JLabel(DiffWizArb.getString(1)), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.destConnSelector.getJComboBox(), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(_typeOptions.getPanel(), new GridBagConstraints(0, 2, 3, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(this.cbBlockFinish, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext traversableContext) {
        this.ddlTypes = (DDLTypes)traversableContext.get("DDLTYPE");
        if (this.ddlTypes == null) {
            this.ddlTypes = new DDLTypes();
        }
        _typeOptions.setDDLType(this.ddlTypes);
        traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        try {
            if (this.sourceConnSelector.getCurrentDatabase() == null) {
                throw new TraversalException(DiffWizArb.getString(2));
            }
        }
        catch (DBException dBException) {
            this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            throw new TraversalException(DiffWizArb.getString(2));
        }
        try {
            if (this.destConnSelector.getCurrentDatabase() == null) {
                throw new TraversalException(DiffWizArb.getString(3));
            }
        }
        catch (DBException dBException) {
            this.destConnSelector.getJComboBox().setSelectedIndex(-1);
            throw new TraversalException(DiffWizArb.getString(3));
        }
        try {
            if (this.sourceConnSelector.getCurrentDatabase() == this.destConnSelector.getCurrentDatabase()) {
                throw new TraversalException(DiffWizArb.getString(4));
            }
        }
        catch (DBException dBException) {
            this.sourceConnSelector.getJComboBox().setSelectedIndex(-1);
            throw new TraversalException(DiffWizArb.getString(5));
        }
        traversableContext.put("SOURCE_CONNECTION", (Object)this.sourceConnSelector.getCurrentConnection());
        traversableContext.put("SOURCE_CONNECTION_NAME", (Object)this.sourceConnSelector.getCurrentConnectionName());
        traversableContext.put("DEST_CONNECTION", (Object)this.destConnSelector.getCurrentConnection());
        traversableContext.put("DEST_CONNECTION_NAME", (Object)this.destConnSelector.getCurrentConnectionName());
        traversableContext.put("DDLFORMAT", (Object)new DDLFormat());
        traversableContext.put("OBJECT_LIST", this.oList);
        traversableContext.put("DATA_LIST", this.dList);
        this.ddlTypes = _typeOptions.getDDLType();
        if (this.ddlTypes == null) {
            this.ddlTypes = new DDLTypes();
        }
        if ((types = this.ddlTypes.getTypes()).size() == 0) {
            throw new TraversalException(DiffWizArb.getString(42));
        }
        traversableContext.put("DDLTYPE", (Object)this.ddlTypes);
        this._ddlOptions = new DDLFormat();
        this._ddlOptions.setSchema(false);
        this._ddlOptions.setSegments(false);
        this._ddlOptions.setPretty(true);
        this._ddlOptions.setTerminiator(true);
        traversableContext.put("DDLFORMAT", (Object)this._ddlOptions);
    }

    public Object getExitTransition() {
        if (this.cbBlockFinish.isSelected()) {
            return "Fin";
        }
        return "B";
    }
}

