/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.ddl.DDLFormat;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.export.wizard.ExportWizArb;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAPI {
    private static final long serialVersionUID = 1L;
    private static String _fName = null;
    private static Connection _conn = null;
    private static String _cName = null;
    private static DDLFormat _ddlFormat = null;
    private static DDLTypes _ddlType = null;
    private static ArrayList<URL> _objectList = null;
    private static HashMap<URL, String> _dataList = null;
    private static String _encode = null;
    private static String _EOL;
    private static boolean _cancel;
    private String lineSep = "-----------------------------------------------------------------" + this.getTerm();
    private static ExportAPI INSTANCE;
    private static String badSetup;
    private boolean _open;
    private SqlNode _exp;
    OutputStreamWriter _out;
    DelayedProgressRunnable dpr;

    public ExportAPI() {
        INSTANCE = this;
    }

    public ExportAPI(String string, Connection connection, DDLFormat dDLFormat, DDLTypes dDLTypes, ArrayList<URL> arrayList, HashMap<URL, String> hashMap) {
        _fName = string;
        _conn = connection;
        _cName = Connections.getDisplayName(Connections.getInstance().getConnectionName(_conn));
        _ddlFormat = dDLFormat;
        _ddlType = dDLTypes;
        _objectList = arrayList;
        _dataList = hashMap;
        INSTANCE = this;
    }

    public void setupApi(String string, Connection connection, DDLFormat dDLFormat, DDLTypes dDLTypes, ArrayList<URL> arrayList, HashMap<URL, String> hashMap) {
        _fName = string;
        _conn = connection;
        _cName = Connections.getDisplayName(Connections.getInstance().getConnectionName(_conn));
        _ddlFormat = dDLFormat;
        _ddlType = dDLTypes;
        _objectList = arrayList;
        _dataList = hashMap;
    }

    public ExportAPI getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportAPI();
        }
        return INSTANCE;
    }

    private boolean checkSetup() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        if (_fName == null) {
            stringBuilder.append(ExportWizArb.getString(73) + this.getTerm());
            bl = false;
        }
        if (_conn == null) {
            stringBuilder.append(ExportWizArb.getString(74) + this.getTerm());
            bl = false;
        }
        if (_ddlFormat == null) {
            stringBuilder.append(ExportWizArb.getString(75) + this.getTerm());
            bl = false;
        }
        if (_ddlType == null) {
            stringBuilder.append(ExportWizArb.getString(76) + this.getTerm());
            bl = false;
        }
        badSetup = stringBuilder.toString();
        return bl;
    }

    private ArrayList<URL> getTypeList(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : _objectList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    private String getTerm() {
        if (_EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            _EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return _EOL;
    }

    public String getSummary() {
        StringBuilder stringBuilder;
        block89: {
            ArrayList<URL> arrayList;
            if (!this.checkSetup()) {
                return badSetup;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("Export Summary");
            stringBuilder.append(this.getTerm());
            stringBuilder.append(this.getTerm());
            stringBuilder.append(ExportWizArb.getString(2) + _fName + this.getTerm());
            stringBuilder.append(this.lineSep);
            stringBuilder.append(ExportWizArb.getString(3) + _cName + this.getTerm());
            stringBuilder.append(this.lineSep);
            stringBuilder.append(ExportWizArb.getString(50) + this.getTerm());
            if (_ddlFormat.getSchema()) {
                stringBuilder.append("\t" + ExportWizArb.getString(12) + this.getTerm());
            }
            if (_ddlFormat.getSegments()) {
                stringBuilder.append("\t" + ExportWizArb.getString(13) + this.getTerm());
            }
            if (_ddlFormat.getTerminator()) {
                stringBuilder.append("\t" + ExportWizArb.getString(14) + this.getTerm());
            }
            if (_ddlFormat.getPretty()) {
                stringBuilder.append("\t" + ExportWizArb.getString(15) + this.getTerm());
            }
            if (_ddlFormat.getByte()) {
                stringBuilder.append("\t" + ExportWizArb.getString(16) + this.getTerm());
            }
            if (_ddlFormat.getForce()) {
                stringBuilder.append("\t" + ExportWizArb.getString(17) + this.getTerm());
            }
            if (_ddlFormat.getDrop()) {
                stringBuilder.append("\t" + ExportWizArb.getString(19) + this.getTerm());
            }
            if (_ddlFormat.getDep()) {
                stringBuilder.append("\t" + ExportWizArb.getString(35) + this.getTerm());
            }
            stringBuilder.append(this.lineSep);
            if (_ddlType.getTable()) {
                if (_ddlType.getTableDeps()) {
                    stringBuilder.append(ExportWizArb.getString(51) + this.getTerm());
                } else {
                    stringBuilder.append(ExportWizArb.getString(33) + this.getTerm());
                }
                arrayList = this.getTypeList("TABLE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(52) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getView()) {
                stringBuilder.append(ExportWizArb.getString(41) + this.getTerm());
                arrayList = this.getTypeList("VIEW");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(53) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getIndex()) {
                stringBuilder.append(ExportWizArb.getString(31) + this.getTerm());
                arrayList = this.getTypeList("INDEX");
                ArrayList<URL> arrayList2 = this.getTypeList("TABLE");
                if (arrayList.size() == 0 && arrayList2.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(59) + this.getTerm());
                } else if (arrayList.size() == 0 && arrayList2.size() > 0) {
                    for (URL uRL : arrayList2) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getPackSpec()) {
                stringBuilder.append(ExportWizArb.getString(39) + this.getTerm());
                arrayList = this.getTypeList("PACKAGE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(55) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getPackBody()) {
                stringBuilder.append(ExportWizArb.getString(38) + this.getTerm());
                arrayList = this.getTypeList("PACKAGE BODY");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(56) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getProcedure()) {
                stringBuilder.append(ExportWizArb.getString(36) + this.getTerm());
                arrayList = this.getTypeList("PROCEDURE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(57) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getFunction()) {
                stringBuilder.append(ExportWizArb.getString(40) + this.getTerm());
                arrayList = this.getTypeList("FUNCTION");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(58) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getTrigger()) {
                stringBuilder.append(ExportWizArb.getString(42) + this.getTerm());
                arrayList = this.getTypeList("TRIGGER");
                ArrayList<URL> arrayList3 = this.getTypeList("TABLE");
                if (arrayList.size() == 0 && arrayList3.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(59) + this.getTerm());
                } else if (arrayList.size() == 0 && arrayList3.size() > 0) {
                    for (URL uRL : arrayList3) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getType()) {
                stringBuilder.append(ExportWizArb.getString(32) + this.getTerm());
                arrayList = this.getTypeList("TYPE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(60) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getSequence()) {
                stringBuilder.append(ExportWizArb.getString(37) + this.getTerm());
                arrayList = this.getTypeList("SEQUENCE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(61) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getMatView()) {
                stringBuilder.append(ExportWizArb.getString(28) + this.getTerm());
                arrayList = this.getTypeList("MATERIALIZED VIEW");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(62) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getMatViewLog()) {
                stringBuilder.append(ExportWizArb.getString(25) + this.getTerm());
                arrayList = this.getTypeList("MATERIALIZED VIEW LOG");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(63) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getSynonymn()) {
                stringBuilder.append(ExportWizArb.getString(27) + this.getTerm());
                arrayList = this.getTypeList("SYNONYM");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(64) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getQueue()) {
                stringBuilder.append(ExportWizArb.getString(43) + this.getTerm());
                arrayList = this.getTypeList("QUEUE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(66) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getQueueTable()) {
                stringBuilder.append(ExportWizArb.getString(44) + this.getTerm());
                arrayList = this.getTypeList("QUEUE TABLE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(67) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (_ddlType.getDbLink()) {
                stringBuilder.append(ExportWizArb.getString(26) + this.getTerm());
                arrayList = this.getTypeList("DATABASE LINK");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(65) + this.getTerm());
                } else {
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
                stringBuilder.append(this.lineSep);
            }
            if (!_ddlType.getData()) break block89;
            if (_dataList.size() == 0) {
                arrayList = this.getTypeList("TABLE");
                if (arrayList.size() == 0) {
                    stringBuilder.append(ExportWizArb.getString(69) + this.getTerm());
                } else {
                    stringBuilder.append(ExportWizArb.getString(70) + this.getTerm());
                    for (URL uRL : arrayList) {
                        stringBuilder.append("\t" + DBURLFormatHelper.getName(uRL) + this.getTerm());
                    }
                }
            } else {
                stringBuilder.append(ExportWizArb.getString(71) + this.getTerm());
                for (URL uRL : _dataList.keySet()) {
                    try {
                        if (uRL == null) continue;
                        DBObject dBObject = new DBObject(uRL);
                        stringBuilder.append(ExportWizArb.getString(33));
                        stringBuilder.append(" " + dBObject.getObjectName() + this.getTerm());
                        stringBuilder.append(ExportWizArb.getString(72));
                        stringBuilder.append(" " + _dataList.get(uRL) + this.getTerm());
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                        stringBuilder.append("Error unable to evaluate URL to Object." + uRL.toString() + this.getTerm());
                    }
                }
            }
        }
        return stringBuilder.toString();
    }

    public void writeExport(String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(_fName);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        this._out = new OutputStreamWriter((OutputStream)bufferedOutputStream, string);
        this.writeExport();
        this._out.flush();
        this._out.close();
        ((OutputStream)bufferedOutputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    private void write(String string) {
        try {
            this._out.write(string);
            this._out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void cancelExport() {
        _cancel = true;
    }

    private String getDropScript() {
        if (!this.checkSetup()) {
            return badSetup;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (_ddlFormat.getDrop()) {
            LinkedHashMap<String, String> linkedHashMap = _ddlType.getDropTypes();
            ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
            try {
                String string = _conn.getMetaData().getUserName();
                for (String string2 : linkedHashMap.keySet()) {
                    String string3 = linkedHashMap.get(string2);
                    ArrayList<DBObject> arrayList2 = DDLGenerator.getInstance().getSchemaObjects(_conn, string, string2, string3);
                    ArrayList<URL> arrayList3 = this.getTypeList(string2);
                    if (arrayList2 == null) continue;
                    if (arrayList3.size() == 0) {
                        for (DBObject dBObject : arrayList2) {
                            arrayList.add(dBObject);
                        }
                        continue;
                    }
                    for (URL uRL : arrayList3) {
                        DBObject dBObject = new DBObject(uRL);
                        arrayList.add(dBObject);
                    }
                }
            }
            catch (SQLException sQLException) {
                stringBuilder.append("/*ERROR" + this.getTerm() + sQLException.getMessage() + this.getTerm() + "*/" + this.getTerm());
            }
            for (Object object : arrayList) {
                String string2;
                if (_cancel) break;
                string2 = "\"" + ((DBObject)object).getObjectName() + "\"";
                if (_ddlFormat.getSchema()) {
                    string2 = "\"" + ((DBObject)object).getSchemaName() + "\"." + "\"" + ((DBObject)object).getObjectName() + "\"";
                }
                if (((DBObject)object).getObjectType().equals("MATERIALIZED VIEW LOG")) {
                    stringBuilder.append("  DROP " + ((DBObject)object).getObjectType() + " on " + string2 + ";" + this.getTerm());
                    continue;
                }
                if (((DBObject)object).getObjectType().equals("TABLE")) {
                    stringBuilder.append("  DROP " + ((DBObject)object).getObjectType() + " " + string2 + " cascade constraints;" + this.getTerm());
                    continue;
                }
                if (((DBObject)object).getObjectType().equals("QUEUE")) {
                    stringBuilder.append("begin" + _EOL + "DBMS_AQADM.DROP_QUEUE(queue_name=>'" + ((DBObject)object).getObjectName() + "', auto_commit=>TRUE);" + _EOL + "end;" + _EOL);
                    continue;
                }
                if (((DBObject)object).getObjectType().equals("QUEUE TABLE")) {
                    stringBuilder.append("begin" + _EOL + "DBMS_AQADM.DROP_QUEUE_TABLE(queue_table=>'" + ((DBObject)object).getObjectName() + "', force=>TRUE);" + _EOL + "end;" + _EOL);
                    continue;
                }
                stringBuilder.append("  DROP " + ((DBObject)object).getObjectType() + " " + string2 + ";" + this.getTerm());
            }
        }
        return stringBuilder.toString();
    }

    private void setProg(String string) {
        if (this.dpr != null) {
            this.dpr.getProgressPanel().setMessage(string);
        }
    }

    public String getExport() throws Exception {
        ArrayList<DBObject> arrayList;
        Object object2;
        String string;
        if (!this.checkSetup()) {
            return badSetup;
        }
        _cancel = false;
        StringBuilder stringBuilder = new StringBuilder();
        if (_fName.equals("")) {
            return null;
        }
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        dDLGenerator.setFormating(_ddlFormat);
        String string2 = _conn.getMetaData().getUserName();
        LinkedHashMap<String, String> linkedHashMap = _ddlType.getTypes();
        ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
        Date date = new Date();
        stringBuilder.append("--------------------------------------------------------" + this.getTerm());
        stringBuilder.append("--  File created - " + simpleDateFormat.format(date) + "   " + this.getTerm());
        stringBuilder.append("--------------------------------------------------------" + this.getTerm());
        String string3 = Connections.getInstance().getConnectionName(_conn);
        for (String object3 : linkedHashMap.keySet()) {
            DBObject dBObject;
            URL uRL;
            URL uRL2;
            string = linkedHashMap.get(object3);
            if (object3.equals("DATA") && _dataList.size() > 0) {
                for (URL uRL3 : _dataList.keySet()) {
                    if (uRL3 == null) continue;
                    object2 = new DBObject(uRL3);
                    uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object2).getSchemaName(), "DATA");
                    uRL = DBURLFormatHelper.getURL(uRL2, ((DBObject)object2).getObjectName());
                    arrayList2.add(new DBObject(uRL));
                }
                continue;
            }
            if (object3.equals("DATA") && _dataList.size() == 0 && this.getTypeList("TABLE").size() > 0) {
                arrayList = this.getTypeList("TABLE");
                Iterator<URL> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object2 = new DBObject(iterator.next());
                    uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object2).getSchemaName(), object3);
                    uRL = DBURLFormatHelper.getURL(uRL2, ((DBObject)object2).getObjectName());
                    dBObject = new DBObject(uRL);
                    arrayList2.add(dBObject);
                }
                continue;
            }
            if ((object3.equals("CONSTRAINT") || object3.equals("REFCONSTRAINT")) && this.getTypeList("TABLE").size() > 0) {
                arrayList = this.getTypeList("TABLE");
                Iterator<URL> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object2 = new DBObject(iterator.next());
                    uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object2).getSchemaName(), object3);
                    uRL = DBURLFormatHelper.getURL(uRL2, ((DBObject)object2).getObjectName());
                    dBObject = new DBObject(uRL);
                    arrayList2.add(dBObject);
                }
                continue;
            }
            if (this.getTypeList(object3).size() > 0) {
                arrayList = this.getTypeList(object3);
                Iterator<URL> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object2 = new DBObject(iterator.next());
                    arrayList2.add((DBObject)object2);
                }
                continue;
            }
            arrayList = DDLGenerator.getInstance().getSchemaObjects(_conn, string2, object3, string);
            if (arrayList == null) continue;
            for (Object object2 : arrayList) {
                arrayList2.add((DBObject)object2);
            }
        }
        stringBuilder.append(this.getDropScript());
        for (DBObject dBObject : arrayList2) {
            this.setProg(dBObject.getObjectName());
            if (_cancel) {
                stringBuilder.append(" ----------------------------" + this.getTerm());
                stringBuilder.append(" -- EXPORT TERMINATED BY USER" + this.getTerm());
                stringBuilder.append(" ----------------------------" + this.getTerm());
                break;
            }
            if (dBObject.getObjectType().equals("DATA") && _dataList.size() > 0) {
                string = dBObject.getURL().toString();
                string = string.replace("DATA", "TABLE");
                arrayList = new URL(string);
                String string4 = _dataList.get(arrayList);
                try {
                    object2 = dDLGenerator.getScriptDDL(dBObject, string4);
                    if (!_ddlFormat.getSchema()) {
                        object2 = ((String)object2).replace("\"" + dBObject.getSchemaName() + "\".", "");
                    }
                    stringBuilder.append((String)object2);
                }
                catch (Exception exception) {}
                continue;
            }
            if (dBObject.getObjectType().equals("TABLE") && _ddlType.getTableDeps()) {
                stringBuilder.append(this.getTerm() + "--------------------------------------------------------" + this.getTerm());
                stringBuilder.append("--  DDL for Table " + dBObject.getObjectName() + this.getTerm());
                stringBuilder.append("--------------------------------------------------------" + this.getTerm());
                string = dDLGenerator.getDDL(dBObject, "DEP");
                if (_ddlFormat.getGrant()) {
                    string = string + dDLGenerator.getGrants(dBObject);
                }
                if (!_ddlFormat.getSchema()) {
                    string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
                }
                stringBuilder.append(string + _EOL);
                continue;
            }
            try {
                string = dDLGenerator.getScriptDDL(dBObject);
                string = string.trim();
                if (_ddlFormat.getTerminator() && string.lastIndexOf("/") == string.length() - 1) {
                    arrayList = string.substring(0, string.lastIndexOf("/"));
                    string = (String)((Object)arrayList) + this.getTerm() + "/" + this.getTerm();
                }
                if (_ddlFormat.getGrant()) {
                    string = string + dDLGenerator.getGrants(dBObject);
                }
                if (!_ddlFormat.getSchema()) {
                    string = dBObject.getObjectType().equals("QUEUE TABLE") || dBObject.getObjectType().equals("QUEUE") ? string.replaceAll("'" + dBObject.getSchemaName() + ".", "'") : string.replace("\"" + dBObject.getSchemaName() + "\".", "");
                }
                stringBuilder.append(string + _EOL);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<DBObject> getObjectDeps(Connection connection, String string, String string2, String string3) {
        ArrayList<DBObject> arrayList;
        block13: {
            String string4 = "\tselect referenced_owner, referenced_name, referenced_type from ALL_DEPENDENCIES where owner = :OWNER and name = :NAME and type = decode(:TYPE,'QUEUE','UNDEFINED',:TYPE) and referenced_owner != 'SYS'  union  select b.owner, b.table_name,'TABLE' type from ALL_CONSTRAINTS a, all_constraints b  where a.owner = :OWNER  and a.table_name = :NAME  and a.constraint_type = 'R'  and a.r_constraint_name = b.constraint_name  and a.owner = b.owner  and :TYPE='TABLE'  union  select log_owner,master,'TABLE' from all_snapshot_logs where master = :NAME and :TYPE='MATERIALIZED VIEW LOG'  union  select table_owner owner,table_name name,  case (select count(*) from all_objects where object_name = table_name) when 1 then 'TABLE'  when 2 then 'MATERIALIZED VIEW'  else 'UNKNOWN'  end as type  from all_indexes where index_name = :NAME and owner = :OWNER and :TYPE = 'INDEX' ";
            arrayList = new ArrayList<DBObject>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSet resultSet = null;
            hashMap.put("OWNER", string);
            hashMap.put("NAME", string2);
            hashMap.put("TYPE", string3);
            resultSet = DBUtil.getInstance().executeQuery(connection, string4, hashMap);
            String string5 = Connections.getInstance().getConnectionName(connection);
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string5, null, resultSet.getString(1), resultSet.getString(3));
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(2));
                arrayList.add(new DBObject(uRL));
            }
            Object var13_13 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block13;
                }
                catch (Exception exception2) {}
            }
            break block13;
            {
                catch (Exception exception) {
                    Object var13_14 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        try {
                            resultSet.close();
                            break block13;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<DBObject> getTriggerFilter(Connection connection, String string, String string2) {
        ArrayList<DBObject> arrayList;
        block13: {
            String string3 = "Select trigger_name from all_triggers where table_owner = :OWNER and table_name = :NAME";
            arrayList = new ArrayList<DBObject>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSet resultSet = null;
            hashMap.put("OWNER", string);
            hashMap.put("NAME", string2);
            resultSet = DBUtil.getInstance().executeQuery(connection, string3, hashMap);
            String string4 = Connections.getInstance().getConnectionName(connection);
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, "TRIGGER");
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                arrayList.add(new DBObject(uRL));
            }
            Object var12_12 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block13;
                }
                catch (Exception exception2) {}
            }
            break block13;
            {
                catch (Exception exception) {
                    Object var12_13 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        try {
                            resultSet.close();
                            break block13;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ArrayList<DBObject> getIndexFilter(Connection connection, String string, String string2) {
        ArrayList<DBObject> arrayList;
        block13: {
            String string3 = "Select index_name from all_indexes where table_owner = :OWNER and table_name = :NAME";
            arrayList = new ArrayList<DBObject>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            URL uRL = null;
            ResultSet resultSet = null;
            hashMap.put("OWNER", string);
            hashMap.put("NAME", string2);
            resultSet = DBUtil.getInstance().executeQuery(connection, string3, hashMap);
            String string4 = Connections.getInstance().getConnectionName(connection);
            while (resultSet.next()) {
                URL uRL2 = DBURLFormatHelper.getURL("sqldev.nav", string4, null, string, "INDEX");
                uRL = DBURLFormatHelper.getURL(uRL2, resultSet.getString(1));
                arrayList.add(new DBObject(uRL));
            }
            Object var12_12 = null;
            try {
                resultSet.getStatement().close();
                resultSet.close();
            }
            catch (Exception exception) {
                try {
                    resultSet.close();
                    break block13;
                }
                catch (Exception exception2) {}
            }
            break block13;
            {
                catch (Exception exception) {
                    Object var12_13 = null;
                    try {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    catch (Exception exception3) {
                        try {
                            resultSet.close();
                            break block13;
                        }
                        catch (Exception exception4) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    resultSet.getStatement().close();
                    resultSet.close();
                }
                catch (Exception exception) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception5) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return arrayList;
    }

    private ArrayList<DBObject> addDependents(ArrayList<DBObject> arrayList, DBObject dBObject) {
        ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
        if (!_ddlFormat.getDep()) {
            return arrayList2;
        }
        if (_objectList.size() == 0) {
            return arrayList2;
        }
        ArrayList<DBObject> arrayList3 = this.getObjectDeps(_conn, dBObject.getSchemaName(), dBObject.getObjectName(), dBObject.getObjectType());
        for (DBObject dBObject2 : arrayList3) {
            boolean bl = true;
            for (DBObject dBObject3 : arrayList) {
                if (!dBObject3.getObjectName().equals(dBObject2.getObjectName()) || !dBObject3.getObjectType().equals(dBObject2.getObjectType()) || !dBObject3.getSchemaName().equals(dBObject2.getSchemaName())) continue;
                bl = false;
            }
            if (!bl) continue;
            arrayList2.add(dBObject2);
        }
        return arrayList2;
    }

    private boolean shouldAdd(ArrayList<DBObject> arrayList, DBObject dBObject) {
        for (DBObject dBObject2 : arrayList) {
            if (!dBObject2.getObjectName().equals(dBObject.getObjectName()) || !dBObject2.getObjectType().equals(dBObject.getObjectType()) || !dBObject2.getSchemaName().equals(dBObject.getSchemaName())) continue;
            return false;
        }
        return true;
    }

    private void writeExport() throws Exception {
        ArrayList<DBObject> arrayList;
        Object object4;
        String string;
        if (!this.checkSetup()) {
            this.write(badSetup);
        }
        _cancel = false;
        if (_fName.equals("")) {
            return;
        }
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        dDLGenerator.setFormating(_ddlFormat);
        String string2 = _conn.getMetaData().getUserName();
        LinkedHashMap<String, String> linkedHashMap = _ddlType.getTypes();
        ArrayList<DBObject> arrayList2 = new ArrayList<DBObject>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE-MMMM-dd-yyyy");
        Date date = new Date();
        this.write("--------------------------------------------------------" + this.getTerm());
        this.write("--  File created - " + simpleDateFormat.format(date) + "   " + this.getTerm());
        this.write("--------------------------------------------------------" + this.getTerm());
        String string3 = Connections.getInstance().getConnectionName(_conn);
        for (String object3 : linkedHashMap.keySet()) {
            ArrayList<DBObject> arrayList3;
            DBObject dBObject;
            Object object2;
            Serializable serializable;
            string = linkedHashMap.get(object3);
            if (object3.equals("DATA") && _dataList.size() > 0) {
                for (URL uRL : _dataList.keySet()) {
                    if (uRL == null) continue;
                    object4 = new DBObject(uRL);
                    serializable = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object4).getSchemaName(), "DATA");
                    object2 = DBURLFormatHelper.getURL((URL)serializable, ((DBObject)object4).getObjectName());
                    arrayList2.add(new DBObject((URL)object2));
                }
                continue;
            }
            if (object3.equals("DATA") && _dataList.size() == 0 && this.getTypeList("TABLE").size() > 0) {
                arrayList = this.getTypeList("TABLE");
                Iterator<URL> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object4 = new DBObject(iterator.next());
                    serializable = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object4).getSchemaName(), object3);
                    object2 = DBURLFormatHelper.getURL((URL)serializable, ((DBObject)object4).getObjectName());
                    dBObject = new DBObject((URL)object2);
                    arrayList2.add(dBObject);
                }
                continue;
            }
            if ((object3.equals("CONSTRAINT") || object3.equals("REFCONSTRAINT")) && this.getTypeList("TABLE").size() > 0) {
                arrayList = this.getTypeList("TABLE");
                Iterator<URL> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object4 = new DBObject(iterator.next());
                    serializable = DBURLFormatHelper.getURL("sqldev.nav", string3, null, ((DBObject)object4).getSchemaName(), object3);
                    object2 = DBURLFormatHelper.getURL((URL)serializable, ((DBObject)object4).getObjectName());
                    dBObject = new DBObject((URL)object2);
                    if (!this.shouldAdd(arrayList2, dBObject)) continue;
                    arrayList2.add(dBObject);
                }
                continue;
            }
            if (object3.equals("TRIGGER") && this.getTypeList("TABLE").size() > 0 && this.getTypeList("TRIGGER").size() == 0) {
                arrayList = this.getTypeList("TABLE");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object4 = new DBObject((URL)iterator.next());
                    serializable = this.getTriggerFilter(_conn, ((DBObject)object4).getSchemaName(), ((DBObject)object4).getObjectName());
                    object2 = ((ArrayList)serializable).iterator();
                    while (object2.hasNext()) {
                        dBObject = (DBObject)object2.next();
                        if (this.shouldAdd(arrayList2, dBObject)) {
                            arrayList2.add(dBObject);
                        }
                        if ((arrayList3 = this.addDependents(arrayList2, dBObject)).size() <= 0) continue;
                        arrayList2.addAll(arrayList2.size() - 1, arrayList3);
                    }
                }
                continue;
            }
            if (object3.equals("INDEX") && this.getTypeList("TABLE").size() > 0 && this.getTypeList("INDEX").size() == 0) {
                arrayList = this.getTypeList("TABLE");
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object4 = new DBObject((URL)iterator.next());
                    serializable = this.getIndexFilter(_conn, ((DBObject)object4).getSchemaName(), ((DBObject)object4).getObjectName());
                    object2 = ((ArrayList)serializable).iterator();
                    while (object2.hasNext()) {
                        dBObject = (DBObject)object2.next();
                        if (this.shouldAdd(arrayList2, dBObject)) {
                            arrayList2.add(dBObject);
                        }
                        if ((arrayList3 = this.addDependents(arrayList2, dBObject)).size() <= 0) continue;
                        arrayList2.addAll(arrayList2.size() - 1, arrayList3);
                    }
                }
                continue;
            }
            if (this.getTypeList(object3).size() > 0) {
                arrayList = this.getTypeList(object3);
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    object4 = new DBObject((URL)iterator.next());
                    if (this.shouldAdd(arrayList2, (DBObject)object4)) {
                        arrayList2.add((DBObject)object4);
                    }
                    if ((arrayList3 = this.addDependents(arrayList2, (DBObject)object4)).size() <= 0) continue;
                    arrayList2.addAll(arrayList2.size() - 1, arrayList3);
                }
                continue;
            }
            arrayList = DDLGenerator.getInstance().getSchemaObjects(_conn, string2, object3, string);
            if (arrayList == null) continue;
            for (Object object4 : arrayList) {
                if (this.shouldAdd(arrayList2, (DBObject)object4)) {
                    arrayList2.add((DBObject)object4);
                }
                if ((arrayList3 = this.addDependents(arrayList2, (DBObject)object4)).size() <= 0) continue;
                arrayList2.addAll(arrayList2.size() - 1, arrayList3);
            }
        }
        this.write(this.getDropScript());
        for (DBObject dBObject : arrayList2) {
            this.setProg(dBObject.getObjectName());
            if (_cancel) {
                this.write(" ----------------------------" + this.getTerm());
                this.write(" -- EXPORT TERMINATED BY USER" + this.getTerm());
                this.write(" ----------------------------" + this.getTerm());
                break;
            }
            if (dBObject.getObjectType().equals("DATA") && _dataList.size() > 0) {
                string = dBObject.getURL().toString();
                string = string.replace("DATA", "TABLE");
                arrayList = new URL(string);
                String string4 = _dataList.get(arrayList);
                try {
                    dDLGenerator.setWriter(this._out);
                    object4 = dDLGenerator.getScriptDDL(dBObject, string4);
                    if (!_ddlFormat.getSchema()) {
                        object4 = ((String)object4).replace("\"" + dBObject.getSchemaName() + "\".", "");
                    }
                    this.write((String)object4);
                }
                catch (Exception exception) {}
                continue;
            }
            if (dBObject.getObjectType().equals("TABLE") && _ddlType.getTableDeps()) {
                this.write(this.getTerm() + "--------------------------------------------------------" + this.getTerm());
                this.write("--  DDL for Table " + dBObject.getObjectName() + this.getTerm());
                this.write("--------------------------------------------------------" + this.getTerm());
                string = dDLGenerator.getDDL(dBObject, "DEP");
                if (_ddlFormat.getGrant()) {
                    string = string + dDLGenerator.getGrants(dBObject);
                }
                if (!_ddlFormat.getSchema()) {
                    string = string.replace("\"" + dBObject.getSchemaName() + "\".", "");
                }
                this.write(string + _EOL);
                continue;
            }
            try {
                dDLGenerator.setWriter(this._out);
                string = dDLGenerator.getScriptDDL(dBObject);
                string = string.trim();
                if (_ddlFormat.getTerminator() && string.lastIndexOf("/") == string.length() - 1) {
                    arrayList = string.substring(0, string.lastIndexOf("/"));
                    string = (String)((Object)arrayList) + this.getTerm() + "/" + this.getTerm();
                }
                if (_ddlFormat.getGrant()) {
                    string = string + dDLGenerator.getGrants(dBObject);
                }
                if (!_ddlFormat.getSchema()) {
                    string = dBObject.getObjectType().equals("QUEUE TABLE") || dBObject.getObjectType().equals("QUEUE") ? string.replaceAll("'" + dBObject.getSchemaName() + ".", "'") : string.replace("\"" + dBObject.getSchemaName() + "\".", "");
                }
                this.write(string + _EOL);
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void writeExportWithDialog(String string) {
        this.writeExportWithDialog(string, false);
    }

    public void writeExportWithDialog(String string, boolean bl) {
        _encode = string;
        this._open = bl;
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

            public void cancel() {
                _cancel = true;
            }

            public Object doWork() {
                Object var1_1 = null;
                try {
                    ExportAPI.this.writeExport(_encode);
                }
                catch (Exception exception) {
                    try {
                        ExportAPI.this._out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, exception.getStackTrace()[0].toString(), exception);
                }
                if (ExportAPI.this._open) {
                    File file = new File(_fName);
                    try {
                        URL uRL = file.toURL();
                        ExportAPI.this._exp = new SqlNode(uRL);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                Context context = Context.newIdeContext((Node)ExportAPI.this._exp);
                                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                                openEditorOptions.setFlags(1);
                                EditorManager.getEditorManager().openEditor(openEditorOptions);
                            }
                        });
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
                return var1_1;
            }

            public void finish(Object object) {
            }

            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ExportAPI.this.dpr = new DelayedProgressRunnable("Exporting", null, 500, iDelayedProgressRunnable, new JLabel());
                ((JLabel)ExportAPI.this.dpr.getDetailComponent()).setText(ExportWizArb.getString(77));
                ExportAPI.this.dpr.setCancellable(true);
                ExportAPI.this.dpr.start();
            }
        });
    }

    static {
        _cancel = false;
        INSTANCE = null;
        badSetup = null;
    }
}

