/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.utils.SpringUtilities;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.UIUtils;

public class ExportOptions
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JCheckBox _schema;
    private JCheckBox _segments;
    private JCheckBox _terminiator;
    private JCheckBox _pretty;
    private JCheckBox _byte;
    private JCheckBox _force;
    private JCheckBox _alter;
    private JCheckBox _drop;

    public ExportOptions() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createCheckBoxes(), "Center");
    }

    private JPanel createCheckBoxes() {
        JPanel jPanel = new JPanel(new SpringLayout());
        this._schema = new JCheckBox(Translate.translate((String)"Show Schema"));
        this._schema.setMnemonic(new Integer(83));
        this._segments = new JCheckBox(Translate.translate((String)"Storage"));
        this._segments.setMnemonic(new Integer(71));
        this._terminiator = new JCheckBox(Translate.translate((String)"Terminator"));
        this._terminiator.setMnemonic(new Integer(84));
        this._pretty = new JCheckBox(Translate.translate((String)"Pretty Print"));
        this._pretty.setMnemonic(new Integer(80));
        this._byte = new JCheckBox(Translate.translate((String)"Include BYTE keyword"));
        this._byte.setMnemonic(new Integer(73));
        this._force = new JCheckBox(Translate.translate((String)"Add Force to Views"));
        this._force.setMnemonic(new Integer(70));
        this._alter = new JCheckBox(Translate.translate((String)"Constraints as alters "));
        this._alter.setMnemonic(new Integer(67));
        this._drop = new JCheckBox(Translate.translate((String)"Include Drop Statement"));
        this._drop.setMnemonic(new Integer(68));
        this._schema.setSelected(true);
        this._segments.setSelected(false);
        this._terminiator.setSelected(true);
        this._pretty.setSelected(true);
        this._byte.setSelected(false);
        this._force.setSelected(false);
        this._alter.setSelected(false);
        this._drop.setSelected(false);
        jPanel.add(this._schema);
        jPanel.add(this._segments);
        jPanel.add(this._terminiator);
        jPanel.add(this._pretty);
        jPanel.add(this._byte);
        jPanel.add(this._force);
        jPanel.add(this._drop);
        UIUtils.makeTitledBorder(jPanel, "Options");
        SpringUtilities.makeCompactGrid(jPanel, 7, 1, 0, 0, 0, 5);
        return jPanel;
    }

    public boolean getSchema() {
        return this._schema.isSelected();
    }

    public boolean getSegments() {
        return this._segments.isSelected();
    }

    public boolean getPretty() {
        return this._pretty.isSelected();
    }

    public boolean getTerminator() {
        return this._terminiator.isSelected();
    }

    public boolean getByte() {
        return this._byte.isSelected();
    }

    public boolean getForce() {
        return this._force.isSelected();
    }

    public boolean getAlter() {
        return this._alter.isSelected();
    }

    public boolean getDrop() {
        return this._drop.isSelected();
    }

    public void setSchema(boolean bl) {
        this._schema.setSelected(bl);
    }

    public void setSegments(boolean bl) {
        this._segments.setSelected(bl);
    }

    public void setPretty(boolean bl) {
        this._pretty.setSelected(bl);
    }

    public void setTerminator(boolean bl) {
        this._terminiator.setSelected(bl);
    }

    public void setByte(boolean bl) {
        this._byte.setSelected(bl);
    }

    public void setForce(boolean bl) {
        this._force.setSelected(bl);
    }

    public void setAlter(boolean bl) {
        this._alter.setSelected(bl);
    }

    public void setDrop(boolean bl) {
        this._drop.setSelected(bl);
    }

    public void setDefault() {
        this._schema.setSelected(true);
        this._segments.setSelected(false);
        this._terminiator.setSelected(true);
        this._pretty.setSelected(true);
        this._byte.setSelected(false);
        this._force.setSelected(false);
        this._alter.setSelected(false);
        this._drop.setSelected(false);
    }
}

