/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.export.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.raptor.controls.DBObjectSearch;
import oracle.dbtools.raptor.controls.URLListRenderer;
import oracle.dbtools.raptor.ddl.DDLTypes;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectObjectPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane1 = new JScrollPane();
    private DBObjectSearch jList;
    private JButton addOne = new JButton();
    private JButton remOne = new JButton();
    private JButton addAll = new JButton();
    private JButton remAll = new JButton();
    private JList _tableList;
    private DefaultListModel _model;
    private JComboBox typeSelect = new JComboBox();
    ArrayList<URL> _oList = null;
    private String _conn;
    private DDLTypes _ddlTypes = null;

    public ArrayList<URL> getUrlList() {
        return this._oList;
    }

    public void setDDLTypes(DDLTypes dDLTypes) {
        this._ddlTypes = dDLTypes;
        this.jList.setType(this._ddlTypes.getAllTypes());
        this.setTypeList();
    }

    public void setConName(String string) {
        this._conn = string;
        this.jList.setConn(this._conn);
    }

    public void setList(ArrayList<URL> arrayList) {
        this._oList = arrayList != null ? arrayList : new ArrayList();
        this.loadFilterList(this._oList);
    }

    public void updatePanel() {
        this.jList.init();
    }

    public ArrayList<URL> getAdvListType(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (URL uRL : this._oList) {
            if (uRL == null || !DBURLFormatHelper.getBaseType(uRL).equals(string)) continue;
            arrayList.add(uRL);
        }
        return arrayList;
    }

    public void addToList(ArrayList<URL> arrayList) {
        for (URL uRL : arrayList) {
            if (this._oList.contains(uRL)) continue;
            this._oList.add(uRL);
        }
    }

    public void remFromList(URL uRL) {
        if (this._oList.contains(uRL)) {
            this._oList.remove(uRL);
        }
    }

    public void resetList() {
        this._oList = new ArrayList();
    }

    private void loadFilterList(ArrayList<URL> arrayList) {
        ((DefaultListModel)this._tableList.getModel()).clear();
        for (URL uRL : arrayList) {
            if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
            ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeList() {
        try {
            this.typeSelect.removeAllItems();
            Object var2_1 = null;
            this.typeSelect.addItem("All");
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.typeSelect.addItem("All");
            for (String string : this._ddlTypes.getTypeList()) {
                this.typeSelect.addItem(string);
            }
            throw throwable;
        }
        for (String string : this._ddlTypes.getTypeList()) {
            this.typeSelect.addItem(string);
        }
    }

    public ArrayList<URL> getList() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        DefaultListModel defaultListModel = (DefaultListModel)this._tableList.getModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.size(); ++i) {
                URL uRL = (URL)defaultListModel.get(i);
                arrayList.add(uRL);
            }
        }
        return arrayList;
    }

    public JPanel getPanel() {
        this._model = new DefaultListModel();
        this._tableList = new JList(this._model);
        this._tableList.setCellRenderer(new URLListRenderer());
        this._tableList.setDragEnabled(false);
        this._tableList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = SelectObjectPanel.this._tableList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ((DefaultListModel)SelectObjectPanel.this._tableList.getModel()).removeElement(uRL);
                        SelectObjectPanel.this._oList.remove(uRL);
                    }
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.jList = new DBObjectSearch();
        this.jList.getList().addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getClickCount();
                if (n == 2) {
                    Object[] objectArray = SelectObjectPanel.this.jList.getList().getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        if (((DefaultListModel)SelectObjectPanel.this._tableList.getModel()).indexOf(uRL) != -1) continue;
                        ((DefaultListModel)SelectObjectPanel.this._tableList.getModel()).addElement(uRL);
                    }
                    SelectObjectPanel.this.addToList(SelectObjectPanel.this.getList());
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.typeSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    String string = (String)SelectObjectPanel.this.typeSelect.getSelectedItem();
                    if (string != null && !string.equals("All")) {
                        SelectObjectPanel.this.jList.setType(string.replace("_", " "));
                        ArrayList<URL> arrayList = SelectObjectPanel.this.getAdvListType(string);
                        SelectObjectPanel.this.loadFilterList(arrayList);
                    } else {
                        SelectObjectPanel.this.jList.setType(SelectObjectPanel.this._ddlTypes.getAllTypes());
                        if (SelectObjectPanel.this._oList != null) {
                            SelectObjectPanel.this.loadFilterList(SelectObjectPanel.this._oList);
                        }
                    }
                    SelectObjectPanel.this.jList.clear();
                }
            }
        });
        this.addAll.setActionCommand(">>");
        this.addAll.setIcon(RaptorImage.getIcon((String)"last_ena.png"));
        this.addAll.addActionListener(this);
        this.addOne.setActionCommand(">");
        this.addOne.setIcon(RaptorImage.getIcon((String)"next_ena.png"));
        this.addOne.addActionListener(this);
        this.remAll.setActionCommand("<<");
        this.remAll.setIcon(RaptorImage.getIcon((String)"first_ena.png"));
        this.remAll.addActionListener(this);
        this.remOne.setActionCommand("<");
        this.remOne.setIcon(RaptorImage.getIcon((String)"prev_ena.png"));
        this.remOne.addActionListener(this);
        this.jScrollPane1.setViewportView(this._tableList);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.jList, new GridBagConstraints(0, 0, 2, 6, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.addOne, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.addAll, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.remOne, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.remAll, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.typeSelect, new GridBagConstraints(3, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(3, 1, 2, 5, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (!actionEvent.getActionCommand().equals(">")) break block4;
                        Object[] objectArray = this.jList.getList().getSelectedValues();
                        for (int i = 0; i < objectArray.length; ++i) {
                            URL uRL = (URL)objectArray[i];
                            if (((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                            ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
                        }
                        this.addToList(this.getList());
                        break block5;
                    }
                    if (!actionEvent.getActionCommand().equals("<")) break block6;
                    Object[] objectArray = this._tableList.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        URL uRL = (URL)objectArray[i];
                        ((DefaultListModel)this._tableList.getModel()).removeElement(uRL);
                        this.remFromList(uRL);
                    }
                    break block5;
                }
                if (!actionEvent.getActionCommand().equals(">>")) break block7;
                DefaultListModel defaultListModel = (DefaultListModel)this.jList.getList().getModel();
                Object[] objectArray = new Object[defaultListModel.size() + 1];
                defaultListModel.copyInto(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    URL uRL = (URL)objectArray[i];
                    if (uRL == null || ((DefaultListModel)this._tableList.getModel()).indexOf(uRL) != -1) continue;
                    ((DefaultListModel)this._tableList.getModel()).addElement(uRL);
                }
                this.addToList(this.getList());
                break block5;
            }
            if (!actionEvent.getActionCommand().equals("<<")) break block5;
            Object[] objectArray = ((DefaultListModel)this._tableList.getModel()).toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                URL uRL = (URL)objectArray[i];
                ((DefaultListModel)this._tableList.getModel()).removeElement(uRL);
                this.remFromList(uRL);
            }
        }
    }
}

