/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import oracle.dbtools.raptor.controls.ResultSetTable;
import oracle.dbtools.raptor.dialogs.actions.TableExportAction;
import oracle.dbtools.raptor.format.FormatRegistry;
import oracle.dbtools.raptor.format.IResultFormatter;
import oracle.dbtools.raptor.format.InsertFormatter;
import oracle.dbtools.raptor.navigator.IViewerNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Element;
import oracle.ide.model.Node;

public class ExportContextMenuListener
implements ContextMenuListener {
    private static final String RESULTS_TABLE = "RESULTS_TABLE";
    private JMenu _menu;
    private TableExportAction _action = new TableExportAction();
    private static ExportContextMenuListener _instance;
    private static final Object LOCK;

    private ExportContextMenuListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExportContextMenuListener getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new ExportContextMenuListener();
            }
        }
        return _instance;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (!TableExportAction.isExportInProgress()) {
            DBObject dBObject;
            String string = null;
            Node node = contextMenu.getContext().getNode();
            if (node instanceof IViewerNode) {
                node = ((IViewerNode)node).getBaseNode();
            }
            boolean bl = true;
            if (node instanceof DatabaseNode) {
                dBObject = new DBObject((Element)node);
                if ("TABLE".equals(dBObject.getObjectType()) || "VIEW".equals(dBObject.getObjectType()) || "MATERIALIZED VIEW".equals(dBObject.getObjectType())) {
                    this._action.setDBObject(dBObject);
                    this._action.setConn(dBObject.getConnection());
                } else {
                    bl = false;
                }
                string = dBObject.getConnectionName();
            } else if (contextMenu.getContext().getEvent().getSource() instanceof ResultSetTable) {
                this._action.setTable((JTable)contextMenu.getContext().getEvent().getSource());
                string = this._action.getConnName();
            } else if (contextMenu.getContext().getProperty(RESULTS_TABLE) != null && contextMenu.getContext().getProperty(RESULTS_TABLE) instanceof ResultSetTable) {
                this._action.setTable((JTable)contextMenu.getContext().getProperty(RESULTS_TABLE));
                string = this._action.getConnName();
            } else {
                bl = false;
            }
            if (bl) {
                dBObject = FormatRegistry.getFormatter((String)"INSERT");
                if (string != null && dBObject != null && !Connections.getInstance().isOracle(string)) {
                    this._menu = null;
                    FormatRegistry.unregisterFormater((IResultFormatter)dBObject);
                } else if (dBObject == null) {
                    this._menu = null;
                    FormatRegistry.registerFormater((IResultFormatter)new InsertFormatter());
                }
                contextMenu.addSeparator();
                contextMenu.add((Component)this.getMenu());
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        if (context.getNode() instanceof DatabaseNode) {
            this._action.launchDlg();
            return true;
        }
        return false;
    }

    public JMenu getMenu() {
        if (this._menu == null) {
            this._menu = new JMenu("Export Data");
            List list = FormatRegistry.getTypes();
            for (String string : list) {
                JMenuItem jMenuItem = new JMenuItem(string);
                jMenuItem.setActionCommand(string);
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ExportContextMenuListener.this._action.setArgs(actionEvent.getActionCommand());
                        if (ExportContextMenuListener.this._action.getDBObject() != null) {
                            ExportContextMenuListener.this._action.launch();
                        } else {
                            ExportContextMenuListener.this._action.launchDlg();
                        }
                    }
                });
                this._menu.add(jMenuItem);
            }
        }
        return this._menu;
    }

    static {
        LOCK = new Object();
    }
}

