/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format.ui;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.raptor.utils.Translate;

public final class TableFormatterWrapper
extends ResultsFormatterWrapper {
    private TableModel m_model;
    private TableColumnModel m_cols;
    private transient boolean m_interrupted;

    private static ResultSetTableModel getBaseModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            tableModel = ((TableSorter)tableModel).getTableModel();
        }
        return tableModel instanceof ResultSetTableModel ? (ResultSetTableModel)tableModel : null;
    }

    public TableFormatterWrapper(JTable jTable) {
        this.m_model = jTable.getModel();
        this.m_cols = jTable.getColumnModel();
        ResultSetTableModel resultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        int n = this.m_model.getColumnCount();
        int[] nArray = new int[n];
        ArrayList<String> arrayList = new ArrayList<String>(n);
        if (resultSetTableModel != null) {
            nArray[0] = 25;
        }
        for (int i = 0; i < n; ++i) {
            String string = this.m_model.getColumnName(i);
            int n2 = string.length();
            if (resultSetTableModel != null) {
                if (resultSetTableModel.getTypes().length >= n) {
                    int n3 = resultSetTableModel.getTypes()[i];
                    nArray[i] = n3 == 91 || n3 == 92 || n3 == 93 ? 25 : Math.max(resultSetTableModel.getColSizes()[i], n2);
                }
            } else {
                nArray[i] = string.length();
            }
            arrayList.add(string);
        }
        this.setColumnNames(arrayList);
        this.setColumnSizes(nArray);
    }

    public TableModel getModel() {
        return this.m_model;
    }

    public void interrupt() {
        this.m_interrupted = true;
    }

    public Connection getConnection() {
        if (this.m_model instanceof ResultSetTableModel) {
            return ((ResultSetTableModel)this.m_model).getConnection();
        }
        return null;
    }

    public int getDataType(int n) {
        ResultSetTableModel resultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        return resultSetTableModel != null ? resultSetTableModel.getType(n - 1) : 0;
    }

    public int print() throws IOException {
        TableFormatterWrapper.fetchAllRows(this.m_model);
        if (this.m_model instanceof ResultSetTableModel) {
            while (!((ResultSetTableModel)this.m_model).getAllFetched()) {
            }
        }
        int n = this.m_model.getRowCount();
        this.m_formatter.start();
        for (int i = 0; i < n && !this.isInterrupted(); ++i) {
            this.m_formatter.log(Translate.translate((String)("Row:" + i)));
            this.m_formatter.startRow();
            for (int j = 0; j < this.m_cols.getColumnCount(); ++j) {
                this.m_formatter.printColumn(this.m_model.getValueAt(i, this.m_cols.getColumn(j).getModelIndex()), j + 1, this.m_cols.getColumn(j).getModelIndex());
            }
            this.m_formatter.endRow();
        }
        this.m_formatter.end();
        return this.m_model.getRowCount();
    }

    private static void fetchAllRows(TableModel tableModel) {
        ResultSetTableModel resultSetTableModel = TableFormatterWrapper.getBaseModel(tableModel);
        if (resultSetTableModel != null) {
            boolean bl = resultSetTableModel.getThreaded();
            resultSetTableModel.setThreaded(false);
            resultSetTableModel.fetchAll();
            resultSetTableModel.setThreaded(bl);
        }
    }

    public String getSQL() {
        ResultSetTableModel resultSetTableModel = TableFormatterWrapper.getBaseModel(this.m_model);
        return resultSetTableModel != null ? resultSetTableModel.getSQL() : null;
    }
}

