/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.dbtools.parser.CYK;
import oracle.dbtools.parser.CodeCompleter;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Token;
import oracle.dbtools.proformatter.ConfigProFormat;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.insight.DBListInsightData;
import oracle.dbtools.raptor.insight.DatabaseInsightAddin;
import oracle.dbtools.raptor.insight.IdentifiersDb;
import oracle.dbtools.raptor.insight.InsightableOracleDatabase;
import oracle.dbtools.raptor.insight.SuggestedItem;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.util.Util;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.Database;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.insight.AbstractInsight;
import oracle.javatools.editor.insight.Insight;
import oracle.javatools.editor.insight.InsightData;
import oracle.javatools.editor.insight.InsightProvider;
import oracle.javatools.editor.insight.InsightView;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.editor.insight.ListInsightView;
import oracle.javatools.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompletionInsight
extends AbstractInsight
implements InsightProvider {
    public static final boolean trace = false;
    public static final boolean timing = true;
    private ListInsightView _view = new ListInsightView();
    private DBListInsightData _lastLookup;
    private String _connName;
    int startCaretPosition;
    int lastCaretPosition;
    private BackgroundParser parser = null;
    boolean raiselimit = false;
    private int origDelay = -1;

    public CompletionInsight(Context context, Database database) {
        Node node = context.getNode();
        if (node instanceof PlSqlNode && ((PlSqlNode)context.getNode()).getConnectionName() != null) {
            this._connName = ((PlSqlNode)node).getConnectionName();
            this.parser = ((PlSqlNode)node).parser;
        } else if (node instanceof PlSqlNode) {
            this._connName = DBURLFormatHelper.getConnectionName(context.getNode().getURL());
            this.parser = ((PlSqlNode)node).parser;
        } else if (context.getView() instanceof IDBEditor) {
            this._connName = ((IDBEditor)context.getView()).getConnectionName();
        }
    }

    public CompletionInsight(Context context) {
        this(context, null);
    }

    protected InsightProvider createInsightProvider() {
        return this;
    }

    public void characterTyped(BasicEditorPane basicEditorPane, int n, char c) {
        TextBuffer textBuffer;
        int n2;
        if (this.origDelay == -1) {
            this.origDelay = basicEditorPane.getIntegerProperty("completion-popup-delay");
        }
        if (2000 <= (n2 = (textBuffer = this.getTextBuffer()).getLength()) && n2 < 10000) {
            basicEditorPane.putIntegerProperty("completion-popup-delay", this.origDelay * 2);
        } else if (10000 <= n2) {
            basicEditorPane.putIntegerProperty("completion-popup-delay", this.origDelay * 3);
        }
        super.characterTyped(basicEditorPane, n, c);
    }

    public boolean isInsightTriggerChar(char c) {
        return c != ';';
    }

    protected boolean isAutomaticPartialComplete(InsightData insightData) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InsightData getInsightData(BasicEditorPane basicEditorPane) {
        int n;
        TextBuffer textBuffer = this.getTextBuffer();
        this.lastCaretPosition = this.startCaretPosition = this.getCaretPosition();
        int n2 = 1000;
        int n3 = this.startCaretPosition - 1000;
        int n4 = this.startCaretPosition + 1000;
        if (this.startCaretPosition < 1000) {
            n2 = this.startCaretPosition;
            n3 = 0;
        }
        if ((n = textBuffer.getLength()) < n4) {
            n4 = n;
        }
        String string = textBuffer.getString(n3, n4 - n3);
        LinkedList<LexerToken> linkedList = LexerToken.parse(string, true);
        try {
            boolean bl;
            int n5;
            CodeCompleter codeCompleter;
            Set<SuggestedItem> set;
            LexerToken lexerToken;
            String string2;
            CodeCompleter codeCompleter2 = new CodeCompleter();
            codeCompleter2.fragment = new ArrayList<LexerToken>();
            int n6 = this.filterOutComments(n2, linkedList, codeCompleter2.fragment);
            if (n6 == -1) {
                return null;
            }
            if (n6 == -2) {
                string2 = string.substring(0, n2) + '\"' + string.substring(n2);
                linkedList = LexerToken.parse(string2, true);
                codeCompleter2.fragment = new ArrayList<LexerToken>();
                n6 = this.filterOutComments(n2, linkedList, codeCompleter2.fragment);
            }
            if (codeCompleter2.fragment.size() < 2) {
                return null;
            }
            string2 = "";
            LexerToken lexerToken2 = lexerToken = n6 < codeCompleter2.fragment.size() ? codeCompleter2.fragment.get(n6) : null;
            if (lexerToken != null && (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) && lexerToken.begin < n2 && n2 < lexerToken.end) {
                string2 = lexerToken.content.substring(0, n2 - lexerToken.begin);
                this.startCaretPosition -= string2.length();
                LexerToken lexerToken3 = codeCompleter2.fragment.get(n6);
                lexerToken3.content = string2;
                codeCompleter2.fragment.add(n6 + 1, new LexerToken("?aux token1?", -2, -1, Token.AUXILIARY));
            } else if (lexerToken != null && (lexerToken.type == Token.IDENTIFIER || lexerToken.type == Token.DQUOTED_STRING) && n2 == lexerToken.end) {
                string2 = lexerToken.content.substring(0, n2 - lexerToken.begin);
                this.startCaretPosition -= string2.length();
                codeCompleter2.fragment.remove(n6);
                codeCompleter2.fragment.add(n6, new LexerToken("?aux tok1?", -2, -1, Token.AUXILIARY));
                codeCompleter2.fragment.add(n6 + 1, new LexerToken("?aux tok2?", -4, -3, Token.AUXILIARY));
                codeCompleter2.fragment.add(n6 + 2, new LexerToken("?aux tok3?", -6, -5, Token.AUXILIARY));
            } else {
                codeCompleter2.fragment.add(n6, new LexerToken("?aux t1?", -2, -1, Token.AUXILIARY));
                codeCompleter2.fragment.add(n6 + 1, new LexerToken("?aux t2?", -4, -3, Token.AUXILIARY));
                codeCompleter2.fragment.add(n6 + 2, new LexerToken("?aux t3?", -6, -5, Token.AUXILIARY));
            }
            boolean bl2 = true;
            boolean bl3 = true;
            bl2 = CompletionInsight.decideIdCase(codeCompleter2.fragment, string2, n6);
            bl3 = CompletionInsight.decideKwCase(codeCompleter2.fragment, string2);
            if (!string2.startsWith("\"")) {
                string2 = string2.toUpperCase();
            }
            codeCompleter2.matrix = CYK.initArray1(codeCompleter2.fragment);
            int n7 = n6;
            if (n7 < codeCompleter2.fragment.size()) {
                codeCompleter2.matrix.put(Util.pair((int)n7, (int)(n7 + 1)), CYK.toArray(CodeCompleter.allKeywordsPlusId(string2)));
            }
            if (++n7 < codeCompleter2.fragment.size() && codeCompleter2.fragment.get((int)n7).type == Token.AUXILIARY) {
                codeCompleter2.matrix.put(Util.pair((int)n7, (int)(n7 + 1)), CYK.toArray(CodeCompleter.allKeywordsPlusId()));
            }
            if (++n7 < codeCompleter2.fragment.size() && codeCompleter2.fragment.get((int)n7).type == Token.AUXILIARY) {
                codeCompleter2.matrix.put(Util.pair((int)n7, (int)(n7 + 1)), CYK.toArray(CodeCompleter.allSymbols()));
            }
            codeCompleter2.evaluate(n6);
            ArrayList<CodeCompleter> arrayList = new ArrayList<CodeCompleter>();
            arrayList.add(codeCompleter2);
            CodeCompleter codeCompleter3 = codeCompleter2;
            int n8 = 0;
            while (codeCompleter2.fragment.size() > n6 && string2.length() == 0 && codeCompleter2.fragment.get((int)n6).type == Token.AUXILIARY || codeCompleter2.fragment.size() > n6 + 1 && string2.length() > 0 && codeCompleter2.fragment.get((int)n6).type == Token.AUXILIARY && codeCompleter2.fragment.get((int)(n6 + 1)).type == Token.AUXILIARY) {
                codeCompleter2 = new CodeCompleter();
                codeCompleter2.fragment = codeCompleter3.fragment;
                codeCompleter2.matrix = codeCompleter3.matrix;
                codeCompleter2.reduce(n6);
                int n9 = 0;
                Iterator iterator = arrayList.iterator();
                if (iterator.hasNext()) {
                    set = (CodeCompleter)iterator.next();
                    n9 = ((CodeCompleter)((Object)set)).weightedLength(n6);
                }
                if (n9 < codeCompleter2.weightedLength(n6) + 1) {
                    arrayList.clear();
                    arrayList.add(codeCompleter2);
                } else if (codeCompleter3.weightedLength(n6) == codeCompleter2.weightedLength(n6) + 1) {
                    arrayList.add(codeCompleter2);
                }
                codeCompleter3 = codeCompleter2;
                ++n8;
            }
            if (string2.length() == 0 && arrayList.size() == 1) {
                for (CodeCompleter codeCompleter4 : arrayList) {
                    if (codeCompleter4.weightedLength(n6) != codeCompleter3.weightedLength(n6)) continue;
                    return null;
                }
            } else if (string2.length() == 0 && arrayList.size() > 1 && (codeCompleter = (CodeCompleter)arrayList.get(arrayList.size() - 1)).weightedLength(n6) == codeCompleter3.weightedLength(n6)) {
                arrayList.remove(arrayList.size() - 1);
            }
            if (Util.Y((int)(n5 = CodeCompleter.maxCover(((CodeCompleter)arrayList.get((int)0)).root, n6))) <= Util.X((int)n5) + (string2.length() == 0 ? 4 : 2)) {
                return null;
            }
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (CodeCompleter codeCompleter5 : arrayList) {
                treeSet.addAll(codeCompleter5.symbols);
            }
            set = this.suggestedKeywords(treeSet, string2);
            set.addAll(this.suggestedSnippets(treeSet, string2));
            InsightableOracleDatabase insightableOracleDatabase = new InsightableOracleDatabase(this._connName);
            if (this.raiselimit) {
                insightableOracleDatabase.limit = 1000;
            }
            block5: for (CodeCompleter codeCompleter6 : arrayList) {
                void var32_75;
                CharSequence charSequence;
                Object object;
                Object object2;
                Object object32;
                Object object4;
                Object object52;
                boolean bl4 = false;
                boolean bl5 = false;
                bl = false;
                boolean bl6 = false;
                Object object6 = codeCompleter6.symbols.iterator();
                while (object6.hasNext()) {
                    int n10 = object6.next();
                    object52 = CodeCompleter.startingSymbols(n10);
                    if (object52.contains(IdentifiersDb.instance.sim_expr)) {
                        bl5 = true;
                    }
                    if (object52.contains(IdentifiersDb.instance.name) || object52.contains(IdentifiersDb.instance.column_name)) {
                        bl4 = true;
                    }
                    if (object52.contains(IdentifiersDb.instance.prm_spec_ty_mk) || object52.contains(IdentifiersDb.instance.object_d_rhs)) {
                        bl = true;
                    }
                    if (!object52.contains(IdentifiersDb.instance.name) && !object52.contains(IdentifiersDb.instance.table_reference_or_subquery)) continue;
                    bl6 = true;
                }
                if (bl) {
                    if ("VARCHAR2".startsWith(string2)) {
                        set.add(new SuggestedItem("KEYWORD", null, "VARCHAR2"));
                    }
                    if ("NUMBER".startsWith(string2)) {
                        set.add(new SuggestedItem("KEYWORD", null, "NUMBER"));
                    }
                    if ("INTEGER".startsWith(string2)) {
                        set.add(new SuggestedItem("KEYWORD", null, "INTEGER"));
                    }
                }
                if (bl6 && string2.length() > 0) {
                    insightableOracleDatabase.prepareAllSchemas(string2);
                }
                if (codeCompleter6.symbols.contains(IdentifiersDb.instance.cmpon_asc)) {
                    object6 = codeCompleter6.root.parent(n6, n6 + 1);
                    if (((ParseNode)object6).contains(IdentifiersDb.instance.cmpon_asc)) {
                        object6 = codeCompleter6.root.parent(((ParseNode)object6).from, ((ParseNode)object6).to);
                    }
                    if (((ParseNode)object6).contains(IdentifiersDb.instance.aggr)) {
                        ParseNode parseNode = codeCompleter6.root.parent(((ParseNode)object6).from, ((ParseNode)object6).to);
                        for (ParseNode parseNode2 : parseNode.children()) {
                            if (parseNode2.equals(object6)) continue;
                            object4 = codeCompleter6.fragment.get((int)(parseNode2.to - 1)).content.toUpperCase();
                            object32 = null;
                            if (parseNode2.from + 2 < parseNode2.to) {
                                object32 = codeCompleter6.fragment.get((int)(parseNode2.to - 3)).content.toUpperCase();
                            }
                            insightableOracleDatabase.prepareArgumentsProc((String)object32, (String)object4);
                        }
                    }
                }
                if (codeCompleter6.symbols.contains(IdentifiersDb.instance.table_reference_or_subquery) || codeCompleter6.symbols.contains(IdentifiersDb.instance.link_expanded_n_optional_partition)) {
                    if (string2.length() == 0) {
                        insightableOracleDatabase.prepareUserTables();
                        continue;
                    }
                    insightableOracleDatabase.prepareAllTables(null, string2);
                    continue;
                }
                if (bl5 || bl4) {
                    object6 = this.getIdentifierDefs(Util.pair((int)n6, (int)(n6 + 1)), codeCompleter6.root);
                    TreeMap<ParseNode, ParseNode> treeMap = new TreeMap<ParseNode, ParseNode>();
                    object52 = object6.iterator();
                    while (object52.hasNext()) {
                        ParseNode parseNode = object52.next();
                        object4 = CompletionInsight.findTableAlias(parseNode);
                        if (object4 != null) {
                            treeMap.put((ParseNode)((Pair)object4).first, (ParseNode)((Pair)object4).second);
                            continue;
                        }
                        if (set == null || parseNode.contains(IdentifiersDb.instance.from_table_reference_or_subquery) || (object32 = this.createDatabaseDataItem(codeCompleter6.fragment, codeCompleter6.root, parseNode)) == null) continue;
                        set.add((SuggestedItem)object32);
                    }
                    if (this.parser != null && this.parser.src != null) {
                        int n11;
                        for (n11 = 0; n11 < this.parser.src.size() && this.startCaretPosition >= this.parser.src.get((int)n11).end; ++n11) {
                        }
                        List<ParseNode> list = this.getIdentifierDefs(Util.pair((int)n11, (int)(n11 + 1)), this.parser.output);
                        for (Object object32 : list) {
                            object2 = this.parser.src.get(((ParseNode)object32).from);
                            if (!((LexerToken)object2).content.toUpperCase().startsWith(string2) || set == null || (object = this.createDatabaseDataItem(this.parser.src, this.parser.output, (ParseNode)object32)) == null) continue;
                            set.add((SuggestedItem)object);
                        }
                    }
                    object52 = new ArrayList();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (Object object32 : treeMap.keySet()) {
                        object2 = codeCompleter6.fragment.get(((ParseNode)object32).from);
                        if (!((LexerToken)object2).content.toUpperCase().startsWith(string2.toUpperCase())) {
                            object52.add((ParseNode)((Object)((ParseNode)treeMap.get(object32)).content(codeCompleter6.fragment)));
                            continue;
                        }
                        arrayList2.add(((ParseNode)treeMap.get(object32)).content(codeCompleter6.fragment));
                    }
                    insightableOracleDatabase.setTableAliases(this.mapString2String(codeCompleter6, treeMap));
                    insightableOracleDatabase.prepareColumns((List<String>)object52, (List<String>)arrayList2, string2);
                    if (string2.length() <= 0) continue;
                    insightableOracleDatabase.prepareAllProcedures(!bl5, null, string2);
                    continue;
                }
                if (!codeCompleter6.symbols.contains(IdentifiersDb.instance.identifier)) continue;
                object6 = codeCompleter6.root.parent(n6, n6 + 1);
                if (object6 != null && ((ParseNode)object6).contains(IdentifiersDb.instance.from_table_reference_or_subquery)) {
                    for (Object object52 : ((ParseNode)object6).children()) {
                        if (!((ParseNode)object52).contains(IdentifiersDb.instance.expanded_n)) continue;
                        String string3 = codeCompleter6.fragment.get((int)((ParseNode)object52).from).content.toUpperCase();
                        object4 = string2.length() > 0 ? string2 : null;
                        insightableOracleDatabase.prepareAllTables(string3, (String)object4);
                        continue block5;
                    }
                    continue;
                }
                if (object6 == null || !((ParseNode)object6).contains(IdentifiersDb.instance.selected_cmpon)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                for (ParseNode parseNode : ((ParseNode)object6).children()) {
                    if (parseNode.from == n6) continue;
                    for (int i = parseNode.from; i < parseNode.to - 1; ++i) {
                        stringBuffer.append(codeCompleter6.fragment.get((int)i).content);
                    }
                }
                object52 = this.getIdentifierDefs(Util.pair((int)n6, (int)(n6 + 1)), codeCompleter6.root);
                Object var32_74 = null;
                object4 = new StringBuffer();
                object32 = object52.iterator();
                while (object32.hasNext()) {
                    int n12;
                    object2 = (ParseNode)object32.next();
                    Pair<ParseNode, ParseNode> pair = CompletionInsight.findTableAlias((ParseNode)object2);
                    if (pair == null) continue;
                    object = codeCompleter6.fragment.get(((ParseNode)pair.first).from);
                    if (!((LexerToken)object).content.toUpperCase().startsWith(stringBuffer.toString().toUpperCase())) continue;
                    charSequence = new StringBuffer();
                    for (n12 = ((ParseNode)pair.first).from; n12 < ((ParseNode)pair.first).to; ++n12) {
                        ((StringBuffer)charSequence).append(codeCompleter6.fragment.get((int)n12).content);
                    }
                    if (!((StringBuffer)charSequence).toString().equalsIgnoreCase(stringBuffer.toString())) {
                        Object var32_77 = null;
                        object4 = new StringBuffer();
                        continue;
                    }
                    for (n12 = ((ParseNode)pair.second).from; n12 < ((ParseNode)pair.second).to; ++n12) {
                        ((StringBuffer)object4).append(codeCompleter6.fragment.get((int)n12).content);
                    }
                }
                if (var32_75 != null) {
                    object32 = new TreeMap<Object, Object>();
                    object32.put(var32_75.first, var32_75.second);
                    insightableOracleDatabase.setTableAliases(this.mapString2String(codeCompleter6, (Map<ParseNode, ParseNode>)object32));
                    insightableOracleDatabase.prepareColumns(((StringBuffer)object4).toString(), string2);
                    continue;
                }
                if (object6 == null || !((ParseNode)object6).contains(IdentifiersDb.instance.procedure_call)) continue;
                object32 = ((ParseNode)object6).descendants().iterator();
                while (object32.hasNext()) {
                    object2 = (ParseNode)object32.next();
                    if (!((ParseNode)object2).contains(IdentifiersDb.instance.name)) continue;
                    object = codeCompleter6.fragment.get((int)((ParseNode)object2).from).content.toUpperCase();
                    charSequence = string2.length() > 0 ? string2 : null;
                    insightableOracleDatabase.prepareAllProcedures(false, (String)object, (String)charSequence);
                    insightableOracleDatabase.prepareAllPkgProc(null, (String)object, (String)charSequence);
                    continue block5;
                }
            }
            if (insightableOracleDatabase.isPrepared()) {
                set.addAll(insightableOracleDatabase.fetch());
            }
            this.raiselimit = false;
            if (set.size() == 1) {
                for (SuggestedItem suggestedItem : set) {
                    if (!string2.equalsIgnoreCase(suggestedItem.getName())) continue;
                    return null;
                }
            }
            SuggestedItem[] suggestedItemArray = new SuggestedItem[set.size()];
            boolean bl7 = false;
            for (SuggestedItem suggestedItem : set) {
                bl = false;
                if (suggestedItem.isKeyword() && bl3) {
                    bl = true;
                } else if (!suggestedItem.isKeyword() && bl2) {
                    bl = true;
                }
                suggestedItemArray[++var24_46] = new SuggestedItem(suggestedItem, bl);
            }
            this._lastLookup = new DBListInsightData(this);
            this._lastLookup.setData(suggestedItemArray);
            return this._lastLookup;
        }
        catch (Throwable throwable) {
            Object var40_19 = null;
            throw throwable;
        }
    }

    private Map<String, String> mapString2String(CodeCompleter codeCompleter, Map<ParseNode, ParseNode> map) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (ParseNode parseNode : map.keySet()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = parseNode.from; i < parseNode.to; ++i) {
                stringBuffer.append(codeCompleter.fragment.get((int)i).content);
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            ParseNode parseNode2 = map.get(parseNode);
            for (int i = parseNode2.from; i < parseNode2.to; ++i) {
                stringBuffer2.append(codeCompleter.fragment.get((int)i).content);
            }
            treeMap.put(stringBuffer.toString(), stringBuffer2.toString());
        }
        return treeMap;
    }

    private Set<SuggestedItem> suggestedKeywords(Set<Integer> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        for (int n : set) {
            Set<String> set2 = CodeCompleter.startingKeywords(n);
            if (set2 == null) continue;
            for (String string2 : set2) {
                Object object;
                if (string2.equals(string)) {
                    object = CYK.rules;
                    int n2 = ((CYK.ChomskiTuple[])object).length;
                    for (int i = 0; i < n2; ++i) {
                        SuggestedItem suggestedItem;
                        CYK.ChomskiTuple chomskiTuple = object[i];
                        if (chomskiTuple.head != n || chomskiTuple.rhs1 < 0) continue;
                        String string3 = CYK.allSymbols[chomskiTuple.rhs0];
                        String string4 = CYK.allSymbols[chomskiTuple.rhs1];
                        if (string3.charAt(0) != '\'' || string4.charAt(0) != '\'' || !string3.substring(1, string3.length() - 1).equals(string) || treeSet.contains(suggestedItem = new SuggestedItem("KEYWORD", null, string2 + ' ' + string4.substring(1, string4.length() - 1)))) continue;
                        treeSet.add(suggestedItem);
                    }
                    continue;
                }
                if (!string2.startsWith(string) || treeSet.contains(object = new SuggestedItem("KEYWORD", null, string2))) continue;
                treeSet.add((SuggestedItem)object);
            }
        }
        if (treeSet.size() > 3) {
            treeSet.clear();
        }
        return treeSet;
    }

    private Set<SuggestedItem> suggestedSnippets(Set<Integer> set, String string) {
        TreeSet<SuggestedItem> treeSet = new TreeSet<SuggestedItem>();
        if (string.length() == 0) {
            return treeSet;
        }
        for (int n : set) {
            for (String string2 : DatabaseInsightAddin.getSnippet(n, string)) {
                SuggestedItem suggestedItem = new SuggestedItem("SNIPPET", null, string2);
                if (treeSet.contains(suggestedItem)) continue;
                treeSet.add(suggestedItem);
            }
        }
        if (treeSet.size() > 4) {
            treeSet.clear();
        }
        return treeSet;
    }

    private int filterOutComments(int n, List<LexerToken> list, List<LexerToken> list2) {
        int n2 = 0;
        int n3 = -1;
        for (LexerToken lexerToken : list) {
            if (!(lexerToken.begin > n || n >= lexerToken.end && lexerToken.end >= 0 || lexerToken.type != Token.COMMENT && lexerToken.type != Token.LINE_COMMENT && lexerToken.type != Token.QUOTED_STRING)) {
                return -1;
            }
            if (n == lexerToken.end && lexerToken.type == Token.LINE_COMMENT) {
                return -1;
            }
            if ((lexerToken.type == Token.IDENTIFIER && lexerToken.begin < n && n <= lexerToken.end || lexerToken.begin <= n && n < lexerToken.end) && n3 == -1) {
                n3 = n2;
            }
            if (lexerToken.type == Token.DQUOTED_STRING && lexerToken.begin < n && n <= lexerToken.end) {
                if (lexerToken.content.toUpperCase().contains("FROM") || lexerToken.content.toUpperCase().contains("WHERE")) {
                    return -2;
                }
                if (n3 == -1) {
                    n3 = n2;
                }
            }
            if (lexerToken.type == Token.WS || lexerToken.type == Token.COMMENT || lexerToken.type == Token.LINE_COMMENT) continue;
            list2.add(lexerToken);
            ++n2;
        }
        if (n3 == -1) {
            n3 = list2.size();
        }
        return n3;
    }

    public static Pair<ParseNode, ParseNode> findTableAlias(ParseNode parseNode) {
        if (!parseNode.contains(IdentifiersDb.instance.table_reference_or_subquery) && !parseNode.contains(IdentifiersDb.instance.from_table_reference_or_subquery)) {
            return null;
        }
        Pair pair = null;
        if (parseNode.children().size() == 0 || parseNode.children().size() == 3) {
            pair = new Pair((Object)parseNode, (Object)parseNode);
        } else if (parseNode.children().size() == 2) {
            ParseNode parseNode2 = null;
            ParseNode parseNode3 = null;
            for (ParseNode parseNode4 : parseNode.children()) {
                if (parseNode4.contains(IdentifiersDb.instance.identifier)) {
                    parseNode2 = parseNode4;
                    continue;
                }
                parseNode3 = parseNode4;
            }
            if (parseNode2 != null && parseNode3 != null) {
                pair = new Pair(parseNode2, parseNode3);
            }
        }
        return pair;
    }

    private SuggestedItem createDatabaseDataItem(List<LexerToken> list, ParseNode parseNode, ParseNode parseNode2) {
        LexerToken lexerToken = list.get(parseNode2.from);
        if (lexerToken.begin > 0) {
            ParseNode parseNode3 = parseNode.parent(parseNode2.from, parseNode2.to);
            if (parseNode3.contains(IdentifiersDb.instance.prm_spec) || parseNode3.contains(IdentifiersDb.instance.object_d)) {
                for (ParseNode parseNode4 : parseNode3.children()) {
                    if (!parseNode4.contains(IdentifiersDb.instance.prm_spec_ty_mk) && !parseNode4.contains(IdentifiersDb.instance.object_d_rhs)) continue;
                    String string = list.get((int)parseNode4.from).content.toUpperCase();
                    return new SuggestedItem(string, null, lexerToken.content);
                }
            }
            if (parseNode3.contains(IdentifiersDb.instance.subprg_spec)) {
                LexerToken lexerToken2 = list.get(parseNode2.from - 1);
                if ("function".equalsIgnoreCase(lexerToken2.content)) {
                    return new SuggestedItem("FUNCTION", null, lexerToken.content);
                }
                if ("procedure".equalsIgnoreCase(lexerToken2.content)) {
                    return new SuggestedItem("PROCEDURE", null, lexerToken.content);
                }
            }
        }
        return null;
    }

    private List<ParseNode> getIdentifierDefs(int n, ParseNode parseNode) {
        ArrayList<ParseNode> arrayList = new ArrayList<ParseNode>();
        Map<ParseNode, Integer> map = IdentifiersDb.instance.collectIdentifiers(parseNode);
        for (ParseNode parseNode2 : map.keySet()) {
            int n2 = Util.X((int)map.get(parseNode2));
            int n3 = Util.Y((int)map.get(parseNode2));
            if (n2 > Util.X((int)n) || n3 < Util.Y((int)n)) continue;
            arrayList.add(0, parseNode2);
        }
        return arrayList;
    }

    public InsightData updateInsightData(BasicEditorPane basicEditorPane, InsightData insightData) {
        int n = this.getCaretPosition();
        if (n != this.lastCaretPosition + 1 && n != this.lastCaretPosition - 1) {
            return null;
        }
        if (n < this.startCaretPosition) {
            return null;
        }
        if (insightData.getMatchingDataCount() == 0) {
            return null;
        }
        if (insightData.getMatchingDataCount() == 1 && ((ListDataItem)insightData.getMatchingData()[0]).getDisplayText().length() == n - this.startCaretPosition) {
            return null;
        }
        this.lastCaretPosition = n;
        return insightData;
    }

    public InsightView getInsightView() {
        return this._view;
    }

    public static void main(String[] stringArray) throws Exception {
        Set<Integer> set = CodeCompleter.startingSymbols(CYK.symbolIndexes.get("cmpon_asc"));
        for (int n : set) {
            System.out.print(" " + CYK.allSymbols[n]);
        }
        String string = "begin dbms_output.put_line(--><--); end;";
        int n = string.indexOf("--><--");
        String string2 = string.replace("--><--", "");
        CompletionInsight completionInsight = new CompletionInsight(null);
    }

    protected boolean handleCompleteCommand(BasicEditorPane basicEditorPane) {
        boolean bl = this._view.complete((Insight)this);
        basicEditorPane.requestFocus();
        return bl;
    }

    private static boolean decideKwCase(List<LexerToken> list, String string) {
        boolean bl = false;
        Preferences preferences = Preferences.getPreferences();
        ConfigProFormat configProFormat = ConfigProFormat.getInstance((PropertyStorage)preferences);
        String string2 = configProFormat.getUCChoiceOpt();
        if (string2.equals("Keywords Uppercase")) {
            bl = true;
        } else if (string2.equals("Whole SQL Uppercase")) {
            bl = true;
        } else if (string2.equals("No Change")) {
            if (string.length() > 0) {
                bl = Character.isUpperCase(string.charAt(0));
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    LexerToken lexerToken = list.get(i);
                    if (lexerToken.type != Token.IDENTIFIER) continue;
                    return Character.isUpperCase(lexerToken.content.charAt(0));
                }
            }
        }
        return bl;
    }

    private static boolean decideIdCase(List<LexerToken> list, String string, int n) {
        boolean bl = false;
        Preferences preferences = Preferences.getPreferences();
        ConfigProFormat configProFormat = ConfigProFormat.getInstance((PropertyStorage)preferences);
        String string2 = configProFormat.getUCChoiceOpt();
        if (string2.equals("Whole SQL Uppercase")) {
            bl = true;
        } else if (string2.equals("No Change")) {
            if (string.length() > 0) {
                bl = Character.isUpperCase(string.charAt(0));
            } else {
                if (n < 2) {
                    return true;
                }
                return Character.isUpperCase(list.get((int)(n - 2)).content.charAt(0));
            }
        }
        return bl;
    }
}

