/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.insight.SuggestedItem;
import oracle.dbtools.raptor.utils.Connections;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsightableOracleDatabase {
    private static final Logger logger = Logger.getLogger(InsightableOracleDatabase.class.getName());
    private String connectionName;
    private StringBuffer query = new StringBuffer();
    private List binds = new ArrayList();
    public int limit = 20;
    private static final String USERNAME_CRITERIA = " and username like ? ";
    private static final String OBJ_TYPE_EQ_PKG = " and object_type = 'PACKAGE' ";
    private static final String OBJ_CRITERIA = " and object_name = ? ";
    private static final String PROCNAME_CRITERIA = " and procedure_name like ? ";
    private static final String OWN_PKG_CRITERIA = " and (o.object_name = ? and a.package_name = ? or o.owner=?) ";
    private static final String STANDALONE_PROC_CRITERIA = " and o.object_name = ? ";
    private static final String PACKAGED_PROC_CRITERIA = " and o.object_name = ? and a.object_name = ? ";
    private boolean prepareUserTablesCalled = false;
    private boolean prepareAllTablesCalled = false;
    private boolean prepareColumnsCalled = false;
    private boolean prepareUserFunctionsCalled = false;
    private boolean prepareAllFunctionsCalled = false;
    private boolean prepareAllSchemasCalled = false;
    private boolean prepareAllPkgProcCalled = false;
    private boolean prepareArgumentsProcCalled = false;
    private Map<String, String> tableAliases = null;
    boolean setTableAliasesCalled = false;

    public InsightableOracleDatabase(String string) {
        this.connectionName = string;
    }

    private int limit() {
        return this.limit;
    }

    private final String queryUserTables() {
        return "SELECT object_type type, user owner, object_name, null column_name \nFROM user_objects \nWHERE \tobject_type ='TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryUserViews() {
        return "SELECT object_type type, user owner, object_name, null column_name \nFROM user_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllTables() {
        return "SELECT object_type type, owner, object_name, null column_name \nFROM all_objects \nWHERE \tobject_type ='TABLE' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String queryAllViews() {
        return "SELECT object_type type, owner, object_name, null column_name \nFROM all_objects \nWHERE \tobject_type ='VIEW' and object_name not like 'BIN$%' and rownum <=" + this.limit() + "\n";
    }

    private final String OBJ_LIKE_CRITERIA() {
        return " and object_name like ? ";
    }

    private final String OWNER_CRITERIA() {
        return " and owner = ? ";
    }

    private final String MIXED_CASE_CRITERIA() {
        return " and REGEXP_INSTR(object_name, '[[:upper:]]')>0 and REGEXP_INSTR(object_name, '[[:lower:]]')>0";
    }

    private final String QUERY_COLUMNS_BY_OWNER_TABLE() {
        return "SELECT 'COLUMN' type, owner, table_name object_name, column_name \nFROM sys.all_tab_columns \nWHERE rownum <=" + this.limit() + " and owner = ? and table_name = ? ";
    }

    private final String QUERY_COLUMNS_BY_TABLE() {
        return "SELECT 'COLUMN' type, owner, table_name object_name, column_name \nFROM sys.all_tab_columns \nWHERE rownum <=" + this.limit() + " and table_name = ? ";
    }

    private final String COLUMN_LIKE_CRITERIA() {
        return " and column_name like ? ";
    }

    private final String queryProcedures(boolean bl, boolean bl2) {
        return "SELECT object_type type, user owner, object_name, null column_name \nFROM " + (bl ? "user" : "all") + "_objects \n" + "WHERE rownum <=" + this.limit() + " and object_name not like 'BIN$%' " + " and object_type IN ('" + (bl2 ? "PROCEDURE" : "FUNCTION") + "', 'PACKAGE') \n";
    }

    private final String QUERY_SCHEMAS() {
        return "SELECT 'SCHEMA' type, username owner, username object_name, null column_name \nFROM all_users WHERE rownum <=" + this.limit() + "\n";
    }

    private final String QUERY_PACKAGED_PROCEDURES() {
        return "SELECT 'FUNCTION' type, owner, procedure_name object_name, null column_name\nFROM all_procedures \nWHERE rownum <=" + this.limit() * 5 + " OBJ_TYPE_EQ_PKG " + " and procedure_name is not null \n";
    }

    private final String QUERY_ARGUMENTS() {
        return "SELECT 'ARGUMENT' type, ''||a.position owner,  a.owner||'.'||a.package_name||'.'||a.object_name||'.'||a.overload object_name,  a.argument_name||' '||a.data_type column_name \nFROM all_arguments a, all_objects o \nWHERE a.object_id=o.object_id and rownum <=" + this.limit() + " and\targument_name is not null \n";
    }

    public void prepareUserTables() {
        if (this.prepareUserTablesCalled) {
            return;
        }
        this.prepareUserTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryUserTables());
        this.query.append("\n union all \n");
        this.query.append(this.queryUserViews());
    }

    public void prepareAllTables(String string, String string2) {
        if (this.prepareAllTablesCalled) {
            return;
        }
        this.prepareAllTablesCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryAllTables());
        if (string2 != null) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(InsightableOracleDatabase.handleMixedCase(string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        if (string != null) {
            this.query.append(this.OWNER_CRITERIA());
            this.binds.add(string);
        }
        this.query.append("\n union all \n");
        this.query.append(this.queryAllViews());
        if (string2 != null) {
            this.query.append(this.OBJ_LIKE_CRITERIA());
            this.binds.add(InsightableOracleDatabase.handleMixedCase(string2) + "%");
            if (string2.startsWith("\"")) {
                this.query.append(this.MIXED_CASE_CRITERIA());
            }
        }
        if (string != null) {
            this.query.append(this.OWNER_CRITERIA());
            this.binds.add(string);
        }
    }

    public void prepareColumns(String string, String string2) {
        if (this.prepareColumnsCalled) {
            return;
        }
        this.prepareColumnsCalled = true;
        if (string.indexOf(46) >= 0) {
            this.prepareFQColumn(string, string2);
        } else {
            this.prepareNQColumn(string, string2);
        }
    }

    public void prepareColumns(List<String> list, List<String> list2, String string) {
        if (this.prepareColumnsCalled) {
            return;
        }
        this.prepareColumnsCalled = true;
        Set<String> set = InsightableOracleDatabase.fullyQualifiedNames(list);
        if (set.size() > 0) {
            this.prepareFQColumns(set, string);
        }
        if ((set = InsightableOracleDatabase.notQualifiedNames(list)).size() > 0) {
            this.prepareNQColumns(set, string);
        }
        if ((set = InsightableOracleDatabase.fullyQualifiedNames(list2)).size() > 0) {
            this.prepareFQColumns(set, "");
        }
        if ((set = InsightableOracleDatabase.notQualifiedNames(list2)).size() > 0) {
            this.prepareNQColumns(set, "");
        }
    }

    public void prepareFQColumn(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(1));
        String string3 = string.substring(0, string.indexOf(46));
        string3 = InsightableOracleDatabase.handleMixedCase(string3);
        this.binds.add(string3);
        String string4 = string.substring(string.indexOf(46) + 1);
        string4 = InsightableOracleDatabase.handleMixedCase(string4);
        this.binds.add(string4);
        if (string2 != null && !"".equals(string2)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(InsightableOracleDatabase.handleMixedCase(string2) + "%");
        }
    }

    public void prepareFQColumns(Set<String> set, String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByOwnerTable(set.size()));
        InsightableOracleDatabase.setFQBinds(set, this.binds);
        if (string != null && !"".equals(string)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(InsightableOracleDatabase.handleMixedCase(string) + "%");
        }
    }

    public void prepareNQColumn(String string, String string2) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByTable(1));
        string = InsightableOracleDatabase.handleMixedCase(string);
        this.binds.add(string);
        if (string2 != null && !"".equals(string2)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(InsightableOracleDatabase.handleMixedCase(string2) + "%");
        }
    }

    public void prepareNQColumns(Set<String> set, String string) {
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryByTable(set.size()));
        InsightableOracleDatabase.setNQBinds(set, this.binds);
        if (string != null && !"".equals(string)) {
            this.query.append(this.COLUMN_LIKE_CRITERIA());
            this.binds.add(InsightableOracleDatabase.handleMixedCase(string) + "%");
        }
    }

    public void prepareUserProcedures(boolean bl) {
        if (this.prepareUserFunctionsCalled) {
            return;
        }
        this.prepareUserFunctionsCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        this.query.append(this.queryProcedures(true, bl));
    }

    public void prepareAllProcedures(boolean bl, String string, String string2) {
        if (this.prepareAllFunctionsCalled) {
            return;
        }
        this.prepareAllFunctionsCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.queryProcedures(false, bl);
        if (string2 != null) {
            string3 = string3 + this.OBJ_LIKE_CRITERIA();
            this.binds.add(string2 + "%");
        }
        if (string != null) {
            string3 = string3 + this.OWNER_CRITERIA();
            this.binds.add(string);
        }
        this.query.append(string3);
    }

    public void prepareAllSchemas(String string) {
        if (this.prepareAllSchemasCalled) {
            return;
        }
        this.prepareAllSchemasCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string2 = this.QUERY_SCHEMAS();
        if (string != null && !"".equals(string)) {
            string2 = string2 + USERNAME_CRITERIA;
            this.binds.add(string + "%");
        }
        this.query.append(string2);
    }

    public void prepareAllPkgProc(String string, String string2, String string3) {
        if (this.prepareAllPkgProcCalled) {
            return;
        }
        this.prepareAllPkgProcCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string4 = this.QUERY_PACKAGED_PROCEDURES();
        if (string != null) {
            string4 = string4 + this.OWNER_CRITERIA();
            this.binds.add(string);
        }
        if (string2 != null) {
            string4 = string4 + OBJ_CRITERIA;
            this.binds.add(string2);
        }
        if (string3 != null) {
            string4 = string4 + PROCNAME_CRITERIA;
            this.binds.add(string3 + "%");
        }
        this.query.append(string4);
    }

    public void prepareArgumentsProc(String string, String string2) {
        if (this.prepareArgumentsProcCalled) {
            return;
        }
        this.prepareArgumentsProcCalled = true;
        if (this.query.length() > 0) {
            this.query.append("\n union all \n");
        }
        String string3 = this.QUERY_ARGUMENTS();
        if (string != null) {
            string3 = string3 + OWN_PKG_CRITERIA;
            this.binds.add(string);
            this.binds.add(string);
            this.binds.add(string);
        }
        if (string2 != null) {
            if (string != null) {
                string3 = string3 + PACKAGED_PROC_CRITERIA;
                this.binds.add(string);
                this.binds.add(string2);
            } else {
                string3 = string3 + STANDALONE_PROC_CRITERIA;
                this.binds.add(string2);
            }
        }
        this.query.append(string3);
    }

    public void setTableAliases(Map<String, String> map) {
        if (this.setTableAliasesCalled) {
            return;
        }
        this.setTableAliasesCalled = true;
        this.tableAliases = map;
    }

    private List<String> translate(String string, String string2, String string3) {
        boolean bl = this.tableAliases.size() > 1;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : this.tableAliases.keySet()) {
            String string5 = this.tableAliases.get(string4);
            if (!string5.equalsIgnoreCase(string + '.' + string2) && !string5.equalsIgnoreCase(string2)) continue;
            String string6 = bl ? string4 + "." + string3 : string3;
            arrayList.add(string6);
        }
        return arrayList;
    }

    public boolean isPrepared() {
        return this.query.length() > 0;
    }

    private static Set<String> fullyQualifiedNames(List<String> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : list) {
            if (string.indexOf(46) < 0) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    private static Set<String> notQualifiedNames(List<String> list) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : list) {
            if (string.indexOf(46) >= 0) continue;
            treeSet.add(string);
        }
        return treeSet;
    }

    private String queryByTable(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append("\n  union all\n");
            }
            stringBuffer.append(this.QUERY_COLUMNS_BY_TABLE());
        }
        return stringBuffer.toString();
    }

    private String queryByOwnerTable(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append("\n  union all\n");
            }
            stringBuffer.append(this.QUERY_COLUMNS_BY_OWNER_TABLE());
        }
        return stringBuffer.toString();
    }

    private static void setFQBinds(Set<String> set, List list) {
        for (String string : set) {
            String string2 = string.substring(0, string.indexOf(46));
            string2 = InsightableOracleDatabase.handleMixedCase(string2);
            list.add(string2);
            String string3 = string.substring(string.indexOf(46) + 1);
            string3 = InsightableOracleDatabase.handleMixedCase(string3);
            list.add(string3);
        }
    }

    private static void setNQBinds(Set<String> set, List list) {
        for (String string : set) {
            string = InsightableOracleDatabase.handleMixedCase(string);
            list.add(string);
        }
    }

    private static String handleMixedCase(String string) {
        if (!string.startsWith("\"")) {
            string = string.toUpperCase();
        } else if ((string = string.substring(1)).endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public Set<SuggestedItem> fetch() {
        String string;
        List<String> list;
        String string2;
        TreeSet<SuggestedItem> treeSet;
        long l;
        block56: {
            SQLException sQLException422;
            Object var18_14;
            ResultSet resultSet;
            Statement statement;
            block54: {
                block53: {
                    Connection connection;
                    block50: {
                        SQLException sQLException2222;
                        TreeSet<SuggestedItem> treeSet2;
                        block51: {
                            Database database;
                            block47: {
                                SQLException sQLException3222;
                                TreeSet<SuggestedItem> treeSet3;
                                block48: {
                                    if (this.query == null || this.query.length() == 0) {
                                        return new TreeSet<SuggestedItem>();
                                    }
                                    l = System.currentTimeMillis();
                                    treeSet = new TreeSet<SuggestedItem>();
                                    statement = null;
                                    resultSet = null;
                                    string2 = null;
                                    database = Connections.getInstance().getDatabase(this.connectionName, false);
                                    if (database != null) break block47;
                                    treeSet3 = new TreeSet<SuggestedItem>();
                                    Object var18_12 = null;
                                    if (resultSet == null) break block48;
                                    try {
                                        resultSet.close();
                                    }
                                    catch (SQLException sQLException3222) {
                                        // empty catch block
                                    }
                                }
                                if (statement != null) {
                                    try {
                                        statement.close();
                                    }
                                    catch (SQLException sQLException3222) {
                                        // empty catch block
                                    }
                                }
                                return treeSet3;
                            }
                            connection = database.getConnection(false);
                            if (connection != null) break block50;
                            treeSet2 = new TreeSet<SuggestedItem>();
                            Object var18_13 = null;
                            if (resultSet == null) break block51;
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException2222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException2222) {
                                // empty catch block
                            }
                        }
                        return treeSet2;
                    }
                    string2 = connection.getMetaData().getDatabaseMajorVersion() > 10 ? this.query.toString().replace("OBJ_TYPE_EQ_PKG", OBJ_TYPE_EQ_PKG) : this.query.toString().replace("OBJ_TYPE_EQ_PKG", "");
                    statement = connection.prepareStatement(string2);
                    for (int i = 1; i <= this.binds.size(); ++i) {
                        statement.setObject(i, this.binds.get(i - 1));
                    }
                    resultSet = statement.executeQuery();
                    list = null;
                    Object object = "";
                    while (resultSet.next()) {
                        List<String> list2;
                        string = resultSet.getString("type");
                        List<String> list3 = DBUtil.enquote((String)resultSet.getString("object_name"));
                        Object object2 = resultSet.getString("column_name");
                        if ("ARGUMENT".equals(string)) {
                            list2 = list3;
                            if (list == null) {
                                object = (String)object + (String)object2;
                            } else if (((String)((Object)list2)).equals(list)) {
                                object = (String)object + "," + (String)object2;
                            } else {
                                treeSet.add(new SuggestedItem(string, null, (String)object));
                                object = object2;
                            }
                            list = list2;
                            continue;
                        }
                        if ("COLUMN".equals(string)) {
                            if (object2 != null) {
                                object2 = DBUtil.enquote((String)object2);
                            }
                            list2 = this.translate(resultSet.getString("owner"), (String)((Object)list3), (String)object2);
                            for (String string3 : list2) {
                                treeSet.add(new SuggestedItem(string, resultSet.getString("owner"), string3));
                            }
                            continue;
                        }
                        treeSet.add(new SuggestedItem(string, resultSet.getString("owner"), (String)((Object)list3)));
                    }
                    if (((String)object).length() <= 0) break block53;
                    treeSet.add(new SuggestedItem("ARGUMENT", null, (String)object));
                }
                var18_14 = null;
                if (resultSet == null) break block54;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException422) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException422) {}
            }
            break block56;
            {
                catch (DBException dBException) {
                    logger.severe(string2);
                    logger.severe(dBException.getMessage());
                    var18_14 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException422) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException422) {}
                    }
                    break block56;
                }
                catch (SQLException sQLException5) {
                    logger.severe(string2);
                    logger.severe(sQLException5.getMessage());
                    var18_14 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException422) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException422) {}
                    }
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException6222;
                Object var18_15 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException6222) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException6222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        long l2 = System.currentTimeMillis();
        System.out.println("InsightableOracleDatabase.fetch() time = " + (l2 - l));
        if (l + 500L < l2) {
            logger.warning("InsightableOracleDatabase.fetch() time = " + (l2 - l));
            logger.warning(string2);
            System.out.println(string2);
            for (Object object : this.binds) {
                System.out.println(object);
                if (object != null) {
                    logger.warning(object.toString());
                    continue;
                }
                logger.warning("bind=null");
            }
        }
        list = new TreeSet();
        int n = 0;
        string = null;
        for (Object object2 : treeSet) {
            if (!((SuggestedItem)object2).getType().equals(string)) {
                n = 0;
            }
            if (++n >= this.limit()) {
                list.add((String)((Object)new SuggestedItem(((SuggestedItem)object2).getType(), null, "...")));
            }
            string = ((SuggestedItem)object2).getType();
        }
        treeSet.addAll(list);
        return treeSet;
    }
}

