/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.insight;

import javax.swing.Icon;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.javatools.editor.insight.ListDataItem;
import oracle.javatools.icons.OracleIcons;

public class SuggestedItem
extends ListDataItem
implements Comparable {
    private String _owner;
    private String _name;
    private String _type;

    boolean isKeyword() {
        return "KEYWORD".equals(this._type);
    }

    public String getType() {
        return this._type;
    }

    SuggestedItem(SuggestedItem suggestedItem, boolean bl) {
        this._name = suggestedItem._name.charAt(0) != '\"' ? (bl ? suggestedItem._name.toUpperCase() : suggestedItem._name.toLowerCase()) : suggestedItem._name;
        this._type = suggestedItem._type;
        this._owner = suggestedItem._owner;
    }

    SuggestedItem(String string, String string2, String string3) {
        this._name = string3;
        this._type = string;
        this._owner = string2;
    }

    public Icon getIcon() {
        if ("FUNCTION".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"function.png");
        }
        if ("PROCEDURE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"plsql_proc.png");
        }
        if ("COLUMN".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon(7);
        }
        if ("TABLE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"table.png");
        }
        if ("VIEW".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"view.png");
        }
        if ("CHAR".equalsIgnoreCase(this._type) || "VARCHAR2".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon(55);
        }
        if ("INTEGER".equalsIgnoreCase(this._type) || "NUMBER".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"field.png");
        }
        if ("DATE".equalsIgnoreCase(this._type) || "TIMESTAMP".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon(9);
        }
        if ("SCHEMA".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"user.png");
        }
        if ("PACKAGE".equalsIgnoreCase(this._type)) {
            return OracleIcons.getIcon((String)"package.png");
        }
        if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return RaptorImagesArb.getIcon(48);
        }
        return null;
    }

    private int priority() {
        if ("ARGUMENT".equalsIgnoreCase(this._type)) {
            return 0;
        }
        if ("COLUMN".equalsIgnoreCase(this._type)) {
            return 1;
        }
        if ("TABLE".equalsIgnoreCase(this._type)) {
            return 2;
        }
        if ("VIEW".equalsIgnoreCase(this._type)) {
            return 3;
        }
        if ("KEYWORD".equalsIgnoreCase(this._type)) {
            return 4;
        }
        if ("CHAR".equals(this._type) || "VARCHAR2".equals(this._type)) {
            return 5;
        }
        if ("INTEGER".equals(this._type) || "NUMBER".equals(this._type)) {
            return 5;
        }
        if ("DATE".equals(this._type) || "TIMESTAMP".equals(this._type)) {
            return 5;
        }
        if ("SCHEMA".equals(this._type)) {
            return 7;
        }
        if ("PACKAGE".equalsIgnoreCase(this._type)) {
            return 8;
        }
        if ("FUNCTION".equalsIgnoreCase(this._type)) {
            return 10;
        }
        if ("PROCEDURE".equalsIgnoreCase(this._type)) {
            return 10;
        }
        if ("SNIPPET".equalsIgnoreCase(this._type)) {
            return 11;
        }
        return 9999;
    }

    public String getDisplayText() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SuggestedItem)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        SuggestedItem suggestedItem = (SuggestedItem)object;
        if (this.priority() != suggestedItem.priority()) {
            return this.priority() - suggestedItem.priority();
        }
        if (this._name.startsWith("...") && !suggestedItem._name.startsWith("...")) {
            return 1;
        }
        if (!this._name.startsWith("...") && suggestedItem._name.startsWith("...")) {
            return -1;
        }
        return super.compareTo(object);
    }
}

