/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.models;

import java.awt.Color;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ResultSetTablePersistedSettings;
import oracle.dbtools.raptor.extendedtype.ExtendedType;
import oracle.dbtools.raptor.models.ResultSetCondition;
import oracle.dbtools.raptor.models.ResultSetTableModel;
import oracle.dbtools.raptor.models.ResultSetTableModelBuffer;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.DataTypesUtil;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.raptor.utils.Translate;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.sql.ROWID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EditableResultSetTableModel
extends ResultSetTableModel {
    private static final long serialVersionUID = 1L;
    private Logger logger = Logger.getLogger(EditableResultSetTableModel.class.getName());
    private static final String EDITABLE_COLS = "select column_name from  all_updatable_columns where TABLE_NAME = :OBJECT_NAME and owner = :OBJECT_OWNER and updatable = 'YES'";
    private Statement _stmt;
    private ResultSetMetaData _rsmd;
    private ArrayList _log;
    private boolean _insertOnly;
    private String _modifiedSql;
    private boolean _changed;
    private boolean _valid = true;
    private int _colOffset;
    private boolean _dataIntegrity;
    private boolean _updatedByAnotherUser;
    private String _whereClause;
    private String _orderByClause;
    private String _settingsSQL;
    private NamedSwingWorker _worker;
    private String _nlsDateFormat;
    private String _tsFormat;
    private String _tstzFormat;
    private TableColumnModel _tabColModel;
    private String _dbObjectType = null;
    private ArrayList<String> _editableColNames;

    public EditableResultSetTableModel(Connection connection, ResultSet resultSet, String string, Database database, DBObject dBObject) {
        super(connection, resultSet, string, database, dBObject);
        try {
            this._rsmd = this._rs.getMetaData();
        }
        catch (Exception exception) {
            this._valid = false;
        }
        this._stmt = null;
        this._log = new ArrayList();
        this._insertOnly = false;
        this._changed = false;
        this._updatedByAnotherUser = false;
        this.setTranslatedColNames(false);
        this._dbObjectType = dBObject.getObjectType();
        this.setIsOracle(this.getConnName() != null ? Connections.getInstance().isOracle(this.getConnName()) : this.getConnection() instanceof OracleConnection);
    }

    @Override
    public boolean open() {
        return this.open(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(boolean bl) {
        Connection connection = this.getConnection();
        synchronized (connection) {
            try {
                if (this._stmt == null) {
                    this._stmt = this.getConnection().createStatement();
                }
                if (this._rs == null || bl) {
                    try {
                        this._stmt.setMaxRows(0);
                    }
                    catch (SQLException sQLException) {
                    }
                    catch (AbstractMethodError abstractMethodError) {
                        // empty catch block
                    }
                    this._rs = this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._sql));
                }
                if (Connections.getInstance().getConnection(this.getConnName()).getMetaData().getDatabaseMajorVersion() > 8) {
                    this._isExternalTable = this.isExternalTable(this._tablename);
                }
                if (this._isExternalTable) {
                    this._valid = false;
                }
                this._editableColNames = null;
                this._buildModifiedSql(bl);
                this._rs = this.isTimesTen() || this.isOracle() || ObjectFactory.getFactory(this.getConnName(), Connections.getInstance().getConnection(this.getConnName())).getConnectionTypeDescriptor().isRowIdSupported() ? this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._modifiedSql)) : this._stmt.executeQuery(EditableResultSetTableModel._sanitizeOracleSQL(this._sql));
                this._createColumnNamesList(true);
                this._fetchNext(0);
                this.fireTableDataChanged();
            }
            catch (SQLException sQLException) {
                if (!bl) {
                    this.open(true);
                } else {
                    ExceptionHandler.handleException((SQLException)sQLException, (String)this.getConnName(), (String)this.getSQL(), (int)0);
                }
                return false;
            }
            catch (DBException dBException) {
                ExceptionHandler.handleException((Exception)((Object)dBException));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int n, int n2) {
        if (this._rows != null) {
            Object object;
            if (n >= this._rows.size()) {
                object = this.LOCK;
                synchronized (object) {
                    if (this._worker == null) {
                        this._fetchNext(n - this._rows.size());
                    }
                }
            }
            if (n < this._rows.size() && (object = this._rows.get(n)) != null) {
                List list = null;
                if (object instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)object;
                    if (n2 == 0 && resultSetTableModelBuffer.getDeleted()) {
                        return new String("-" + (n + 1));
                    }
                    if (n2 == 0 && resultSetTableModelBuffer.getNew()) {
                        return new String("+" + (n + 1));
                    }
                    if (n2 == 0 && resultSetTableModelBuffer.getChanged()) {
                        return new String("*" + (n + 1));
                    }
                    list = resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew() ? resultSetTableModelBuffer.getChangedRow() : resultSetTableModelBuffer.getOriginalRow();
                } else {
                    list = (ArrayList)object;
                }
                if (n2 == 0) {
                    return new Integer(n + 1);
                }
                if (list != null) {
                    return list.get(n2 - 1);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this._isExternalTable) {
            return false;
        }
        if (n2 == 0) {
            return false;
        }
        if (this._insertOnly && !this.isRowNew(n)) {
            return false;
        }
        if (this.isOracle() && this.getEditableColumnNames().size() == 0) {
            return false;
        }
        return !this.isOracle() || this.isColumnEditable(this.getColumnName(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        List<Object> list;
        if (this._rows != null && n >= this._rows.size()) {
            list = this.LOCK;
            synchronized (list) {
                if (this._worker == null) {
                    this._fetchNext(n - this._rows.size());
                }
            }
        }
        if (n2 == 0) {
            return;
        }
        if (n < this._rows.size()) {
            list = null;
            Object e = this._rows.get(n);
            ResultSetTableModelBuffer resultSetTableModelBuffer = null;
            if (e != null) {
                if (e instanceof ResultSetTableModelBuffer) {
                    resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    list = resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew() ? resultSetTableModelBuffer.getChangedRow() : new ArrayList<Object>(resultSetTableModelBuffer.getOriginalRow());
                } else {
                    ArrayList arrayList = (ArrayList)e;
                    list = (ArrayList)arrayList.clone();
                    resultSetTableModelBuffer = new ResultSetTableModelBuffer((ArrayList)e);
                }
            }
            if (!(list == null || list.get(n2 - 1) != null && DataTypesUtil.isEqual(list.get(n2 - 1), (Object)object, (Connection)this.getConnection(), (int)this.getType(n2 - 1)) || list.get(n2 - 1) == null && object.toString().length() == 0)) {
                list.set(n2 - 1, object);
                resultSetTableModelBuffer.setChangedRow(list);
                resultSetTableModelBuffer.setChanged(true);
                resultSetTableModelBuffer.setError(false);
                this._rows.set(n, resultSetTableModelBuffer);
                if (resultSetTableModelBuffer.getOriginalRow() != null && !ModelUtil.areDifferent(resultSetTableModelBuffer.getOriginalRow().get(n2 - 1), resultSetTableModelBuffer.getChangedRow().get(n2 - 1))) {
                    resultSetTableModelBuffer.reset();
                }
                this._changed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save() {
        int n = 0;
        if (!this._valid) {
            return 1;
        }
        this._log.clear();
        Connection connection = this.getConnection();
        synchronized (connection) {
            ResultSetTableModelBuffer resultSetTableModelBuffer;
            ResultSetTableModelBuffer resultSetTableModelBuffer2;
            if (this.isOracle()) {
                this._nlsDateFormat = NLSUtils.getDateFormat((Connection)this.getConnection());
                this._tsFormat = NLSUtils.getTimeStampFormat((Connection)this.getConnection());
                this._tstzFormat = NLSUtils.getTimeStampWithTimeZoneFormat((Connection)this.getConnection());
            }
            boolean bl = true;
            boolean bl2 = true;
            List<ResultSetTableModelBuffer> list = this.getChangedRows();
            try {
                bl2 = this.getConnection().getAutoCommit();
                this.getConnection().setAutoCommit(false);
                if (this._stmt != null) {
                    this._stmt.close();
                }
                this._stmt = this.getConnection().createStatement();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this._insertOnly) {
                int n2;
                for (n2 = 0; n2 < list.size(); ++n2) {
                    resultSetTableModelBuffer2 = list.get(n2);
                    if (resultSetTableModelBuffer2 == null || !(resultSetTableModelBuffer2 instanceof ResultSetTableModelBuffer) || !(resultSetTableModelBuffer = resultSetTableModelBuffer2).getDeleted() || resultSetTableModelBuffer.getNew() || this.deleteRow(resultSetTableModelBuffer)) continue;
                    ++n;
                }
                for (n2 = 0; n2 < list.size(); ++n2) {
                    resultSetTableModelBuffer2 = list.get(n2);
                    if (resultSetTableModelBuffer2 == null || !(resultSetTableModelBuffer2 instanceof ResultSetTableModelBuffer) || !(resultSetTableModelBuffer = resultSetTableModelBuffer2).getChanged() || resultSetTableModelBuffer.getNew() || resultSetTableModelBuffer.getDeleted() || this.updateRow(resultSetTableModelBuffer)) continue;
                    ++n;
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                resultSetTableModelBuffer2 = list.get(i);
                if (resultSetTableModelBuffer2 == null || !(resultSetTableModelBuffer2 instanceof ResultSetTableModelBuffer) || !(resultSetTableModelBuffer = resultSetTableModelBuffer2).getNew() || !resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getDeleted() || this.insertRow(resultSetTableModelBuffer)) continue;
                ++n;
            }
            if (n > 0) {
                bl = false;
                try {
                    this.getConnection().rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (bl) {
                this.clearChanges();
            }
            try {
                this.getConnection().setAutoCommit(bl2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public int discardChanges() {
        if (!this._valid) {
            return 1;
        }
        int n = 0;
        this._log.clear();
        for (int i = this._rows.size() - 1; i >= 0; --i) {
            Object e = this._rows.get(i);
            if (e == null || !(e instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            if (resultSetTableModelBuffer.getNew()) {
                this._rows.remove(i);
                continue;
            }
            resultSetTableModelBuffer.setChangedRow(null);
            resultSetTableModelBuffer.setChanged(false);
            resultSetTableModelBuffer.setError(false);
            resultSetTableModelBuffer.setDeleted(false);
            resultSetTableModelBuffer.setNew(false);
        }
        this._changed = false;
        this._updatedByAnotherUser = false;
        this.fireTableDataChanged();
        return n;
    }

    public boolean isRowDeleted(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getDeleted();
    }

    public boolean isRowChanged(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getChanged();
    }

    public boolean isRowNew(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getNew();
    }

    public boolean isRowError(int n) {
        ResultSetTableModelBuffer resultSetTableModelBuffer;
        Object e;
        return n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer && (resultSetTableModelBuffer = (ResultSetTableModelBuffer)e).getError();
    }

    public String getErrorMessage(int n) {
        Object e;
        if (n < this._rows.size() && (e = this._rows.get(n)) != null && e instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            return resultSetTableModelBuffer.getErrorMessage();
        }
        return null;
    }

    public boolean markRowDeleted(int n, boolean bl) {
        if (this._insertOnly) {
            return false;
        }
        if (n < this._rows.size()) {
            Object e = this._rows.get(n);
            if (e != null) {
                if (e instanceof ResultSetTableModelBuffer) {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
                    resultSetTableModelBuffer.setDeleted(bl);
                    resultSetTableModelBuffer.setError(false);
                } else {
                    ResultSetTableModelBuffer resultSetTableModelBuffer = new ResultSetTableModelBuffer((ArrayList)e);
                    resultSetTableModelBuffer.setDeleted(bl);
                    this._rows.set(n, resultSetTableModelBuffer);
                }
            }
            this.fireTableDataChanged();
            this._changed = true;
        }
        return true;
    }

    public boolean addRow(int n) {
        ArrayList<String> arrayList = null;
        ResultSetTableModelBuffer resultSetTableModelBuffer = null;
        arrayList = new ArrayList<String>();
        for (int i = 1; i < this.getColumnCount(); ++i) {
            arrayList.add("");
        }
        resultSetTableModelBuffer = new ResultSetTableModelBuffer();
        resultSetTableModelBuffer.setChangedRow(arrayList);
        resultSetTableModelBuffer.setNew(true);
        resultSetTableModelBuffer.setChanged(true);
        return this.addRow(n, resultSetTableModelBuffer);
    }

    public boolean addRow(int n, ResultSetTableModelBuffer resultSetTableModelBuffer) {
        if (!this._valid) {
            return false;
        }
        if (n < this._rows.size()) {
            this._rows.add(n, resultSetTableModelBuffer);
        } else {
            this._rows.add(resultSetTableModelBuffer);
        }
        this._changed = true;
        this.fireTableDataChanged();
        return true;
    }

    public ArrayList getLog() {
        return this._log;
    }

    public void setInsertOnly() {
        this._insertOnly = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private boolean insertRow(ResultSetTableModelBuffer resultSetTableModelBuffer) {
        block75: {
            Object object;
            int n;
            block74: {
                HashMap<String, ExtendedType> hashMap = new HashMap<String, ExtendedType>();
                List list = resultSetTableModelBuffer.getChangedRow();
                StringBuffer stringBuffer = new StringBuffer();
                if (this.isOracle()) {
                    stringBuffer.append("BEGIN INSERT INTO ");
                } else {
                    stringBuffer.append("INSERT INTO ");
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                stringBuffer.append(this._tablename);
                boolean bl = true;
                int n2 = 0;
                boolean bl2 = false;
                String string = null;
                for (n = 1; n < this.getColumnCount(); ++n) {
                    string = this.getColumnDBName(n);
                    try {
                        string = this.getDatabase().quoteIdentifier(string, false);
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    if (list.get(n - 1) instanceof ExtendedType) {
                        hashMap.put(string, (ExtendedType)list.get(n - 1));
                    }
                    if (list.get(n - 1) != null && list.get(n - 1).toString().length() > 0) {
                        if (!bl) {
                            stringBuffer.append(", ");
                        } else {
                            bl = false;
                            stringBuffer.append(" (");
                        }
                        stringBuffer.append(string);
                        continue;
                    }
                    ++n2;
                }
                if (n2 == this.getColumnCount() - 1) {
                    bl2 = true;
                    stringBuffer.append(" VALUES (");
                } else {
                    stringBuffer.append(") VALUES (");
                }
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.substring(6));
                bl = false;
                int n3 = 1;
                int n4 = -1;
                for (n = 0; n < list.size(); ++n) {
                    object = list.get(n);
                    if (bl) {
                        stringBuffer.append(", ");
                        stringBuffer2.append(", ");
                    }
                    try {
                        n4 = this._rsmd.getColumnType(n + 1 + this._colOffset);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    if (object != null && object.toString().length() > 0 && DataTypesUtil.isExtendedType(object, (int)n4)) {
                        stringBuffer.append(DataTypesUtil.getEmptyExtendedType(object, (int)n4));
                        stringBuffer2.append(DataTypesUtil.getEmptyExtendedType(object, (int)n4));
                        ++n3;
                        bl = true;
                        continue;
                    }
                    if (object != null && object.toString().length() > 0) {
                        String string2 = "unknown";
                        try {
                            string2 = this._rsmd.getColumnTypeName(n + 1 + this._colOffset);
                            if (string2 == null) {
                                string2 = "unknown";
                            }
                        }
                        catch (Exception exception) {
                            string2 = "unknown";
                        }
                        try {
                            if (this.getDatabase().getDatabaseType() == "Oracle Database" && ((OracleResultSetMetaData)this._rsmd).isNCHAR(n + 1 + this._colOffset)) {
                                arrayList.add(new Integer(n3));
                            }
                        }
                        catch (SQLException sQLException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        }
                        if (this.getDatabase().getDatabaseType() == "Oracle Database" && string2.equals("DATE")) {
                            stringBuffer.append("TO_DATE(?, '" + this._nlsDateFormat + "')");
                            stringBuffer2.append("TO_DATE('" + object.toString().substring(0, Math.min(19, object.toString().length())) + "'" + ", '" + this._nlsDateFormat + "')");
                        } else if (this.getDatabase().getDatabaseType() == "Oracle Database" && string2.equals("TIMESTAMP")) {
                            stringBuffer.append("TO_TIMESTAMP(?, '" + this._tsFormat + "')");
                            stringBuffer2.append("TO_TIMESTAMP('" + object.toString().substring(0, Math.min(19, object.toString().length())) + "'" + ", '" + this._tsFormat + "')");
                        } else if (this.getDatabase().getDatabaseType() == "Oracle Database" && (string2.equals("TIMESTAMPTZ") || string2.equals("TIMESTAMPLTZ"))) {
                            stringBuffer.append("to_timestamp_tz(?, '" + this._tstzFormat + "')");
                            stringBuffer2.append("to_timestamp_tz('" + object.toString().substring(0, Math.min(19, object.toString().length())) + "'" + ", '" + this._tstzFormat + "')");
                        } else {
                            stringBuffer.append("?");
                            stringBuffer2.append("'" + DataTypesUtil.stringValue((Object)object, (Connection)this.getConnection()).replaceAll("'", "''") + "'");
                        }
                        ++n3;
                        bl = true;
                        continue;
                    }
                    if (bl2) {
                        if (this._dbObjectType.equals("TABLE") && n4 != -13) {
                            stringBuffer.append("DEFAULT");
                            stringBuffer2.append("DEFAULT");
                        } else {
                            stringBuffer.append("NULL");
                            stringBuffer2.append("NULL");
                        }
                        ++n3;
                        bl = true;
                        continue;
                    }
                    bl = false;
                }
                if (stringBuffer.toString().endsWith(", ")) {
                    stringBuffer.replace(stringBuffer.lastIndexOf(","), stringBuffer.length(), "");
                    stringBuffer2.replace(stringBuffer2.lastIndexOf(","), stringBuffer2.length(), "");
                }
                stringBuffer.append(")");
                stringBuffer2.append(")");
                this._log.add(stringBuffer2.toString());
                if (this.isOracle()) {
                    stringBuffer.append(" RETURNING ROWID INTO ?; END;");
                }
                object = null;
                object = this.getConnection().prepareCall(stringBuffer.toString());
                int n5 = 1;
                for (n = 0; n < list.size(); ++n) {
                    void var17_31;
                    Object e = list.get(n);
                    if (bl2 || e == null || e.toString().length() <= 0 || e instanceof ExtendedType) continue;
                    String string3 = "unknown";
                    try {
                        String string4 = this._rsmd.getColumnTypeName(n + 1 + this._colOffset);
                        if (string4 == null) {
                            String string5 = "unknown";
                        }
                    }
                    catch (Exception exception) {
                        String string6 = "unknown";
                    }
                    if (var17_31.equals("DATE") || var17_31.equals("TIMESTAMP")) {
                        if (this.getDatabase().getDatabaseType() == "Oracle Database") {
                            object.setString(n5, e.toString());
                        } else {
                            Date date = Date.valueOf(e.toString().substring(0, Math.min(10, e.toString().length())));
                            object.setDate(n5, date);
                        }
                    } else if (var17_31.equals("CLOB")) {
                        if (this.getDatabase().getDatabaseType() == "Oracle Database") {
                            try {
                                ((OraclePreparedStatement)object).setStringForClob(n5, e.toString());
                            }
                            catch (Exception exception) {
                                object.setString(n5, e.toString());
                            }
                        }
                    } else {
                        object.setString(n5, e.toString());
                    }
                    ++n5;
                }
                if (this.isOracle()) {
                    for (Integer n6 : arrayList) {
                        ((OraclePreparedStatement)object).setFormOfUse(n6.intValue(), (short)2);
                    }
                }
                if (this.isOracle()) {
                    object.registerOutParameter(n5, 1);
                }
                boolean bl3 = object.execute();
                if (this.isOracle()) {
                    resultSetTableModelBuffer.setRowId(object.getString(n5));
                }
                this.selectRowscn(resultSetTableModelBuffer);
                resultSetTableModelBuffer.setCommitted();
                Iterator iterator = hashMap.keySet().iterator();
                boolean bl4 = true;
                while (iterator.hasNext()) {
                    String string7 = (String)iterator.next();
                    ExtendedType extendedType = (ExtendedType)hashMap.get(string7);
                    bl3 = extendedType.saveToDb(this.getConnection(), this._tablename, string7, resultSetTableModelBuffer.getRowId(), resultSetTableModelBuffer.getRowscn(), this._dataIntegrity);
                }
                if (hashMap.size() <= 0) break block74;
                boolean bl5 = bl3;
                Object var22_47 = null;
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return bl5;
            }
            Object var22_48 = null;
            try {
                if (object != null) {
                    object.close();
                }
                break block75;
            }
            catch (SQLException sQLException) {}
            break block75;
            {
                catch (NumberFormatException numberFormatException) {
                    resultSetTableModelBuffer.setError(MessageFormat.format(ConnectionArb.getString(97), this.getColumnName(n + 1)));
                    boolean bl = false;
                    Object var22_49 = null;
                    try {
                        if (object != null) {
                            object.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    resultSetTableModelBuffer.setError(MessageFormat.format(ConnectionArb.getString(97), this.getColumnName(n + 1)));
                    boolean bl = false;
                    Object var22_50 = null;
                    try {
                        if (object != null) {
                            object.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (SQLException sQLException) {
                    Log.log((String)sQLException.getLocalizedMessage());
                    resultSetTableModelBuffer.setError(sQLException.getLocalizedMessage());
                    boolean bl = false;
                    Object var22_51 = null;
                    try {
                        if (object != null) {
                            object.close();
                        }
                    }
                    catch (SQLException sQLException2) {
                        // empty catch block
                    }
                    return bl;
                }
                catch (Exception exception) {
                    boolean bl = false;
                    Object var22_52 = null;
                    try {
                        if (object != null) {
                            object.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var22_53 = null;
                try {
                    if (object != null) {
                        object.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateRow(ResultSetTableModelBuffer var1_1) {
        block63: {
            block62: {
                block61: {
                    block60: {
                        var3_2 = new StringBuffer("UPDATE ");
                        var4_3 = var1_1.getChangedRow();
                        var5_4 = var1_1.getOriginalRow();
                        var6_5 = new ArrayList<E>();
                        var3_2.append(this._tablename + " SET ");
                        var7_6 = new StringBuffer(var3_2.toString());
                        var8_7 = new ArrayList<Integer>();
                        var9_8 = true;
                        var10_9 = null;
                        for (var2_10 = 0; var2_10 < var4_3.size(); ++var2_10) {
                            var11_11 = var4_3.get(var2_10);
                            var12_12 = var5_4.get(var2_10);
                            if (var11_11 == null || var11_11 instanceof ExtendedType || !ModelUtil.areDifferent(var11_11, var12_12)) continue;
                            var6_5.add(var11_11);
                            if (!var9_8) {
                                var3_2.append(", ");
                                var7_6.append(", ");
                            } else {
                                var9_8 = false;
                            }
                            var13_18 = "unknown";
                            try {
                                var13_18 = this._rsmd.getColumnTypeName(var2_10 + 1 + this._colOffset);
                                if (var13_18 == null) {
                                    var13_18 = "unknown";
                                }
                            }
                            catch (Exception var14_26) {
                                var13_18 = "unknown";
                            }
                            try {
                                if (this._rsmd instanceof OracleResultSetMetaData && ((OracleResultSetMetaData)this._rsmd).isNCHAR(var2_10 + 1 + this._colOffset)) {
                                    var8_7.add(var6_5.size());
                                }
                            }
                            catch (SQLException var14_27) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var14_27.getStackTrace()[0].toString(), var14_27);
                            }
                            var14_25 /* !! */  = this.getDatabase().getDatabaseType();
                            var10_9 = this.getColumnDBName(var2_10 + 1);
                            try {
                                var10_9 = this.getDatabase().quoteIdentifier(var10_9, false);
                            }
                            catch (DBException var15_32) {
                                // empty catch block
                            }
                            if (this.getDatabase().getDatabaseType() == "Oracle Database" && var13_18.equals("DATE")) {
                                var3_2.append(var10_9 + " = TO_DATE(?, '" + this._nlsDateFormat + "')");
                                var7_6.append(var10_9 + " = TO_DATE(" + "'" + var11_11.toString().substring(0, Math.min(19, var11_11.toString().length())) + "'" + ", '" + this._nlsDateFormat + "')");
                                continue;
                            }
                            if (this.getDatabase().getDatabaseType() == "Oracle Database" && var13_18.equals("TIMESTAMP")) {
                                var3_2.append(var10_9 + " = TO_TIMESTAMP(?, '" + this._tsFormat + "')");
                                var7_6.append(var10_9 + " = TO_TIMESTAMP(" + "'" + var11_11.toString().substring(0, Math.min(19, var11_11.toString().length())) + "'" + ", '" + this._tsFormat + "')");
                                continue;
                            }
                            if (this.getDatabase().getDatabaseType() == "Oracle Database" && (var13_18.equals("TIMESTAMPTZ") || var13_18.equals("TIMESTAMPLTZ"))) {
                                var3_2.append(var10_9 + " = to_timestamp_tz(?, '" + this._tstzFormat + "')");
                                var7_6.append(var10_9 + " = to_timestamp_tz(" + "'" + var11_11.toString().substring(0, Math.min(19, var11_11.toString().length())) + "'" + ", '" + this._tstzFormat + "')");
                                continue;
                            }
                            var3_2.append(var10_9 + " = ?");
                            var7_6.append(var10_9 + " = " + this.quote(DataTypesUtil.stringValue((Object)var11_11, (Connection)this.getConnection()).length() == 0 ? null : DataTypesUtil.stringValue((Object)var11_11, (Connection)this.getConnection())));
                        }
                        var3_2.append(" WHERE ROWID = ?");
                        var7_6.append(" WHERE ROWID = " + this.quote(var1_1.getRowId()));
                        if (this._dataIntegrity && var1_1.getRowscn() != null) {
                            var3_2.append(" AND ORA_ROWSCN = ?");
                            var7_6.append(" AND ORA_ROWSCN = " + this.quote(var1_1.getRowscn()));
                        }
                        this._log.add(var7_6.toString());
                        var11_11 = null;
                        try {
                            block66: {
                                block65: {
                                    var11_11 = this.getConnection().prepareStatement(var3_2.toString());
                                    var12_13 = 1;
                                    for (String var14_25 : var6_5) {
                                        block59: {
                                            block64: {
                                                if (var14_25 /* !! */  == null) continue;
                                                var15_33 /* !! */  = "unknown";
                                                try {
                                                    var15_33 /* !! */  = this._rsmd.getColumnTypeName(var2_10 + 1 + this._colOffset);
                                                    if (var15_33 /* !! */  == null) {
                                                        var15_33 /* !! */  = "unknown";
                                                    }
                                                }
                                                catch (Exception var16_35) {
                                                    var15_33 /* !! */  = "unknown";
                                                }
                                                if (var11_11 instanceof OraclePreparedStatement) {
                                                    var16_34 = var8_7.iterator();
                                                    while (var16_34.hasNext()) {
                                                        var17_37 = (Integer)var16_34.next();
                                                        ((OraclePreparedStatement)var11_11).setFormOfUse(var17_37.intValue(), (short)2);
                                                    }
                                                }
                                                if (!var15_33 /* !! */ .equals("DATE") && !var15_33 /* !! */ .equals("TIMESTAMP")) break block64;
                                                if (this.getDatabase().getDatabaseType() == "Oracle Database") {
                                                    var11_11.setString(var12_13, var14_25 /* !! */ .toString());
                                                    break block59;
                                                } else if (var14_25 /* !! */ .toString().length() == 0) {
                                                    var11_11.setNull(var12_13, this._rsmd.getColumnType(var2_10));
                                                    break block59;
                                                } else {
                                                    var11_11.setString(var12_13, var14_25 /* !! */ .toString());
                                                }
                                                break block59;
                                            }
                                            if (var15_33 /* !! */ .equals("CLOB")) {
                                                if (this.getDatabase().getDatabaseType() == "Oracle Database") {
                                                    try {
                                                        ((OraclePreparedStatement)var11_11).setStringForClob(var12_13, var14_25 /* !! */ .toString());
                                                    }
                                                    catch (Exception var16_36) {
                                                        var11_11.setString(var12_13, var14_25 /* !! */ .toString());
                                                    }
                                                }
                                            } else if (var14_25 /* !! */ .toString().length() == 0) {
                                                var11_11.setNull(var12_13, this._rsmd.getColumnType(var2_10));
                                            } else {
                                                var11_11.setString(var12_13, var14_25 /* !! */ .toString());
                                            }
                                        }
                                        ++var12_13;
                                    }
                                    var11_11.setString(var12_13, var1_1.getRowId());
                                    ++var12_13;
                                    if (this._dataIntegrity && var1_1.getRowscn() != null) {
                                        var11_11.setString(var12_13, var1_1.getRowscn());
                                    }
                                    if (var6_5.size() <= 0) break block65;
                                    var13_19 = var11_11.executeUpdate();
                                    if (var13_19 == 1) {
                                        var1_1.setCommitted();
                                        for (var2_10 = 0; var2_10 < var4_3.size(); ++var2_10) {
                                            var14_25 /* !! */  = var4_3.get(var2_10);
                                            var15_33 /* !! */  = var5_4.get(var2_10);
                                            if (var14_25 /* !! */  == null || !(var14_25 /* !! */  instanceof ExtendedType) || (var16_34 = (ExtendedType)var14_25 /* !! */ ).saveToDb(this.getConnection(), this._tablename, this.getColumnDBName(var2_10 + 1), var1_1.getRowId(), var1_1.getRowscn(), this._dataIntegrity)) continue;
                                            var17_38 = false;
                                            var19_39 = null;
                                            try {
                                                if (var11_11 == null) return var17_38;
                                                var11_11.close();
                                                return var17_38;
                                            }
                                            catch (SQLException var20_50) {
                                                // empty catch block
                                            }
                                            return var17_38;
                                        }
                                        break block66;
                                    } else {
                                        if (var13_19 == 0) {
                                            var1_1.setError(ConnectionArb.getString(95) + System.getProperty("line.separator"));
                                            this._updatedByAnotherUser = true;
                                            var14_28 = false;
                                            break block60;
                                        }
                                        var14_29 = true;
                                        break block61;
                                    }
                                }
                                var13_20 = false;
                                for (var2_10 = 0; var2_10 < var4_3.size(); ++var2_10) {
                                    var14_25 /* !! */  = var4_3.get(var2_10);
                                    var15_33 /* !! */  = var5_4.get(var2_10);
                                    if (var14_25 /* !! */  == null || !(var14_25 /* !! */  instanceof ExtendedType)) continue;
                                    var16_34 = (ExtendedType)var4_3.get(var2_10);
                                    var13_20 = var16_34.saveToDb(this.getConnection(), this._tablename, this.getColumnDBName(var2_10 + 1), var1_1.getRowId(), var1_1.getRowscn(), this._dataIntegrity);
                                }
                                if (var13_20) {
                                    var1_1.setCommitted();
                                    var14_30 = true;
                                    break block62;
                                }
                                var14_31 = false;
                                break block63;
                            }
                            var19_44 = null;
                            try {}
                            catch (SQLException var20_55) {
                                return true;
                            }
                            if (var11_11 == null) return true;
                            var11_11.close();
                            return true;
                            catch (NumberFormatException var12_14) {
                                var1_1.setError(MessageFormat.format(ConnectionArb.getString(97), new Object[]{this.getColumnName(var2_10 + 1)}));
                                var13_21 = false;
                                var19_45 = null;
                                ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl189:
                                // 1 sources

                                if (var11_11 == null) return var13_21;
                                var11_11.close();
                                return var13_21;
lbl192:
                                // 1 sources

                                catch (SQLException var20_56) {
                                    // empty catch block
                                }
                                return var13_21;
                            }
                            catch (IllegalArgumentException var12_15) {
                                var1_1.setError(MessageFormat.format(ConnectionArb.getString(97), new Object[]{this.getColumnName(var2_10 + 1)}));
                                var13_22 = false;
                                var19_46 = null;
                                ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl201:
                                // 1 sources

                                if (var11_11 == null) return var13_22;
                                var11_11.close();
                                return var13_22;
lbl204:
                                // 1 sources

                                catch (SQLException var20_57) {
                                    // empty catch block
                                }
                                return var13_22;
                            }
                            catch (SQLException var12_16) {
                                Log.log((String)var12_16.getLocalizedMessage());
                                var1_1.setError(var12_16.getLocalizedMessage());
                                var13_23 = false;
                                var19_47 = null;
                                ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl214:
                                // 1 sources

                                if (var11_11 == null) return var13_23;
                                var11_11.close();
                                return var13_23;
lbl217:
                                // 1 sources

                                catch (SQLException var20_58) {
                                    // empty catch block
                                }
                                return var13_23;
                            }
                            catch (Exception var12_17) {
                                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, var12_17.getStackTrace()[0].toString(), var12_17);
                                var13_24 = false;
                                var19_48 = null;
                                ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl226:
                                // 1 sources

                                if (var11_11 == null) return var13_24;
                                var11_11.close();
                                return var13_24;
lbl229:
                                // 1 sources

                                catch (SQLException var20_59) {
                                    // empty catch block
                                }
                                return var13_24;
                            }
                        }
                        catch (Throwable var18_61) {
                            var19_49 = null;
                            ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl236:
                            // 1 sources

                            if (var11_11 == null) throw var18_61;
                            var11_11.close();
                            throw var18_61;
lbl239:
                            // 1 sources

                            catch (SQLException var20_60) {
                                // empty catch block
                            }
                            throw var18_61;
                        }
                    }
                    var19_40 = null;
                    ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl245:
                    // 1 sources

                    if (var11_11 == null) return var14_28;
                    var11_11.close();
                    return var14_28;
lbl248:
                    // 1 sources

                    catch (SQLException var20_51) {
                        // empty catch block
                    }
                    return var14_28;
                }
                var19_41 = null;
                ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl254:
                // 1 sources

                if (var11_11 == null) return var14_29;
                var11_11.close();
                return var14_29;
lbl257:
                // 1 sources

                catch (SQLException var20_52) {
                    // empty catch block
                }
                return var14_29;
            }
            var19_42 = null;
            ** try [egrp 7[TRYBLOCK] [36 : 1867->1882)] { 
lbl263:
            // 1 sources

            if (var11_11 == null) return var14_30;
            var11_11.close();
            return var14_30;
lbl266:
            // 1 sources

            catch (SQLException var20_53) {
                // empty catch block
            }
            return var14_30;
        }
        var19_43 = null;
        try {}
        catch (SQLException var20_54) {
            // empty catch block
            return var14_31;
        }
        if (var11_11 == null) return var14_31;
        var11_11.close();
        return var14_31;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteRow(ResultSetTableModelBuffer var1_1) {
        block16: {
            block18: {
                block17: {
                    var3_2 = new StringBuffer("DELETE FROM ");
                    var3_2.append(this._tablename + " WHERE ROWID = ");
                    var4_3 = new StringBuffer(var3_2.toString());
                    var3_2.append("?");
                    var4_3.append(this.quote(var1_1.getRowId()));
                    if (this._dataIntegrity && !this._dbObjectType.equals("VIEW")) {
                        var3_2.append(" AND ORA_ROWSCN = ?");
                        var4_3.append(" AND ORA_ROWSCN = " + this.quote(var1_1.getRowscn()));
                        var5_4 = this.getColumnDBName(1);
                        var3_2.append(" and ( " + DBUtil.getInstance().addQuotes(this.getConnection(), (String)var5_4) + " is null or " + DBUtil.getInstance().addQuotes(this.getConnection(), (String)var5_4) + " is not null )");
                        var4_3.append(" and ( " + DBUtil.getInstance().addQuotes(this.getConnection(), (String)var5_4) + " is null or " + DBUtil.getInstance().addQuotes(this.getConnection(), (String)var5_4) + " is not null )");
                    }
                    this._log.add(var4_3.toString());
                    var5_4 = null;
                    try {
                        try {
                            var5_4 = this.getConnection().prepareStatement(var3_2.toString());
                            var5_4.setString(1, var1_1.getRowId());
                            if (this._dataIntegrity && !this._dbObjectType.equals("VIEW")) {
                                var5_4.setString(2, var1_1.getRowscn());
                            }
                            if ((var6_5 = var5_4.executeUpdate()) == 1) {
                                var1_1.setCommitted();
                                break block16;
                            }
                            if (var6_5 == 0) {
                                var1_1.setError(ConnectionArb.getString(96) + System.getProperty("line.separator"));
                                var7_7 = false;
                                var9_10 = null;
                                break block17;
                            }
                            var7_8 = true;
                            break block18;
                        }
                        catch (Exception var6_6) {
                            Log.log((String)var6_6.getLocalizedMessage());
                            var1_1.setError(var6_6.getLocalizedMessage());
                            var7_9 = false;
                            var9_13 = null;
                            try {
                                if (var5_4 == null) return var7_9;
                                var5_4.close();
                                return var7_9;
                            }
                            catch (SQLException var10_18) {
                                // empty catch block
                            }
                            return var7_9;
                        }
                    }
                    catch (Throwable var8_20) {
                        var9_14 = null;
                        ** try [egrp 2[TRYBLOCK] [7 : 450->465)] { 
lbl57:
                        // 1 sources

                        if (var5_4 == null) throw var8_20;
                        var5_4.close();
                        throw var8_20;
lbl60:
                        // 1 sources

                        catch (SQLException var10_19) {
                            // empty catch block
                        }
                        throw var8_20;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [7 : 450->465)] { 
lbl65:
                // 1 sources

                if (var5_4 == null) return var7_7;
                var5_4.close();
                return var7_7;
lbl68:
                // 1 sources

                catch (SQLException var10_15) {
                    // empty catch block
                }
                return var7_7;
            }
            var9_11 = null;
            try {}
            catch (SQLException var10_16) {
                // empty catch block
                return var7_8;
            }
            if (var5_4 == null) return var7_8;
            var5_4.close();
            return var7_8;
        }
        var9_12 = null;
        try {}
        catch (SQLException var10_17) {}
        if (var5_4 == null) return true;
        var5_4.close();
        return true;
        return true;
    }

    public void clearChanges() {
        for (int i = this._rows.size() - 1; i >= 0; --i) {
            Object e = this._rows.get(i);
            if (e == null || !(e instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            if (resultSetTableModelBuffer.getDeleted() && (resultSetTableModelBuffer.getCommitted() || resultSetTableModelBuffer.getNew()) || resultSetTableModelBuffer.getNew() && !resultSetTableModelBuffer.getChanged()) {
                this._rows.remove(i);
                continue;
            }
            if (!resultSetTableModelBuffer.getChanged() && !resultSetTableModelBuffer.getNew()) continue;
            resultSetTableModelBuffer.clearChanges();
        }
        this._changed = false;
    }

    public boolean getChanged() {
        return this._changed;
    }

    public boolean getValid() {
        return this._valid;
    }

    public boolean getUpdatedByAnotherUser() {
        return this._updatedByAnotherUser;
    }

    public void setChanged(boolean bl) {
        this._changed = bl;
    }

    @Override
    public void setOrderBy(String string) {
        this._orderByClause = string;
    }

    public void setOrderBy(int n) {
        if (this._tabColModel != null) {
            int n2 = this._tabColModel.getColumn(n).getModelIndex();
            if (this._orderByClause != null && this._orderByClause.indexOf(",") > -1 && this.getSortCol() != -1) {
                this.setSortCol(-1);
            } else {
                this.setSortCol(n2);
            }
            this._orderByClause = n2 > 0 && this.getSortCol() != -1 ? this.getRawColumnName(n) + this.getSortDirection() : null;
        }
    }

    private int getOrderByColumn(String string) {
        String string2 = string.substring(0, string.indexOf(" ")).replaceAll("\"", "");
        if (this._tabColModel != null && this._tabColModel.getColumn(this._colNames.indexOf(string2)) != null) {
            return this._tabColModel.getColumn(this._colNames.indexOf(string2)).getModelIndex();
        }
        return this._colNames.indexOf(string2) + 1;
    }

    public String getOrderByDir(String string) {
        if (string.toUpperCase().lastIndexOf("DESC") > -1) {
            return " desc";
        }
        return " asc";
    }

    @Override
    public void setWhere(String string) {
        this._whereClause = string;
    }

    @Override
    protected void _fetchNext(final int n) {
        final int n2 = this._getFetchSize();
        final int n3 = this._colNames.size() + this._colOffset;
        final ResultSet resultSet = this._rs;
        final int n4 = this._colOffset;
        final boolean bl = this._dataIntegrity;
        if (this._rows == null) {
            this._rows = new ArrayList();
        }
        final List list = this._rows;
        this._worker = new NamedSwingWorker("Fetching"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object construct() {
                ArrayList<ResultSetTableModelBuffer> arrayList = new ArrayList<ResultSetTableModelBuffer>(n2);
                Object object = EditableResultSetTableModel.this.LOCK;
                synchronized (object) {
                    try {
                        ResultSetCondition resultSetCondition;
                        for (int i = Math.max(n2, n); i > 0 && (resultSetCondition = EditableResultSetTableModel.this.testAndAdvanceResultSet(resultSet)) != ResultSetCondition.NO_MORE_ROWS; --i) {
                            if (resultSetCondition == ResultSetCondition.RESET) {
                                EditableResultSetTableModel.this.logger.log(Level.WARNING, "Result set is not usable, reopen, reset flag " + (Object)((Object)resultSetCondition));
                                EditableResultSetTableModel.this.set_resultSetInvalidFlag(true);
                                arrayList.clear();
                                break;
                            }
                            ArrayList<Object> arrayList2 = new ArrayList<Object>();
                            for (int j = 1 + n4; j <= n3; ++j) {
                                int n5 = EditableResultSetTableModel.this.getType(j - (1 + n4));
                                Object object2 = null;
                                if (resultSet instanceof OracleResultSet) {
                                    try {
                                        object2 = ((OracleResultSet)resultSet).getOracleObject(j);
                                    }
                                    catch (SQLException sQLException) {
                                        if (n5 == -4 || n5 == -1) {
                                            if (EditableResultSetTableModel.this._rs != null) {
                                                EditableResultSetTableModel.this._rs.close();
                                            }
                                            if (EditableResultSetTableModel.this._stmt != null) {
                                                EditableResultSetTableModel.this._stmt.close();
                                            }
                                            EditableResultSetTableModel.this._rs = null;
                                            EditableResultSetTableModel.this._stmt = null;
                                            if (!SwingUtilities.isEventDispatchThread()) {
                                                SwingUtilities.invokeLater(new Runnable(){

                                                    public void run() {
                                                        EditableResultSetTableModel.this.open();
                                                    }
                                                });
                                            } else {
                                                EditableResultSetTableModel.this.open();
                                            }
                                            return null;
                                        }
                                        throw sQLException;
                                    }
                                } else {
                                    object2 = resultSet.getObject(j);
                                }
                                if (n5 == 1111 && object2 instanceof ROWID) {
                                    String string = resultSet.getString(j);
                                    byte[] byArray = string.getBytes();
                                    object2 = new ROWID(byArray);
                                }
                                arrayList2.add(object2);
                            }
                            ResultSetTableModelBuffer resultSetTableModelBuffer = new ResultSetTableModelBuffer(arrayList2);
                            resultSetTableModelBuffer.setRowId(resultSet.getString(1));
                            if (bl && resultSet.getMetaData().getColumnName(2).equals("ORA_ROWSCN")) {
                                resultSetTableModelBuffer.setRowscn(resultSet.getString(2));
                            }
                            arrayList.add(resultSetTableModelBuffer);
                        }
                    }
                    catch (SQLException sQLException) {
                        EditableResultSetTableModel.this.logger.log(Level.SEVERE, "construct", sQLException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return arrayList;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                block12: {
                    Object object;
                    try {
                        if (!EditableResultSetTableModel.this.is_resultSetInvalidFlag()) break block13;
                        EditableResultSetTableModel.this.fireCustomTableModelEvent();
                        Object var6_1 = null;
                        object = EditableResultSetTableModel.this.LOCK;
                    }
                    catch (Throwable throwable) {
                        Object var6_3 = null;
                        Object object2 = EditableResultSetTableModel.this.LOCK;
                        synchronized (object2) {
                            EditableResultSetTableModel.this._worker = null;
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        EditableResultSetTableModel.this._worker = null;
                    }
                    {
                        int n5;
                        block13: {
                            return;
                        }
                        Object object3 = this.get();
                        if (!(object3 instanceof List)) break block12;
                        List list2 = (List)object3;
                        int n22 = list2.size();
                        if (n22 > 0) {
                            list.addAll(list2);
                        }
                        if (n22 < (n5 = Math.max(n2, n))) {
                            EditableResultSetTableModel.this._allFetched = true;
                            Log.status((String)(Translate.translate((String)"All Rows Fetched: ") + EditableResultSetTableModel.this.getRowCount()));
                        } else {
                            Log.status((String)(Translate.translate((String)"Fetched Rows: ") + EditableResultSetTableModel.this.getRowCount()));
                        }
                        EditableResultSetTableModel.this.fireTableDataChanged();
                    }
                }
                Object var6_2 = null;
                Object object = EditableResultSetTableModel.this.LOCK;
                synchronized (object) {
                    EditableResultSetTableModel.this._worker = null;
                }
            }
        };
        this._worker.start();
    }

    @Override
    public int getRowCount() {
        int n = 0;
        if (this._rows != null) {
            n = this._rows.size();
            if (!this._allFetched) {
                n += 5;
            }
        }
        return n;
    }

    private String formatValue(Object object) {
        if (object == null) {
            return " null ";
        }
        try {
            return this.getDatabase().quoteIdentifier(object.toString(), true);
        }
        catch (Exception exception) {
            return this.quote(object.toString());
        }
    }

    private String quote(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.replaceAll("'", "''");
        return "'" + string2 + "'";
    }

    private void _createColumnNamesList(boolean bl) throws SQLException {
        ResultSetMetaData resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this._colNames = new ArrayList(n - 1);
        int n2 = bl ? this._colOffset : 0;
        int[] nArray = new int[n - n2];
        int n3 = 0;
        for (int i = 1 + n2; i <= n; ++i) {
            this._colNames.add(resultSetMetaData.getColumnLabel(i));
            nArray[n3++] = resultSetMetaData.getColumnType(i);
        }
        this.setTypes(nArray);
    }

    private void _buildModifiedSql(boolean bl) throws SQLException {
        ResultSetTablePersistedSettings resultSetTablePersistedSettings;
        ResultSetMetaData resultSetMetaData = null;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer("SELECT ");
        if (this._isExternalTable && !(this.getDatabase() instanceof Oracle10gR2) || this.isOracle() && this.getEditableColumnNames().size() == 0) {
            bl2 = true;
            bl = true;
        }
        if (!bl2) {
            stringBuffer.append("ROWID,");
            this._colOffset = 1;
        }
        if (this.getDatabase() instanceof Oracle10gR2 && !bl) {
            stringBuffer.append(" ORA_ROWSCN,");
            this._colOffset = 2;
            this._dataIntegrity = true;
        }
        resultSetMetaData = this._rs.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append("\"" + resultSetMetaData.getColumnLabel(i) + "\"");
            int n2 = resultSetMetaData.getColumnType(i);
            if (n2 == 1111) {
                stringBuffer.append(" ||''  \"" + resultSetMetaData.getColumnLabel(i) + "\"");
            }
            if (i == n) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(" FROM " + this._tablename);
        this._settingsSQL = stringBuffer.toString().replaceAll("ROWID,", "").replaceAll("ORA_ROWSCN,", "").trim();
        if ((this._orderByClause == null || this._orderByClause.length() == 0) && (resultSetTablePersistedSettings = ResultSetTablePersistedSettings.loadPersistedSettings(this._settingsSQL)) != null) {
            this._orderByClause = resultSetTablePersistedSettings.getOrderByClause();
            if (this._orderByClause != null && this._orderByClause.indexOf(",") > -1 && this.getSortCol() != -1) {
                this.setSortCol(-1);
            } else if (this._orderByClause != null && this._orderByClause.indexOf(",") == -1) {
                this._createColumnNamesList(false);
                this.setSortCol(this.getOrderByColumn(this._orderByClause));
                this.setSortDirection(this.getOrderByDir(this._orderByClause));
            }
            resultSetTablePersistedSettings.savePersistentSettings(this._settingsSQL);
        }
        if (this._whereClause != null && this._whereClause.length() > 0) {
            stringBuffer.append(" WHERE " + this._whereClause);
        }
        if (this._orderByClause != null && this._orderByClause.length() > 0) {
            stringBuffer.append(" ORDER BY " + this._orderByClause);
        }
        this._modifiedSql = stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectRowscn(ResultSetTableModelBuffer var1_1) {
        block25: {
            block21: {
                block24: {
                    block20: {
                        var2_2 = "SELECT ORA_ROWSCN FROM " + this._tablename + " WHERE ROWID = ?";
                        var3_3 = null;
                        var4_4 = null;
                        try {
                            try {
                                var4_4 = this.getConnection().prepareStatement(var2_2);
                                var4_4.setString(1, var1_1.getRowId());
                                var3_3 = var4_4.executeQuery();
                                if (!var3_3.next()) {
                                    var7_5 = null;
                                    break block20;
                                }
                                var1_1.setRowscn(var3_3.getString(1));
                                break block21;
                            }
                            catch (SQLException var5_13) {
                                var7_7 = null;
                                try {
                                    if (var3_3 != null) {
                                        var3_3.close();
                                    }
                                }
                                catch (SQLException var8_11) {
                                    // empty catch block
                                }
                                try {
                                    if (var4_4 == null) return;
                                    var4_4.close();
                                    return;
                                }
                                catch (SQLException var8_11) {
                                    return;
                                }
                            }
                        }
                        catch (Throwable var6_14) {
                            block23: {
                                var7_8 = null;
                                ** try [egrp 2[TRYBLOCK] [6 : 114->127)] { 
lbl35:
                                // 1 sources

                                if (var3_3 != null) {
                                    var3_3.close();
                                }
                                break block23;
lbl38:
                                // 1 sources

                                catch (SQLException var8_12) {
                                    // empty catch block
                                }
                            }
                            ** try [egrp 3[TRYBLOCK] [7 : 129->144)] { 
lbl42:
                            // 1 sources

                            if (var4_4 == null) throw var6_14;
                            var4_4.close();
                            throw var6_14;
lbl45:
                            // 1 sources

                            catch (SQLException var8_12) {
                                // empty catch block
                            }
                            throw var6_14;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 114->127)] { 
lbl50:
                    // 1 sources

                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    break block24;
lbl53:
                    // 1 sources

                    catch (SQLException var8_9) {
                        // empty catch block
                    }
                }
                ** try [egrp 3[TRYBLOCK] [7 : 129->144)] { 
lbl57:
                // 1 sources

                if (var4_4 == null) return;
                var4_4.close();
                return;
lbl60:
                // 1 sources

                catch (SQLException var8_9) {
                    // empty catch block
                }
                return;
            }
            var7_6 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 114->127)] { 
lbl66:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block25;
lbl69:
            // 1 sources

            catch (SQLException var8_10) {
                // empty catch block
            }
        }
        try {}
        catch (SQLException var8_10) {}
        if (var4_4 == null) return;
        var4_4.close();
        return;
    }

    public String getColumnDBName(int n) {
        int n2 = n;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this._tabColModel == null || this._tabColModel.getColumn(i).getModelIndex() != n) continue;
            n2 = i;
            break;
        }
        if (n <= 0 || n2 == -1) {
            return null;
        }
        return this.getRawColumnName(n2);
    }

    @Override
    public String getRawColumnName(int n) {
        return (String)this._colNames.get(n);
    }

    public Border getRowCountBorder(int n, int n2) {
        Object var3_3 = this._rows.size() > n ? this._rows.get(n) : null;
        Border border = null;
        if (var3_3 != null && var3_3 instanceof ResultSetTableModelBuffer) {
            ResultSetTableModelBuffer resultSetTableModelBuffer = var3_3;
            if (n2 == 0 && resultSetTableModelBuffer.getDeleted()) {
                border = BorderFactory.createEtchedBorder(Color.RED, Color.BLACK);
            } else if (n2 == 0 && resultSetTableModelBuffer.getChanged()) {
                border = BorderFactory.createEtchedBorder(Color.BLUE, Color.BLACK);
            } else if (resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getNew()) {
                border = BorderFactory.createEtchedBorder(Color.GREEN, Color.BLACK);
            }
        }
        return border;
    }

    @Override
    public String getSQL() {
        if (this._modifiedSql != null) {
            return this._modifiedSql.replaceAll("ROWID,", "").replaceAll("ORA_ROWSCN,", "");
        }
        return null;
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        this._tabColModel = tableColumnModel;
    }

    public boolean isColumnEditable(String string) {
        for (String string2 : this.getEditableColumnNames()) {
            if (!string2.intern().equals(string.intern())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ArrayList<String> getEditableColumnNames() {
        block13: {
            if (this._editableColNames == null) {
                this._editableColNames = new ArrayList();
                ResultSet resultSet = null;
                resultSet = DBUtil.getInstance().executeQuery(this.getConnection(), EDITABLE_COLS, this.getDBObject().getDictionary());
                while (resultSet.next()) {
                    this._editableColNames.add(resultSet.getString(1));
                }
                Object var4_2 = null;
                try {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                        resultSet.close();
                    }
                    break block13;
                }
                catch (SQLException sQLException) {}
                break block13;
                {
                    catch (SQLException sQLException) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                        Object var4_3 = null;
                        try {
                            if (resultSet != null) {
                                resultSet.getStatement().close();
                                resultSet.close();
                            }
                            break block13;
                        }
                        catch (SQLException sQLException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.getStatement().close();
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return this._editableColNames;
    }

    public String getOrderByClause() {
        return this._orderByClause;
    }

    public String getPersistedSettingsSql() {
        return this._settingsSQL;
    }

    public List<ResultSetTableModelBuffer> getChangedRows() {
        ArrayList<ResultSetTableModelBuffer> arrayList = new ArrayList<ResultSetTableModelBuffer>();
        for (int i = 0; i < this._rows.size(); ++i) {
            ResultSetTableModelBuffer resultSetTableModelBuffer;
            if (!(this._rows.get(i) instanceof ResultSetTableModelBuffer) || !((resultSetTableModelBuffer = (ResultSetTableModelBuffer)this._rows.get(i)).getDeleted() && !resultSetTableModelBuffer.getNew() || resultSetTableModelBuffer.getChanged() && !resultSetTableModelBuffer.getNew() && !resultSetTableModelBuffer.getDeleted()) && (!resultSetTableModelBuffer.getNew() || !resultSetTableModelBuffer.getChanged() || resultSetTableModelBuffer.getDeleted())) continue;
            arrayList.add(resultSetTableModelBuffer);
        }
        return arrayList;
    }

    public void commit() throws SQLException {
        this.getConnection().commit();
        for (int i = 0; i < this._rows.size(); ++i) {
            Object e = this._rows.get(i);
            if (e == null || !(e instanceof ResultSetTableModelBuffer)) continue;
            ResultSetTableModelBuffer resultSetTableModelBuffer = (ResultSetTableModelBuffer)e;
            this.selectRowscn(resultSetTableModelBuffer);
        }
    }
}

