/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.navigator;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.navigator.CatalogFilter;
import oracle.dbtools.raptor.navigator.ConnectionFilter;
import oracle.dbtools.raptor.navigator.ConnectionStores;
import oracle.dbtools.raptor.navigator.ConnectionStoresFilter;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.NavWindow;
import oracle.dbtools.raptor.navigator.ObjectFilter;
import oracle.dbtools.raptor.navigator.ObjectNodeFilter;
import oracle.dbtools.raptor.navigator.OtherSchemasFilter;
import oracle.dbtools.raptor.navigator.SchemaFilter;
import oracle.dbtools.raptor.navigator.impl.CatalogFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockingParam;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.explorer.ExplorerManager;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.TextNode;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.net.URLFilter;
import oracle.ideri.navigator.DefaultNavigatorManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public abstract class BaseNavigatorManager
extends DefaultNavigatorManager {
    private static List<BaseNavigatorManager> s_mgrs = new ArrayList<BaseNavigatorManager>();
    private static List<FilterDesc> s_filters = new ArrayList<FilterDesc>();

    public static void addFilter(Class clazz, Class clazz2, URLFilter uRLFilter) {
        for (BaseNavigatorManager baseNavigatorManager : s_mgrs) {
            baseNavigatorManager.registerFilter(clazz, clazz2, uRLFilter);
        }
        s_filters.add(new FilterDesc(clazz, clazz2, uRLFilter));
    }

    public static void registerObjectNodeClass(String string, Class clazz) {
        BaseNavigatorManager.addFilter(clazz, ObjectNodeFilter.class, null);
        if (TextNode.class.isAssignableFrom(clazz)) {
            AddinManager addinManager = AddinManager.getAddinManager();
            EditorAddin editorAddin = (EditorAddin)addinManager.getAddin(CodeEditorAddin.class);
            EditorManager.getEditorManager().extend(editorAddin, new Class[]{clazz});
            CodeEditor.registerNodeType((Class)clazz, (String)CodeEditor.TYPE_PLSQL);
        }
    }

    protected BaseNavigatorManager() {
        s_mgrs.add(this);
    }

    protected float getToggleToolbarMenuWeight() {
        return MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR;
    }

    protected String getAcceleratorFile() {
        return super.getAcceleratorFile();
    }

    public static boolean isDatabaseNavigatorContext(Context context) {
        return context.getView() instanceof NavWindow;
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new NavWindow(context, viewId.getId(), this.getDefaultName());
    }

    protected void configureNavigator(NavigatorWindow navigatorWindow) {
        NavWindow navWindow = (NavWindow)navigatorWindow;
        navWindow.setDefaultVisibility(0);
    }

    protected DockingParam createNavigatorDockingParam() {
        DockingParam dockingParam = new DockingParam();
        NavigatorManager navigatorManager = NavigatorManager.getWorkspaceNavigatorManager();
        if (navigatorManager != null && navigatorManager.getNavigatorWindow() != null) {
            dockingParam.setPosition((Dockable)navigatorManager.getNavigatorWindow(), 4, 0);
        } else {
            ExplorerManager explorerManager = ExplorerManager.getExplorerManager();
            Dockable dockable = null;
            if (explorerManager != null) {
                ViewId viewId = explorerManager.getDefaultViewId();
                dockable = DockStation.getDockStation().findDockable(viewId);
            }
            dockingParam.setPosition(dockable, 2, 0);
        }
        return dockingParam;
    }

    public void initialize() {
        super.initialize();
        IdeAction ideAction = this.getShowAction();
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, MenuConstants.WEIGHT_VIEW_CONNECTION_NAVIGATOR);
        JMenu jMenu = MenuManager.getJMenu((String)"View");
        menubar.add((Component)jMenuItem, jMenu, MenuConstants.SECTION_VIEW_NAVIGATOR);
        for (FilterDesc filterDesc : s_filters) {
            this.registerFilter(filterDesc.m_elemClass, filterDesc.m_filterClass, filterDesc.m_urlFilter);
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_databaseconnections_html");
    }

    static {
        BaseNavigatorManager.addFilter(DatabaseConnection.class, ConnectionFilter.class, null);
        BaseNavigatorManager.addFilter(ObjectFolder.class, ObjectFilter.class, null);
        BaseNavigatorManager.addFilter(ObjectNode.class, ObjectNodeFilter.class, null);
        BaseNavigatorManager.addFilter(OtherSchemasFolder.class, OtherSchemasFilter.class, null);
        BaseNavigatorManager.addFilter(SchemaFolder.class, SchemaFilter.class, null);
        BaseNavigatorManager.addFilter(CatalogFolder.class, CatalogFilter.class, null);
        BaseNavigatorManager.addFilter(ConnectionStores.class, ConnectionStoresFilter.class, null);
    }

    private static class FilterDesc {
        private Class m_elemClass;
        private Class m_filterClass;
        private URLFilter m_urlFilter;

        private FilterDesc(Class clazz, Class clazz2, URLFilter uRLFilter) {
            this.m_elemClass = clazz;
            this.m_filterClass = clazz2;
            this.m_urlFilter = uRLFilter;
        }
    }
}

